/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.junit.framework.classification.rules;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;

public class MemoryLeakRule
extends TestWatcher {
    private static final boolean DEBUG = Boolean.getBoolean("MemoryLeakRule.debug");
    private static final int DEQUEUE_REF_ITERATIONS = 3;
    private static final int DEQUEUE_REF_TIMEOUT = 1000;
    private static final int GC_ITERATIONS = 10;
    private static final int CLEAR_SOFT_REFS_ITERATIONS = 3;
    private static final Map<Class<?>, Boolean> WARMED_UP_SUITES = new WeakHashMap();
    private static boolean warmingUp;
    private ReferenceQueue<Object> queue;
    private List<WeakReference<Object>> tracker;
    private String testName;
    private Class<?> testClass;
    private boolean isSoftReferenceSensitive;

    public void add(Object leak) {
        MatcherAssert.assertThat((String)"Cannot track null references for memory leaks.", (Object)leak, (Matcher)CoreMatchers.notNullValue());
        if (this.queue == null) {
            this.queue = new ReferenceQueue();
            this.tracker = Lists.newArrayList();
        }
        this.tracker.add(new WeakReference<Object>(leak, this.queue));
    }

    public String getTestName() {
        return this.testName;
    }

    protected void starting(Description description) {
        this.testName = description.getMethodName();
        this.testClass = description.getTestClass();
        boolean bl = this.isSoftReferenceSensitive = description.getAnnotation(SoftReferenceSensitive.class) != null;
        if (this.isSoftReferenceSensitive && !this.isWarmedUp() && !warmingUp) {
            warmingUp = true;
            try {
                this.warmUp();
            }
            finally {
                warmingUp = false;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void succeeded(Description description) {
        if (this.tracker != null) ** GOTO lbl16
        return;
lbl-1000:
        // 1 sources

        {
            ref = this.dequeueTracker();
            i = 0;
            while (ref == null && this.isSoftReferenceSensitive && i < 3) {
                this.forceClearSoftReferenceCaches();
                ref = this.dequeueTracker();
                ++i;
            }
            if (this.tracker.remove(ref) || this.tracker.isEmpty()) continue;
            leaks = Joiner.on((char)'\n').join(Iterables.transform(this.tracker, this.label()));
            if (MemoryLeakRule.warmingUp) {
                MemoryLeakRule.debug("Warm-up detected leaks: %s%n", new Object[]{leaks.replace('\n', ' ')});
            }
            Assert.fail((String)("One or more objects leaked:\n" + leaks));
            break;
lbl16:
            // 2 sources

            ** while (!this.tracker.isEmpty())
        }
lbl17:
        // 2 sources

    }

    protected void finished(Description description) {
        this.tracker = null;
        this.queue = null;
    }

    Reference<?> dequeueTracker() {
        Reference<Object> result = null;
        try {
            int i = 0;
            while (result == null && i < 3) {
                this.collectGarbage();
                result = this.queue.remove(1000L);
                ++i;
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Assert.fail((String)"JUnit was interrupted");
        }
        return result;
    }

    Function<WeakReference<?>, String> label() {
        return new Function<WeakReference<?>, String>(){

            public String apply(WeakReference<?> input) {
                return MemoryLeakRule.this.label(input.get());
            }
        };
    }

    String label(Object input) {
        String result = null;
        if (!(input instanceof EObject)) {
            result = String.valueOf(input);
        } else {
            EObject object = (EObject)input;
            EClass eclass = object.eClass();
            String label = null;
            EStructuralFeature nameFeature = eclass.getEStructuralFeature("name");
            if (nameFeature != null) {
                label = String.valueOf(object.eGet(nameFeature));
            } else {
                for (EAttribute next : eclass.getEAllAttributes()) {
                    if (!next.isMany() && next.getEAttributeType().getInstanceClass() == String.class && (label = (String)object.eGet((EStructuralFeature)next)) != null && !label.isEmpty()) break;
                }
            }
            result = String.format("<%s> %s", eclass.getName(), label);
        }
        return result;
    }

    void collectGarbage() {
        Long usedMem;
        Runtime rt = Runtime.getRuntime();
        Long prevUsedMem = usedMem = Long.valueOf(rt.totalMemory() - rt.freeMemory());
        int i = 0;
        while (prevUsedMem <= usedMem && i < 10) {
            rt.gc();
            Thread.yield();
            prevUsedMem = usedMem;
            usedMem = rt.totalMemory() - rt.freeMemory();
            ++i;
        }
    }

    void forceClearSoftReferenceCaches() {
        try {
            try {
                LinkedList hog = Lists.newLinkedList();
                while (true) {
                    hog.add(new Object[MemoryLeakRule.getLargeMemorySize()]);
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                if (warmingUp) {
                    WARMED_UP_SUITES.put(this.testClass, true);
                }
            }
        }
        catch (Throwable throwable) {
            if (warmingUp) {
                WARMED_UP_SUITES.put(this.testClass, true);
            }
            throw throwable;
        }
    }

    private static int getLargeMemorySize() {
        return 0x4000000;
    }

    private boolean isWarmedUp() {
        return Boolean.TRUE.equals(WARMED_UP_SUITES.get(this.testClass));
    }

    private void warmUp() {
        try {
            MemoryLeakRule.debug("Warming up test suite: %s (%s)%n", this.testClass.getName(), this.testName);
            new JUnitCore().run(Request.method(this.testClass, (String)this.testName));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void debug(String format, Object ... args) {
        if (DEBUG) {
            System.err.printf("[MEM] " + format, args);
        }
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface SoftReferenceSensitive {
    }
}

