/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.figures;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.e4.ui.css.core.css2.CSS2ColorHelper;
import org.eclipse.gmf.runtime.draw2d.ui.figures.RoundedRectangleBorder;
import org.eclipse.gmf.runtime.draw2d.ui.graphics.ColorRegistry;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.IRoundedRectangleFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.PapyrusWrappingLabel;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.SubCompartmentLayoutManager;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.FigureUtils;
import org.eclipse.papyrus.uml.diagram.common.figure.node.AutomaticCompartmentLayoutManager;
import org.eclipse.papyrus.uml.diagram.common.figure.node.IPapyrusNodeUMLElementFigure;
import org.eclipse.papyrus.uml.diagram.common.figure.node.PapyrusNodeFigure;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.css.RGBColor;

public class InterruptibleActivityRegionFigure
extends PapyrusNodeFigure
implements IPapyrusNodeUMLElementFigure,
IFigure,
IRoundedRectangleFigure {
    private Map<String, RectangleFigure> containerFigures;
    protected Dimension cornerDimension = new Dimension();
    protected boolean isOval = false;
    protected boolean isLabelConstrained = false;
    protected Dimension floatingNameOffset = new Dimension();
    protected int borderStyle = 1;
    private Border cachedBorder;
    private int cachedTransparency;
    private int shadowWidth = 4;
    String shadowColor = null;

    public String getShadowColor() {
        return this.shadowColor;
    }

    public void setShadowColor(String shadowColor) {
        this.shadowColor = shadowColor;
    }

    public void setBorderStyle(int borderStyle) {
        this.borderStyle = borderStyle;
        if (this.shadowborder != null) {
            this.shadowborder.setStyle(borderStyle);
        }
    }

    public InterruptibleActivityRegionFigure() {
        this(null, null);
    }

    public InterruptibleActivityRegionFigure(List<String> compartmentFigure) {
        this(compartmentFigure, null);
    }

    public InterruptibleActivityRegionFigure(List<String> compartmentFigure, String taggedLabelValue) {
        this.setOpaque(false);
        this.setLayoutManager((LayoutManager)new AutomaticCompartmentLayoutManager());
        if (compartmentFigure != null) {
            this.createContentPane(compartmentFigure);
        }
    }

    public void setShadowWidth(int shadowWidth) {
        this.shadowWidth = shadowWidth;
    }

    public void setIsPackage(boolean isPackage) {
    }

    protected void createContentPane(List<String> compartmentFigure) {
        this.containerFigures = new HashMap<String, RectangleFigure>();
        for (String id : compartmentFigure) {
            RectangleFigure newFigure = new RectangleFigure();
            newFigure.setLayoutManager((LayoutManager)new SubCompartmentLayoutManager());
            newFigure.setFill(false);
            newFigure.setBorder(null);
            newFigure.setOutline(false);
            newFigure.setOpaque(false);
            this.add((IFigure)newFigure);
            this.containerFigures.put(id, newFigure);
        }
    }

    public RectangleFigure getCompartment(String id) {
        return this.containerFigures.get(id);
    }

    public Dimension getCornerDimensions() {
        return this.cornerDimension;
    }

    public Rectangle getRoundedRectangleBounds() {
        return this.getBounds();
    }

    public void paintFigure(Graphics graphics) {
        graphics.pushState();
        Rectangle rectangle = this.getBounds().getCopy();
        Rectangle clipRectangle = this.getBounds().getCopy();
        this.refreshCornerSizeWhenOval();
        this.applyTransparency(graphics);
        if (this.cachedBorder != null) {
            this.setBorder(this.cachedBorder);
            this.cachedBorder = null;
        }
        if (this.isShadow()) {
            this.setShadowTransparency(graphics, true);
            rectangle.translate(this.shadowWidth, this.shadowWidth);
            graphics.getClip(clipRectangle);
            clipRectangle.width += this.shadowWidth;
            clipRectangle.height += this.shadowWidth;
            graphics.setClip(clipRectangle);
            this.setShadowBackgroudColor(graphics);
            graphics.fillRoundRectangle(rectangle, this.cornerDimension.width, this.cornerDimension.height);
            rectangle.translate(-this.shadowWidth, -this.shadowWidth);
            clipRectangle.width -= this.shadowWidth;
            clipRectangle.height -= this.shadowWidth;
            graphics.setClip(clipRectangle);
            this.setShadowTransparency(graphics, false);
        }
        if (this.isUsingGradient()) {
            Pattern pattern = this.getGradientPattern();
            graphics.setBackgroundPattern(pattern);
            graphics.fillRoundRectangle(rectangle, this.cornerDimension.width, this.cornerDimension.height);
            graphics.setBackgroundPattern(null);
            pattern.dispose();
        } else {
            graphics.pushState();
            graphics.setBackgroundColor(this.getBackgroundColor());
            graphics.setForegroundColor(this.getForegroundColor());
            graphics.fillRoundRectangle(rectangle, this.cornerDimension.width, this.cornerDimension.height);
            graphics.popState();
        }
        graphics.popState();
    }

    private void setShadowBackgroudColor(Graphics graphics) {
        if (this.shadowColor != null) {
            RGBColor rgbColor = CSS2ColorHelper.getRGBColor((String)this.shadowColor);
            int red = Integer.parseInt(rgbColor.getRed().toString());
            int green = Integer.parseInt(rgbColor.getGreen().toString());
            int blue = Integer.parseInt(rgbColor.getBlue().toString());
            Color color = new Color((Device)Display.getCurrent(), new RGB(red, green, blue));
            graphics.setBackgroundColor(color);
        } else {
            graphics.setBackgroundColor(this.getForegroundColor());
        }
    }

    private void setShadowTransparency(Graphics graphics, boolean toApplied) {
        if (toApplied) {
            this.cachedTransparency = this.getTransparency();
            int transparency = this.cachedTransparency + (100 - this.cachedTransparency) / 2;
            if (transparency > 100) {
                transparency = 100;
            }
            this.setTransparency(transparency);
            this.applyTransparency(graphics);
        } else {
            this.setTransparency(this.cachedTransparency);
            this.applyTransparency(graphics);
        }
    }

    private Pattern getGradientPattern() {
        Rectangle rectangle = this.getBounds().getCopy();
        boolean isVertical = this.getGradientStyle() == 0;
        Point startGradientPoint = rectangle.getTopLeft();
        Point endGradientPoint = rectangle.getBottomRight();
        if (isVertical) {
            endGradientPoint.x = startGradientPoint.x = rectangle.getTopLeft().x + rectangle.width() / 2;
        } else {
            endGradientPoint.y = startGradientPoint.y = rectangle.getTopLeft().y + rectangle.height() / 2;
        }
        double scale = FigureUtils.getScale((IFigure)this);
        startGradientPoint.scale(scale);
        endGradientPoint.scale(scale);
        int alpha = (int)(2.55 * (100.0 - (double)this.getTransparency()));
        Pattern pattern = new Pattern((Device)Display.getCurrent(), (float)startGradientPoint.x, (float)startGradientPoint.y, (float)endGradientPoint.x, (float)endGradientPoint.y, ColorRegistry.getInstance().getColor(Integer.valueOf(this.getGradientColor2())), alpha, ColorRegistry.getInstance().getColor(Integer.valueOf(this.getGradientColor1())), alpha);
        return pattern;
    }

    public void setShadow(boolean shadow) {
        super.setShadow(shadow);
        this.refreshCornerSizeWhenOval();
        RoundedRectangleBorder border = new RoundedRectangleBorder(this.cornerDimension.width, this.cornerDimension.height){

            public void paint(IFigure figure, Graphics graphics, Insets insets) {
                int transparency = 255 - ((NodeFigure)figure).getTransparency() * 255 / 100;
                graphics.setAlpha(transparency);
                super.paint(figure, graphics, insets);
            }
        };
        border.setWidth(this.getLineWidth());
        border.setStyle(this.borderStyle);
        this.setBorder((Border)border);
        this.setLineStyle(this.borderStyle);
    }

    private void refreshCornerSizeWhenOval() {
        if (this.isOval && (this.cornerDimension.width != this.getBounds().width || this.cornerDimension.height != this.getBounds().height)) {
            this.cornerDimension.width = this.getBounds().width;
            this.cornerDimension.height = this.getBounds().height;
            this.setShadow(this.isShadow());
        }
    }

    public void setCornerDimensions(Dimension cornerDimension) {
        this.cornerDimension = cornerDimension;
    }

    public void setOval(boolean booleanValue) {
        this.isOval = booleanValue;
        if (booleanValue) {
            this.refreshCornerSizeWhenOval();
        }
    }

    public boolean isOval() {
        return this.isOval;
    }

    public void setFloatingNameConstrained(boolean booleanValue) {
        this.isLabelConstrained = booleanValue;
    }

    public boolean isFloatingNameConstrained() {
        return this.isLabelConstrained;
    }

    public void setFloatingNameOffset(Dimension offset) {
        this.floatingNameOffset = offset;
    }

    public Dimension getFloatingNameOffset() {
        return this.floatingNameOffset;
    }

    public Rectangle getPackageHeader() {
        return null;
    }

    public void setHasHeader(boolean hasHeader) {
    }

    public boolean hasHeader() {
        return false;
    }

    public void setStereotypeDisplay(String stereotypes, Image image) {
    }

    public void setStereotypePropertiesInBrace(String stereotypeProperties) {
    }

    public void setStereotypePropertiesInCompartment(String stereotypeProperties) {
    }

    public PapyrusWrappingLabel getStereotypesLabel() {
        return null;
    }

    public String getNameBackgroundColor() {
        return null;
    }

    public void setNameBackgroundColor(String labelBackgroundColor) {
    }
}

