/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.uml.diagram.statemachine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.editor.PapyrusMultiDiagramEditor;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationUtils;
import org.eclipse.papyrus.sirius.uml.diagram.statemachine.ElementToRefresh;
import org.eclipse.papyrus.sirius.uml.diagram.statemachine.custom.StateMachineRegionPolicy;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.parsers.OpaqueBehaviorViewUtil;
import org.eclipse.papyrus.uml.diagram.statemachine.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.internationalization.utils.utils.UMLLabelInternationalization;
import org.eclipse.papyrus.uml.tools.utils.ValueSpecificationUtil;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.ContainerLayout;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.impl.DNodeContainerImpl;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusGMFHelper;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusLayoutDataManager;
import org.eclipse.sirius.diagram.ui.business.internal.view.AbstractLayoutData;
import org.eclipse.sirius.diagram.ui.business.internal.view.RootLayoutData;
import org.eclipse.sirius.diagram.ui.internal.refresh.GMFHelper;
import org.eclipse.ui.IEditorPart;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.ChangeEvent;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.TimeEvent;
import org.eclipse.uml2.uml.TimeExpression;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.ValueSpecification;

public class StateMachineServices {
    public boolean isInitialPseudoState(EObject object) {
        return object instanceof Pseudostate && ((Pseudostate)object).getKind() == PseudostateKind.INITIAL_LITERAL;
    }

    public boolean checkDropableElement(EObject dropable, EObject containerView) {
        if (dropable instanceof Region) {
            return this.checkDropableRegion(dropable, containerView);
        }
        if (dropable instanceof State) {
            return this.checkDropableState(dropable, containerView);
        }
        if (dropable instanceof StateMachine) {
            return this.checkDropableStateMachine(dropable, containerView);
        }
        if (dropable instanceof Pseudostate) {
            return this.checkDropablePseudostate(dropable, containerView);
        }
        if (dropable instanceof Constraint) {
            return this.checkDropableConstraint(dropable, containerView);
        }
        if (dropable instanceof Comment) {
            return this.checkDropableComment(dropable, containerView);
        }
        return false;
    }

    private boolean checkDropableComment(EObject dropable, EObject containerView) {
        DNodeContainer nodeContainerView;
        EObject target;
        return containerView instanceof DNodeContainer && (target = (nodeContainerView = (DNodeContainer)containerView).getTarget()) instanceof Region && ((Region)target).getOwnedComments().contains((Object)dropable);
    }

    private boolean checkDropableConstraint(EObject dropable, EObject containerView) {
        EObject stateParent;
        DNodeContainer nodeContainerView;
        EObject target;
        return containerView instanceof DNodeContainer && (target = (nodeContainerView = (DNodeContainer)containerView).getTarget()) instanceof Region && ((State)(stateParent = this.getStateParent(target))).getOwnedRules().contains((Object)dropable);
    }

    private boolean checkDropablePseudostate(EObject dropable, EObject containerView) {
        if (containerView instanceof DNodeContainer) {
            DNodeContainer nodeContainerView = (DNodeContainer)containerView;
            EObject target = nodeContainerView.getTarget();
            if (target instanceof Region && ((Region)target).getSubvertices().contains((Object)dropable)) {
                return true;
            }
            if (target instanceof State && ((State)target).getConnectionPoints().contains((Object)dropable)) {
                return true;
            }
            if (target instanceof StateMachine && ((StateMachine)target).getConnectionPoints().contains((Object)dropable)) {
                return true;
            }
        }
        return false;
    }

    private boolean checkDropableState(EObject dropable, EObject containerView) {
        DNodeContainer nodeContainerView;
        EObject target;
        return containerView instanceof DNodeContainer && (target = (nodeContainerView = (DNodeContainer)containerView).getTarget()) instanceof Region && ((Region)target).getSubvertices().contains((Object)dropable);
    }

    private boolean checkDropableStateMachine(EObject dropable, EObject containerView) {
        DNodeContainer nodeContainerView;
        EObject target;
        return containerView instanceof DNodeContainer && (target = (nodeContainerView = (DNodeContainer)containerView).getTarget()) instanceof Model && ((Model)target).getPackagedElements().contains((Object)dropable);
    }

    private boolean checkDropableRegion(EObject dropable, EObject containerView) {
        if (containerView instanceof DNodeContainer) {
            DNodeContainer nodeContainerView = (DNodeContainer)containerView;
            EObject target = nodeContainerView.getTarget();
            if (target instanceof StateMachine && ((StateMachine)target).getRegions().contains((Object)dropable)) {
                return true;
            }
            if (target instanceof State && ((State)target).getRegions().contains((Object)dropable)) {
                return true;
            }
            if (target instanceof Region) {
                EObject eContainer = target.eContainer();
                if (eContainer instanceof StateMachine && ((StateMachine)eContainer).getRegions().contains((Object)dropable)) {
                    return true;
                }
                if (eContainer instanceof State && ((State)eContainer).getRegions().contains((Object)dropable)) {
                    return true;
                }
            }
        }
        return false;
    }

    public EObject getRegionParent(EObject object) {
        if (object instanceof Region) {
            return object;
        }
        if (object instanceof StateMachine) {
            return (EObject)((StateMachine)object).getRegions().get(0);
        }
        if (object instanceof State) {
            return this.getRegionParent(object.eContainer());
        }
        if (object instanceof Pseudostate) {
            return this.getRegionParent(object.eContainer());
        }
        return null;
    }

    public EObject getStateParent(EObject context) {
        if (context instanceof State || context instanceof StateMachine) {
            return context;
        }
        if (context instanceof Region) {
            return this.getStateParent(context.eContainer());
        }
        return null;
    }

    public Collection<?> getFeatures(EObject object) {
        if (object instanceof Region) {
            return this.getFeatures(object.eContainer());
        }
        if (object instanceof State) {
            return ((State)object).getRegions();
        }
        if (object instanceof StateMachine) {
            return ((StateMachine)object).getRegions();
        }
        return null;
    }

    public EObject getStateViewParent(EObject context) {
        if (context instanceof DNodeContainer) {
            if (((DNodeContainer)context).getTarget() instanceof State) {
                return context;
            }
            if (((DNodeContainer)context).getTarget() instanceof StateMachine) {
                return context;
            }
            if (((DNodeContainer)context).getTarget() instanceof Region) {
                if (((DNodeContainer)context).getActualMapping().getName().contains("Horizontal") || ((DNodeContainer)context).getActualMapping().getName().contains("Vertical")) {
                    return context;
                }
                return this.getStateViewParent(context.eContainer());
            }
        }
        return null;
    }

    private EObject getStateView(EObject context) {
        if (context instanceof DNodeContainer) {
            if (((DNodeContainer)context).getTarget() instanceof State) {
                return context;
            }
            if (((DNodeContainer)context).getTarget() instanceof Region) {
                return this.getStateView(context.eContainer());
            }
        }
        return null;
    }

    public EObject setChildRepresentation(EObject context, String value) {
        if (context instanceof DNodeContainer) {
            if (value.equals("H")) {
                ((DNodeContainer)context).setChildrenPresentation(ContainerLayout.HORIZONTAL_STACK);
            }
            if (value.equals("V")) {
                ((DNodeContainer)context).setChildrenPresentation(ContainerLayout.VERTICAL_STACK);
            }
            if (value.equals("F")) {
                ((DNodeContainer)context).setChildrenPresentation(ContainerLayout.FREE_FORM);
            }
        }
        return context;
    }

    public ContainerMapping getContainerMapping(DNodeContainer context, String position) {
        DNodeContainer stateViewParent = (DNodeContainer)this.getStateView((EObject)context);
        EList subContainerMappings = stateViewParent.getActualMapping().getSubContainerMappings();
        for (ContainerMapping containerMapping : subContainerMappings) {
            if (!containerMapping.getName().equals(position)) continue;
            return containerMapping;
        }
        return null;
    }

    public EObject sortElement(EObject object, EObject containerView) {
        if (containerView instanceof DNodeContainer) {
            DNodeContainer container = (DNodeContainer)containerView;
            container.getActualMapping().setChildrenPresentation(null);
        }
        return object;
    }

    public boolean isVertical(EObject object, EObject containerView) {
        if (containerView instanceof DNodeContainer) {
            View view = SiriusGMFHelper.getGmfView((DDiagramElement)((DNodeContainer)containerView));
            Node gmfnode = (Node)view;
            String dropLocation = this.getDropLocation((View)gmfnode);
            if (StateMachineRegionPolicy.Zone.isTop(dropLocation)) {
                return false;
            }
            if (StateMachineRegionPolicy.Zone.isLeft(dropLocation)) {
                return true;
            }
            if (StateMachineRegionPolicy.Zone.isRight(dropLocation)) {
                return true;
            }
            if (StateMachineRegionPolicy.Zone.isBottom(dropLocation)) {
                return false;
            }
        }
        return false;
    }

    public boolean isHorizontal(EObject object, EObject containerView) {
        if (containerView instanceof DNodeContainer) {
            View view = SiriusGMFHelper.getGmfView((DDiagramElement)((DNodeContainer)containerView));
            Node gmfnode = (Node)view;
            String dropLocation = this.getDropLocation((View)gmfnode);
            if (StateMachineRegionPolicy.Zone.isTop(dropLocation)) {
                return true;
            }
            if (StateMachineRegionPolicy.Zone.isLeft(dropLocation)) {
                return false;
            }
            if (StateMachineRegionPolicy.Zone.isRight(dropLocation)) {
                return false;
            }
            if (StateMachineRegionPolicy.Zone.isBottom(dropLocation)) {
                return true;
            }
        }
        return false;
    }

    public String getDropLocation(EObject object, EObject containerView) {
        String result = "";
        if (containerView instanceof DNodeContainer) {
            View view = SiriusGMFHelper.getGmfView((DDiagramElement)((DNodeContainer)containerView));
            Node gmfnode = (Node)view;
            result = this.getDropLocation((View)gmfnode);
        }
        return result;
    }

    private Rectangle getFreeformViewport(View element) {
        IEditorPart activeEditor;
        Map editPartRegistry;
        Object editPart;
        IEditorPart editor = EclipseUIUtil.getActiveEditor();
        if (editor instanceof PapyrusMultiDiagramEditor && (editPart = (editPartRegistry = ((DiagramEditor)(activeEditor = ((PapyrusMultiDiagramEditor)editor).getActiveEditor())).getDiagramGraphicalViewer().getEditPartRegistry()).get(element)) instanceof IGraphicalEditPart) {
            IGraphicalEditPart result = (IGraphicalEditPart)editPart;
            return result.getContentPane().getParent().getBounds();
        }
        return null;
    }

    private String getDropLocation(View element) {
        Optional editPart = GMFHelper.getGraphicalEditPart((View)element);
        if (editPart.isPresent()) {
            editPart.get();
            List children = ((GraphicalEditPart)editPart.get()).getChildren();
            for (Object object : children) {
                EditPart part;
                EditPolicy editPolicy;
                if (!(object instanceof EditPart) || !((editPolicy = (part = (EditPart)object).getEditPolicy((Object)"CreationPolicy")) instanceof StateMachineRegionPolicy)) continue;
                return ((StateMachineRegionPolicy)editPolicy).getDropLocation();
            }
        }
        return null;
    }

    public String getHeight(EObject object, EObject object2, EObject containerView) {
        if (containerView instanceof DNodeContainer) {
            View view = SiriusGMFHelper.getGmfView((DDiagramElement)((DNodeContainer)containerView));
            Node gmfnode = (Node)view;
            Rectangle bounds = this.getFreeformViewport((View)gmfnode);
            return "" + (bounds.height + 1) / 10;
        }
        return "-1";
    }

    public String getWidth(EObject object, EObject object2, EObject containerView) {
        if (containerView instanceof DNodeContainer) {
            View view = SiriusGMFHelper.getGmfView((DDiagramElement)((DNodeContainer)containerView));
            Node gmfnode = (Node)view;
            Rectangle bounds = this.getFreeformViewport((View)gmfnode);
            return "" + (bounds.width + 1) / 10;
        }
        return "-1";
    }

    public EObject moveChildrenView(EObject containerView, EObject newView) {
        if (newView instanceof DNodeContainerImpl) {
            Collection children = (Collection)((DNodeContainerImpl)containerView).eGet(24, false, false);
            for (Object object : children) {
                if (!(object instanceof AbstractDNode)) continue;
                View view = SiriusGMFHelper.getGmfView((DDiagramElement)((AbstractDNode)object));
                Rectangle bounds = this.getFreeformViewport(view);
                ElementToRefresh.addPositionElement((AbstractDNode)object, bounds);
            }
            ArrayList list = new ArrayList();
            for (Object next : children) {
                if (next instanceof DNodeContainer && ((DNodeContainer)next).getTarget() instanceof Region || next.equals(containerView)) continue;
                list.add(next);
            }
            ((DNodeContainerImpl)newView).eSet(24, list);
        }
        return newView;
    }

    public void applyLayoutData(EObject object, EObject containerView) {
        if (containerView instanceof DNodeContainer) {
            DDiagram parentDiagram = ((DNodeContainer)containerView).getParentDiagram();
            EList diagramElements = parentDiagram.getDiagramElements();
            for (DDiagramElement dDiagramElement : diagramElements) {
                if (dDiagramElement instanceof DNodeContainer && ((DNodeContainer)dDiagramElement).getActualMapping().getName().equals("SMD_RegionCompartment") || !ElementToRefresh.toReposition.containsKey(dDiagramElement)) continue;
                Rectangle rectangle = ElementToRefresh.toReposition.get(dDiagramElement);
                Point point = new Point(rectangle.x, rectangle.y);
                Dimension dim = new Dimension(rectangle.width, rectangle.height);
                RootLayoutData layoutData = new RootLayoutData((Object)dDiagramElement, point, dim);
                this.manageSubLayoutData(dDiagramElement);
                SiriusLayoutDataManager.INSTANCE.addData((AbstractLayoutData)layoutData);
            }
        }
        ElementToRefresh.toReposition.clear();
    }

    private void manageSubLayoutData(DDiagramElement element) {
        if (element instanceof DNodeContainer) {
            ArrayList ownedDiagramElements = new ArrayList(((DNodeContainer)element).getOwnedDiagramElements());
            EList ownedBorderedNodes = ((DNodeContainer)element).getOwnedBorderedNodes();
            ownedDiagramElements.addAll(ownedBorderedNodes);
            for (DDiagramElement dDiagramElement : ownedDiagramElements) {
                View view = SiriusGMFHelper.getGmfView((DDiagramElement)dDiagramElement);
                Rectangle rectangle = this.getFreeformViewport(view);
                Point point = new Point(rectangle.x, rectangle.y);
                Dimension dim = new Dimension(rectangle.width, rectangle.height);
                RootLayoutData subLayout = new RootLayoutData((Object)dDiagramElement, point, dim);
                this.manageSubLayoutData(dDiagramElement);
                SiriusLayoutDataManager.INSTANCE.addData((AbstractLayoutData)subLayout);
            }
        }
    }

    public List<DDiagramElement> getChildrenView(EObject object) {
        if (object instanceof DNodeContainer) {
            List<DDiagramElement> ownedDiagramElements = ((DNodeContainer)object).getOwnedDiagramElements().stream().filter(d -> d instanceof DNodeContainer).map(d -> (DNodeContainer)d).filter(d -> d.getActualMapping().getName().equals("SMD_RegionCompartment")).collect(Collectors.toList());
            return ownedDiagramElements;
        }
        return null;
    }

    public void setBounds(EObject containerView) {
        if (containerView instanceof DNodeContainer) {
            IFigure figure;
            Map editPartRegistry;
            AbstractGraphicalEditPart editPart;
            EditPart parent;
            View view = SiriusGMFHelper.getGmfView((DDiagramElement)((DNodeContainer)containerView));
            IEditorPart editor = EclipseUIUtil.getActiveEditor();
            if (editor instanceof DiagramEditor && (parent = (editPart = (AbstractGraphicalEditPart)(editPartRegistry = ((DiagramEditor)editor).getDiagramGraphicalViewer().getEditPartRegistry()).get(view)).getParent()) instanceof AbstractGraphicalEditPart && (figure = ((AbstractGraphicalEditPart)parent).getFigure()) != null) {
                Rectangle bounds = figure.getBounds();
                Point point = new Point(bounds.x, bounds.y);
                Dimension dim = new Dimension(bounds.width, bounds.height);
                SiriusLayoutDataManager.INSTANCE.addData((AbstractLayoutData)new RootLayoutData((Object)containerView, point, dim));
            }
        }
    }

    public List<?> targeFinderExpressionForConstraint(EObject object) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (object instanceof Comment) {
            Comment comment = (Comment)object;
            EList annotatedElements = comment.getAnnotatedElements();
            for (Element element : annotatedElements) {
                if (element instanceof Region) {
                    EObject stateParent = this.getStateParent((EObject)element);
                    result.add(stateParent);
                    continue;
                }
                result.add(element);
            }
        }
        if (object instanceof Constraint) {
            Constraint constraint = (Constraint)object;
            EList constrainedElements = constraint.getConstrainedElements();
            result.addAll((Collection<Object>)constrainedElements);
        }
        return result;
    }

    public String getConstraintLabel(EObject object) {
        if (object instanceof Constraint) {
            String name = ((Constraint)object).getName();
            EList languages = null;
            EList bodies = null;
            ValueSpecification specification = ((Constraint)object).getSpecification();
            if (specification instanceof OpaqueExpression) {
                languages = ((OpaqueExpression)specification).getLanguages();
                bodies = ((OpaqueExpression)specification).getBodies();
            }
            String langage = "";
            if (languages != null && !languages.isEmpty()) {
                langage = (String)languages.get(0);
            }
            String body = "";
            if (bodies != null && !bodies.isEmpty()) {
                body = (String)bodies.get(0);
            }
            String result = name + "\n{{" + langage + "}" + body + "}";
            return result;
        }
        return "";
    }

    public EObject setBody(EObject context, String value) {
        ValueSpecification specification;
        if (context instanceof Constraint && (specification = ((Constraint)context).getSpecification()) instanceof OpaqueExpression) {
            EList bodies = ((OpaqueExpression)specification).getBodies();
            bodies.remove(0);
            bodies.add(0, (Object)value);
        }
        return context;
    }

    public String getBodyFromConstraint(EObject object) {
        if (object instanceof Constraint) {
            EList bodies = null;
            ValueSpecification specification = ((Constraint)object).getSpecification();
            if (specification instanceof OpaqueExpression) {
                bodies = ((OpaqueExpression)specification).getBodies();
            }
            String body = "";
            if (bodies != null && !bodies.isEmpty()) {
                body = (String)bodies.get(0);
            }
            String result = body;
            return result;
        }
        return "";
    }

    public EObject getContextParent(EObject element) {
        if (element instanceof Constraint) {
            EObject eContainer = element.eContainer();
            return eContainer;
        }
        return null;
    }

    public boolean checkContainerViewContext(EObject element, EObject containerView) {
        DNodeContainer stateViewParent;
        EObject eContainer;
        return !(containerView instanceof DNode) || !((eContainer = containerView.eContainer()) instanceof DNodeContainer) || !(stateViewParent = (DNodeContainer)this.getStateViewParent(eContainer)).getTarget().equals(element.eContainer());
    }

    public EObject getContextParentView(EObject object) {
        if (object instanceof DNodeContainer) {
            return this.getStateViewParent(object);
        }
        if (object instanceof DNode) {
            return this.getContextParentView(object.eContainer());
        }
        return null;
    }

    public boolean getPreCondition(EObject object) {
        if (object instanceof Package) {
            return true;
        }
        if (object instanceof StateMachine) {
            return true;
        }
        return object instanceof State;
    }

    public EObject getRoot(EObject object) {
        if (object instanceof Model) {
            return object;
        }
        if (object instanceof StateMachine) {
            return ((StateMachine)object).getModel();
        }
        return null;
    }

    public int computeBorderLineSize(EObject context, EObject view) {
        if (view instanceof DNodeContainer && ((DNodeContainer)view).getActualMapping().getName().equals("SMD_RegionCompartment") && ((DNodeContainer)view).getElements().size() > 0) {
            return 0;
        }
        return 1;
    }

    public EObject getOtherRegion(DNodeContainer containerView, EObject object) {
        EList ownedDiagramElements = containerView.getOwnedDiagramElements();
        for (DDiagramElement dDiagramElement : ownedDiagramElements) {
            if (dDiagramElement.getTarget().equals(object)) continue;
            return dDiagramElement;
        }
        return null;
    }

    public void saveInitialStateMachine(EObject object) {
        if (object instanceof StateMachine) {
            ElementToRefresh.saveStateMachine((StateMachine)object);
        }
    }

    public List<?> getStateElement(EObject container, EObject containerView) {
        EObject target;
        if (containerView instanceof DSemanticDiagram) {
            EObject target2 = ((DSemanticDiagram)containerView).getTarget();
            if (target2 instanceof State) {
                ArrayList<EObject> list = new ArrayList<EObject>();
                list.add(target2);
                return list;
            }
        } else if (containerView instanceof DNodeContainer && (target = ((DNodeContainer)containerView).getTarget()) instanceof Region) {
            return ((Region)target).getSubvertices();
        }
        return null;
    }

    public String getTypeName(EObject object) {
        String name = object.eClass().getName();
        return name;
    }

    public String getName(EObject object) {
        if (object instanceof NamedElement) {
            return ((NamedElement)object).getName();
        }
        return "";
    }

    public String getTextForGuard(Transition trans) {
        Constraint constraint = trans.getGuard();
        if (constraint != null) {
            String value;
            if (constraint.getSpecification() != null) {
                value = ValueSpecificationUtil.getConstraintnValue((Constraint)constraint);
            } else {
                String name = UMLLabelInternationalization.getInstance().getLabel((NamedElement)constraint);
                if (name == null) {
                    name = "<undef>";
                }
                value = String.format("%s (no spec)", name);
            }
            if (value != null) {
                return String.format("[%s]", value);
            }
        }
        return "";
    }

    public String getValueString(Transition trans, EObject containerView) {
        StringBuilder result = new StringBuilder();
        View view = SiriusGMFHelper.getGmfView((DDiagramElement)((DDiagramElement)containerView));
        String textForTrigger = this.getTextForTrigger(view, trans);
        if (textForTrigger != null && !"".equals(textForTrigger)) {
            result.append(textForTrigger);
        }
        result.append(this.getTextForGuard(trans));
        String textForEffect = this.getTextForEffect(view, trans);
        if (textForEffect != null && !"".equals(textForEffect)) {
            result.append("/");
            if (this.lineBreakBeforeEffect(view)) {
                result.append("\n");
            }
            result.append(textForEffect);
        }
        return result.toString();
    }

    public boolean lineBreakBeforeEffect(View view) {
        IPreferenceStore preferenceStore = UMLDiagramEditorPlugin.getInstance().getPreferenceStore();
        boolean prefValue = preferenceStore.getBoolean("lineBreakBeforeEffect");
        return NotationUtils.getBooleanValue((View)view, (String)"lineBreakBeforeEffect", (boolean)prefValue);
    }

    protected String getTextForEffect(View view, Transition trans) {
        StringBuilder result = new StringBuilder();
        Behavior effect = trans.getEffect();
        if (effect != null) {
            OpaqueBehavior ob;
            EClass eClass = effect.eClass();
            if (effect instanceof OpaqueBehavior && (ob = (OpaqueBehavior)effect).getBodies().size() > 0) {
                result.append(OpaqueBehaviorViewUtil.retrieveBody((View)view, (OpaqueBehavior)ob));
                return result.toString();
            }
            if (eClass != null) {
                result.append(eClass.getName()).append(": ").append(UMLLabelInternationalization.getInstance().getLabel((NamedElement)effect));
            }
        }
        return result.toString();
    }

    protected String getTextForTrigger(View view, Transition trans) {
        StringBuilder result = new StringBuilder();
        boolean isFirstTrigger = true;
        for (Trigger t : trans.getTriggers()) {
            if (t == null) continue;
            if (!isFirstTrigger) {
                result.append(", ");
            } else {
                isFirstTrigger = false;
            }
            Event e = t.getEvent();
            if (e instanceof CallEvent) {
                Operation op = ((CallEvent)e).getOperation();
                if (op != null) {
                    result.append(UMLLabelInternationalization.getInstance().getLabel((NamedElement)op));
                    if (op.getOwnedParameters().size() <= 0 || !OpaqueBehaviorViewUtil.displayParamDots((View)view)) continue;
                    result.append("(...)");
                    continue;
                }
                result.append(UMLLabelInternationalization.getInstance().getLabel((NamedElement)e));
                continue;
            }
            if (e instanceof SignalEvent) {
                Signal signal = ((SignalEvent)e).getSignal();
                if (signal != null) {
                    result.append(UMLLabelInternationalization.getInstance().getLabel((NamedElement)signal));
                    if (signal.getAttributes().size() <= 0 || !OpaqueBehaviorViewUtil.displayParamDots((View)view)) continue;
                    result.append("(...)");
                    continue;
                }
                result.append(UMLLabelInternationalization.getInstance().getLabel((NamedElement)e));
                continue;
            }
            if (e instanceof ChangeEvent) {
                ValueSpecification vs = ((ChangeEvent)e).getChangeExpression();
                String value = vs instanceof OpaqueExpression ? OpaqueBehaviorViewUtil.retrieveBody((View)view, (OpaqueExpression)((OpaqueExpression)vs)) : vs.stringValue();
                result.append(value);
                continue;
            }
            if (e instanceof TimeEvent) {
                ValueSpecification vs;
                TimeEvent timeEvent = (TimeEvent)e;
                result.append(timeEvent.isRelative() ? "after " : "at ");
                TimeExpression te = timeEvent.getWhen();
                String value = te != null ? ((vs = te.getExpr()) instanceof OpaqueExpression ? OpaqueBehaviorViewUtil.retrieveBody((View)view, (OpaqueExpression)((OpaqueExpression)vs)) : vs.stringValue()) : "undefined";
                result.append(value);
                continue;
            }
            result.append("all");
        }
        return result.toString();
    }

    public String getTextForTrigger(View view, Trigger trigger) {
        StringBuilder result = new StringBuilder();
        if (trigger != null) {
            Event e = trigger.getEvent();
            if (e instanceof CallEvent) {
                Operation op = ((CallEvent)e).getOperation();
                if (op != null) {
                    result.append(UMLLabelInternationalization.getInstance().getLabel((NamedElement)op));
                    if (op.getOwnedParameters().size() > 0 && OpaqueBehaviorViewUtil.displayParamDots((View)view)) {
                        result.append("(...)");
                    }
                } else {
                    result.append(UMLLabelInternationalization.getInstance().getLabel((NamedElement)e));
                }
            } else if (e instanceof SignalEvent) {
                Signal signal = ((SignalEvent)e).getSignal();
                if (signal != null) {
                    result.append(UMLLabelInternationalization.getInstance().getLabel((NamedElement)signal));
                    if (signal.getAttributes().size() > 0 && OpaqueBehaviorViewUtil.displayParamDots((View)view)) {
                        result.append("(...)");
                    }
                } else {
                    result.append(UMLLabelInternationalization.getInstance().getLabel((NamedElement)e));
                }
            } else if (e instanceof ChangeEvent) {
                ValueSpecification vs = ((ChangeEvent)e).getChangeExpression();
                String value = vs instanceof OpaqueExpression ? OpaqueBehaviorViewUtil.retrieveBody((View)view, (OpaqueExpression)((OpaqueExpression)vs)) : vs.stringValue();
                result.append(value);
            } else if (e instanceof TimeEvent) {
                ValueSpecification vs;
                TimeEvent timeEvent = (TimeEvent)e;
                result.append(timeEvent.isRelative() ? "after " : "at ");
                TimeExpression te = timeEvent.getWhen();
                String value = te != null ? ((vs = te.getExpr()) instanceof OpaqueExpression ? OpaqueBehaviorViewUtil.retrieveBody((View)view, (OpaqueExpression)((OpaqueExpression)vs)) : vs.stringValue()) : "undefined";
                result.append(value);
            } else {
                result.append("all");
            }
        }
        return result.toString();
    }

    public boolean hasGraphicalRegion(DNodeContainer containerView) {
        EList ownedDiagramElements = containerView.getOwnedDiagramElements();
        for (DDiagramElement dDiagramElement : ownedDiagramElements) {
            if (!(dDiagramElement instanceof DNodeContainer) || !(dDiagramElement.getTarget() instanceof Region)) continue;
            return true;
        }
        return false;
    }

    public void dndBorderPseudoState(EObject context, EObject newContainer) {
        if (context instanceof Pseudostate) {
            if (newContainer instanceof State) {
                ((State)newContainer).getConnectionPoints().add((Object)((Pseudostate)context));
            }
            if (newContainer instanceof Region) {
                EObject stateParent = this.getStateParent(context);
                ((State)stateParent).getConnectionPoints().add((Object)((Pseudostate)context));
            }
        }
    }
}

