/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml14.portsandflows;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum FeatureDirection implements Enumerator
{
    PROVIDED(0, "provided", "provided"),
    PROVIDED_REQUIRED(1, "providedRequired", "providedRequired"),
    REQUIRED(2, "required", "required");

    public static final int PROVIDED_VALUE = 0;
    public static final int PROVIDED_REQUIRED_VALUE = 1;
    public static final int REQUIRED_VALUE = 2;
    private static final FeatureDirection[] VALUES_ARRAY;
    public static final List<FeatureDirection> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new FeatureDirection[]{PROVIDED, PROVIDED_REQUIRED, REQUIRED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static FeatureDirection get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FeatureDirection result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FeatureDirection getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FeatureDirection result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FeatureDirection get(int value) {
        switch (value) {
            case 0: {
                return PROVIDED;
            }
            case 1: {
                return PROVIDED_REQUIRED;
            }
            case 2: {
                return REQUIRED;
            }
        }
        return null;
    }

    private FeatureDirection(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

