/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml14.validation.internal.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.uml2.uml.Element;

public final class DiagnosticUtil {
    private DiagnosticUtil() {
    }

    public static List<Diagnostic> findDiagnosticBySource(Diagnostic diagnostic, String source) {
        ArrayList<Diagnostic> foundDiagnostic = new ArrayList<Diagnostic>();
        List children = diagnostic.getChildren();
        if (source.equals(diagnostic.getSource())) {
            foundDiagnostic.add(diagnostic);
        }
        if (children != null && !children.isEmpty()) {
            for (Diagnostic diagnosticChild : children) {
                foundDiagnostic.addAll(DiagnosticUtil.findDiagnosticBySource(diagnosticChild, source));
            }
        }
        return foundDiagnostic;
    }

    public static List<Diagnostic> filterDiagnosticsByElement(List<Diagnostic> diagnostics, Element element) {
        ArrayList<Diagnostic> filteredDiagnostics = new ArrayList<Diagnostic>();
        for (Diagnostic diagnostic : diagnostics) {
            List datas = diagnostic.getData();
            if (datas == null || datas.isEmpty() || !element.equals(datas.get(0))) continue;
            filteredDiagnostics.add(diagnostic);
        }
        return filteredDiagnostics;
    }
}

