/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotml.deployment;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.papyrus.RobotML.DeploymentPlan;
import org.eclipse.papyrus.robotml.deployment.DepCreation;
import org.eclipse.papyrus.robotml.deployment.DepUtils;
import org.eclipse.papyrus.robotml.deployment.StUtils;
import org.eclipse.papyrus.robotml.deployment.Utils;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.StructuralFeature;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;

public class DepPlanUtils {
    public static final String depPlanFolder = "deployment";

    public static Package getDepPlanRoot(Element element) {
        return Utils.getRoot(element, depPlanFolder);
    }

    public static EList<Package> getAllDepPlans(Element element) {
        Package root = Utils.getTop(element);
        Package depPlanRoot = root.getNestedPackage(depPlanFolder);
        BasicEList depPlanList = new BasicEList();
        if (depPlanRoot != null) {
            for (Package pkg : depPlanRoot.getNestedPackages()) {
                if (!StUtils.isApplied((Element)pkg, DeploymentPlan.class)) continue;
                depPlanList.add((Object)pkg);
            }
        }
        return depPlanList;
    }

    public static void delDepPlan(InstanceSpecification is) {
        for (Slot slot : is.getSlots()) {
            InstanceSpecification subInstance = DepPlanUtils.getInstance(slot);
            if (subInstance == null) continue;
            DepPlanUtils.delDepPlan(subInstance);
        }
        Element owner = is.getOwner();
        if (owner instanceof Package) {
            ((Package)owner).getPackagedElements().remove((Object)is);
        }
    }

    public static InstanceSpecification getInstance(Slot slot) {
        for (ValueSpecification value : slot.getValues()) {
            if (!(value instanceof InstanceValue)) continue;
            return ((InstanceValue)value).getInstance();
        }
        return null;
    }

    public static Slot createSlot(Package cdp, InstanceSpecification is, InstanceSpecification partIS, Property part) {
        Slot slot = is.createSlot();
        slot.setDefiningFeature((StructuralFeature)part);
        InstanceValue iv = (InstanceValue)slot.createValue(null, null, UMLPackage.eINSTANCE.getInstanceValue());
        iv.setInstance(partIS);
        return slot;
    }

    public static void setMainInstance(Package cdp, InstanceSpecification mainInstance) {
        DeploymentPlan cdpApp = StUtils.applyApp((Element)cdp, DeploymentPlan.class);
        if (cdpApp != null) {
            cdpApp.setMainInstance(mainInstance);
        }
    }

    public static Class autoChooseImplementation(Classifier componentType) {
        Package compModel = Utils.getRoot((Element)componentType, "ComponentModel");
        for (Element element : compModel.allOwnedElements()) {
            Class candidate;
            if (!(element instanceof Class) || (candidate = (Class)element).getSuperClass(componentType.getName()) == null) continue;
            return candidate;
        }
        return null;
    }

    public static InstanceSpecification createDepPlan(Package cdp, Classifier composite, String name) {
        InstanceSpecification is = (InstanceSpecification)cdp.createPackagedElement(name, UMLPackage.eINSTANCE.getInstanceSpecification());
        if (name == "mainInstance") {
            DepPlanUtils.setMainInstance(cdp, is);
        }
        Class implementation = null;
        if (Utils.isCompImpl(composite)) {
            if (composite instanceof Class) {
                implementation = (Class)composite;
            }
        } else {
            implementation = DepPlanUtils.autoChooseImplementation(composite);
        }
        if (!(implementation instanceof Class)) {
            return is;
        }
        is.getClassifiers().add((Object)implementation);
        for (Property part : Utils.getParts(implementation)) {
            if (part instanceof Port) continue;
            InstanceSpecification partIS = DepPlanUtils.createDepPlan(cdp, (Classifier)part.getType(), String.valueOf(name) + "." + part.getName());
            DepPlanUtils.createSlot(cdp, is, partIS, part);
        }
        return is;
    }

    public static void configureProperty(InstanceSpecification instance, ENamedElement property, String value) {
        DepPlanUtils.configureProperty(instance, property.getName(), value);
    }

    public static void configureProperty(InstanceSpecification instance, String propertyName, String value) {
        Classifier extension = DepUtils.getClassifier(instance);
        Property attribute = (Property)Utils.getNamedElementFromList((EList<? extends NamedElement>)extension.getAllAttributes(), propertyName);
        if (attribute == null) {
            throw new RuntimeException("cannot find attribute " + propertyName + " in classifier " + extension.getName());
        }
        if (attribute.getType() instanceof Enumeration) {
            DepPlanUtils.configureEnumProperty(instance, propertyName, value);
        } else {
            Slot slotStringVal = DepCreation.createSlotForConfigProp(instance, attribute);
            if (slotStringVal.getValues().get(0) instanceof LiteralString) {
                ((LiteralString)slotStringVal.getValues().get(0)).setValue(value);
            } else {
                throw new RuntimeException("configuration of property " + propertyName + " failed: type is not a string");
            }
        }
    }

    public static void configureProperty(InstanceSpecification instance, ENamedElement property, int value) {
        DepPlanUtils.configureProperty(instance, property.getName(), value);
    }

    public static void configureProperty(InstanceSpecification instance, String propertyName, int value) {
        Classifier extension = DepUtils.getClassifier(instance);
        Property attribute = (Property)Utils.getNamedElementFromList((EList<? extends NamedElement>)extension.getAllAttributes(), propertyName);
        if (attribute == null) {
            throw new RuntimeException("cannot find attribute " + propertyName + " in classifier " + extension.getName());
        }
        Slot slotIntVal = instance.createSlot();
        slotIntVal.setDefiningFeature((StructuralFeature)attribute);
        LiteralInteger intValue = (LiteralInteger)slotIntVal.createValue("value for " + attribute.getName(), attribute.getType(), UMLPackage.eINSTANCE.getLiteralInteger());
        intValue.setValue(value);
    }

    public static void configureProperty(InstanceSpecification instance, ENamedElement property, Enumerator value) {
        DepPlanUtils.configureProperty(instance, property.getName(), value);
    }

    public static void configureProperty(InstanceSpecification instance, String propertyName, Enumerator value) {
        DepPlanUtils.configureProperty(instance, propertyName, value.getName());
    }

    public static void configureEnumProperty(InstanceSpecification instance, String propertyName, String literalName) {
        Classifier extension = DepUtils.getClassifier(instance);
        Property attribute = (Property)Utils.getNamedElementFromList((EList<? extends NamedElement>)extension.getAllAttributes(), propertyName);
        if (attribute == null) {
            throw new RuntimeException("cannot find attribute " + propertyName + " in classifier " + extension.getName());
        }
        if (attribute.getType() instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)attribute.getType();
            for (EnumerationLiteral enumLiteral : enumeration.getOwnedLiterals()) {
                if (!enumLiteral.getLabel().equals(literalName)) continue;
                Slot slotEnumVal = instance.createSlot();
                slotEnumVal.setDefiningFeature((StructuralFeature)attribute);
                InstanceValue enumLitValue = (InstanceValue)slotEnumVal.createValue("value for " + attribute.getName(), attribute.getType(), UMLPackage.eINSTANCE.getInstanceValue());
                enumLitValue.setInstance((InstanceSpecification)enumLiteral);
                break;
            }
        }
    }
}

