/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.diagrams.advices;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.GetEditContextRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.emf.gmf.command.EMFtoGMFCommandWrapper;
import org.eclipse.papyrus.robotics.core.commands.CreateFunctionsCommand;
import org.eclipse.papyrus.robotics.core.utils.PortUtils;
import org.eclipse.papyrus.robotics.profile.robotics.components.ActivityPort;
import org.eclipse.papyrus.robotics.profile.robotics.components.ComponentPort;
import org.eclipse.papyrus.uml.service.types.utils.RequestParameterUtils;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.util.UMLUtil;

public class ConnectsEditHelperAdvice
extends AbstractEditHelperAdvice {
    protected EObject source;
    protected EObject target;

    public boolean approveRequest(IEditCommandRequest request) {
        GetEditContextRequest context;
        if (request instanceof GetEditContextRequest && (context = (GetEditContextRequest)request).getEditCommandRequest() instanceof CreateRelationshipRequest) {
            boolean canCreate = this.approveCreateRelationshipRequest((CreateRelationshipRequest)context.getEditCommandRequest());
            return canCreate;
        }
        return super.approveRequest(request);
    }

    protected boolean approveCreateRelationshipRequest(CreateRelationshipRequest request) {
        boolean targetIsActvitiyPort;
        this.source = request.getSource();
        this.target = request.getTarget();
        boolean sourceOnPart = false;
        boolean targetOnPart = false;
        boolean sourceIsActivityPort = this.source instanceof Port && StereotypeUtil.isApplied((Element)((Port)this.source), ActivityPort.class);
        boolean targetIsComponentPort = this.target instanceof Port && StereotypeUtil.isApplied((Element)((Port)this.target), ComponentPort.class);
        boolean sourceIsComponentPort = this.source instanceof Port && StereotypeUtil.isApplied((Element)((Port)this.source), ComponentPort.class);
        boolean bl = targetIsActvitiyPort = this.target instanceof Port && StereotypeUtil.isApplied((Element)((Port)this.target), ActivityPort.class);
        if (sourceIsActivityPort && targetIsComponentPort || sourceIsComponentPort && targetIsActvitiyPort) {
            return true;
        }
        if (sourceIsComponentPort && targetIsComponentPort) {
            View sourceView = RequestParameterUtils.getSourceView((IEditCommandRequest)request);
            View targetView = RequestParameterUtils.getTargetView((IEditCommandRequest)request);
            if (this.source instanceof Port && sourceView.eContainer() instanceof View) {
                View sourceContainer = (View)sourceView.eContainer();
                sourceOnPart = sourceContainer.getElement() instanceof Property;
            }
            if (this.target instanceof Port && targetView.eContainer() instanceof View) {
                View targetContainer = (View)targetView.eContainer();
                targetOnPart = targetContainer.getElement() instanceof Property;
            }
            if (sourceOnPart || targetOnPart) {
                Port sourcePt = (Port)this.source;
                Port targetPt = (Port)this.target;
                ComponentPort sourceCp = (ComponentPort)UMLUtil.getStereotypeApplication((Element)sourcePt, ComponentPort.class);
                ComponentPort targetCp = (ComponentPort)UMLUtil.getStereotypeApplication((Element)targetPt, ComponentPort.class);
                if (sourceCp != null && targetCp != null) {
                    if (sourceOnPart == targetOnPart) {
                        return sourceCp.getProvides() == targetCp.getRequires() && sourceCp.getRequires() == targetCp.getProvides();
                    }
                    return sourceCp.getProvides() == targetCp.getProvides() && sourceCp.getRequires() == targetCp.getRequires();
                }
            }
        }
        return false;
    }

    protected ICommand getAfterConfigureCommand(ConfigureRequest request) {
        CreateFunctionsCommand rc;
        boolean targetIsActivityPort;
        EObject newElement = request.getElementToConfigure();
        if (!(newElement instanceof Connector)) {
            return super.getAfterConfigureCommand(request);
        }
        final Connector connector = (Connector)newElement;
        CompositeCommand wrapper = new CompositeCommand("wrapper"){
            boolean first;
            {
                super($anonymous0);
                this.first = true;
            }

            public boolean canExecute() {
                if (this.first) {
                    return true;
                }
                return super.canExecute();
            }

            public IStatus execute(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                if (this.first) {
                    if (connector.getEnds().size() >= 2) {
                        ConnectableElement role2;
                        ConnectableElement role1;
                        ConnectorEnd end1 = (ConnectorEnd)connector.getEnds().get(0);
                        ConnectorEnd end2 = (ConnectorEnd)connector.getEnds().get(1);
                        ICommand command = null;
                        if (end1.getPartWithPort() == null && (role1 = end1.getRole()) != null && StereotypeUtil.isApplied((Element)role1, ActivityPort.class)) {
                            command = PortUtils.setPartWithPortCommand((ConnectorEnd)end1);
                        }
                        if (command == null && end2.getPartWithPort() == null && (role2 = end2.getRole()) != null && StereotypeUtil.isApplied((Element)role2, ActivityPort.class)) {
                            command = PortUtils.setPartWithPortCommand((ConnectorEnd)end2);
                        }
                        if (command != null) {
                            this.add((IUndoableOperation)command);
                        }
                    }
                    this.first = false;
                }
                return super.execute(progressMonitor, info);
            }
        };
        boolean sourceIsActivityPort = this.source instanceof Port && StereotypeUtil.isApplied((Element)((Port)this.source), ActivityPort.class);
        boolean bl = targetIsActivityPort = this.target instanceof Port && StereotypeUtil.isApplied((Element)((Port)this.target), ActivityPort.class);
        if (sourceIsActivityPort) {
            rc = new CreateFunctionsCommand((Port)this.target, (Port)this.source);
            wrapper.add((IUndoableOperation)EMFtoGMFCommandWrapper.wrap((Command)rc));
        }
        if (targetIsActivityPort) {
            rc = new CreateFunctionsCommand((Port)this.source, (Port)this.target);
            wrapper.add((IUndoableOperation)EMFtoGMFCommandWrapper.wrap((Command)rc));
        }
        return wrapper;
    }
}

