/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.properties.widgets;

import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.infra.widgets.editors.ReferenceDialog;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.robotics.core.provider.RoboticsContentProvider;
import org.eclipse.papyrus.robotics.core.provider.RoboticsLabelProvider;
import org.eclipse.papyrus.robotics.core.utils.ImportUtils;
import org.eclipse.papyrus.robotics.core.utils.ScanUtils;
import org.eclipse.swt.widgets.Composite;

public class RoboticsReferenceDialog
extends ReferenceDialog {
    protected Class<? extends EObject> stereotypeFilter;
    protected String extension;
    protected EObject context;

    public RoboticsReferenceDialog(Composite parent, int style, Class<? extends EObject> stereotypeFilter, String extension) {
        super(parent, style);
        this.stereotypeFilter = stereotypeFilter;
        this.extension = extension;
    }

    public void setModelObservable(IObservableValue modelProperty) {
        super.setModelObservable(modelProperty);
        Object contextObj = this.getContextElement();
        if (contextObj instanceof EObject) {
            this.context = (EObject)contextObj;
            RoboticsContentProvider roboticProvider = new RoboticsContentProvider(this.context, this.contentProvider, this.stereotypeFilter, this.extension);
            this.setContentProvider((IStaticContentProvider)roboticProvider);
        }
    }

    public void setValue(Object valueObj) {
        if (valueObj instanceof EObject) {
            EObject value = (EObject)valueObj;
            valueObj = ScanUtils.moveIntoRS((ResourceSet)this.context.eResource().getResourceSet(), (EObject)value);
            ImportUtils.createImportFromObj((Object)valueObj);
        }
        super.setValue(valueObj);
    }

    public void setLabelProvider(ILabelProvider provider) {
        super.setLabelProvider((ILabelProvider)new RoboticsLabelProvider(provider));
    }
}

