/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.core.internal.util;

import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.model2doc.core.Activator;

public class WorkspaceResourceUtil {
    public static final String MODEL2DOC_CONFIGS_FOLDER = ".model2doc_configs";

    private WorkspaceResourceUtil() {
    }

    public static String calculateProjectFolder(EObject element) {
        String output = element.eResource().getURI().toPlatformString(true);
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(output));
        IContainer parent = file.getParent();
        output = parent.getFullPath().toString();
        return output;
    }

    public static void refreshWorkspace(String outputFolder) {
        int nbToken = new StringTokenizer(outputFolder, "/").countTokens();
        Object container = nbToken == 1 ? ResourcesPlugin.getWorkspace().getRoot().getProject(outputFolder) : ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(outputFolder));
        try {
            container.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Activator.log.error((Throwable)e);
        }
    }
}

