/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.test.xtext;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.xtext.tests.TestFile;
import org.eclipse.ocl.examples.xtext.tests.TestUtil;
import org.eclipse.ocl.examples.xtext.tests.XtextTestCase;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.internal.ecore.as2es.AS2Ecore;
import org.eclipse.ocl.pivot.internal.ecore.es2as.Ecore2AS;
import org.eclipse.ocl.pivot.internal.resource.ProjectMap;
import org.eclipse.ocl.pivot.internal.resource.StandaloneProjectMap;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.OCLInternal;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.resource.CSResource;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.uml.UMLStandaloneSetup;
import org.eclipse.ocl.pivot.uml.internal.as2es.AS2UML;
import org.eclipse.ocl.pivot.uml.internal.es2as.UML2AS;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.DebugTimestamp;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.ThreadLocalExecutor;
import org.eclipse.ocl.pivot.utilities.XMIUtil;
import org.eclipse.ocl.xtext.base.cs2as.CS2AS;
import org.eclipse.ocl.xtext.base.utilities.BaseCSResource;
import org.eclipse.ocl.xtext.completeocl.as2cs.CompleteOCLSplitter;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.resource.UML402UMLExtendedMetaData;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.EmfFormatter;

public class RoundTripTests
extends XtextTestCase {
    private static final @NonNull String AS2ES_VALIDATION_ERRORS = "AS2ES_VALIDATION_ERRORS";

    public @NonNull Resource createEcoreFromPivot(@NonNull EnvironmentFactoryInternal environmentFactory, @NonNull ASResource asResource, @NonNull URI ecoreURI) throws IOException {
        XMLResource ecoreResource = AS2Ecore.createResource((EnvironmentFactoryInternal)environmentFactory, (Resource)asResource, (URI)ecoreURI, null);
        RoundTripTests.assertNoResourceErrors("To Ecore errors", (Resource)ecoreResource);
        ecoreResource.save(XMIUtil.createSaveOptions());
        return ecoreResource;
    }

    public @NonNull ASResource createPivotFromEcore(@NonNull EnvironmentFactoryInternal environmentFactory, @NonNull Resource ecoreResource) throws IOException {
        Ecore2AS ecore2as = Ecore2AS.getAdapter((Resource)ecoreResource, (EnvironmentFactoryInternal)environmentFactory);
        Model pivotModel = ecore2as.getASModel();
        ASResource asResource = (ASResource)ClassUtil.nonNullState((Object)pivotModel.eResource());
        RoundTripTests.assertNoResourceErrors("Ecore2AS failed", (Resource)asResource);
        RoundTripTests.assertNoValidationErrors("Ecore2AS invalid", (Resource)asResource);
        return asResource;
    }

    public @NonNull ASResource createPivotFromXtext(@NonNull EnvironmentFactoryInternal environmentFactory, BaseCSResource xtextResource, int expectedContentCount) throws IOException {
        try {
            ASResource asResource = xtextResource.getASResource();
            RoundTripTests.assertNoResourceErrors("To Pivot errors", (Resource)xtextResource);
            RoundTripTests.assertNoUnresolvedProxies("Unresolved proxies", (Resource)xtextResource);
            EList pivotContents = asResource.getContents();
            RoundTripTests.assertEquals((int)expectedContentCount, (int)pivotContents.size());
            RoundTripTests.assertNoValidationErrors("Pivot validation errors", (EObject)ClassUtil.nonNullState((Object)((EObject)pivotContents.get(0))));
            ASResource aSResource = asResource;
            return aSResource;
        }
        finally {
            xtextResource.dispose();
        }
    }

    public BaseCSResource createXtextFromPivot(@NonNull EnvironmentFactoryInternal environmentFactory, @NonNull ASResource asResource, @NonNull URI xtextURI) throws IOException {
        ResourceSet resourceSet = environmentFactory.getResourceSet();
        XtextResource xtextResource = (XtextResource)resourceSet.createResource(xtextURI, "org.eclipse.ocl.xtext.oclinecore");
        ((BaseCSResource)xtextResource).updateFrom(asResource, (EnvironmentFactory)environmentFactory);
        DebugTimestamp debugTimestamp = new DebugTimestamp((String)ClassUtil.nonNullState((Object)xtextResource.getURI().toString()));
        xtextResource.save(XMIUtil.createSaveOptions());
        debugTimestamp.log("Serialization save done");
        RoundTripTests.assertNoResourceErrors("Conversion failed", (Resource)xtextResource);
        RoundTripTests.assertNoDiagnosticErrors("Concrete Syntax validation failed", xtextResource);
        return (BaseCSResource)xtextResource;
    }

    public BaseCSResource createXtextFromURI(@NonNull EnvironmentFactoryInternal environmentFactory, URI xtextURI) throws IOException {
        ResourceSet resourceSet = environmentFactory.getResourceSet();
        ProjectMap.initializeURIResourceMap(null);
        BaseCSResource xtextResource = (BaseCSResource)ClassUtil.nonNullState((Object)resourceSet.getResource(xtextURI, true));
        RoundTripTests.assertNoResourceErrors("Load failed", (Resource)xtextResource);
        return xtextResource;
    }

    public CSResource createCompleteOCLXtextFromPivot(@NonNull EnvironmentFactoryInternal environmentFactory, @NonNull ASResource asResource, @NonNull URI xtextURI) throws IOException {
        ResourceSet resourceSet = environmentFactory.getResourceSet();
        CSResource xtextResource = (CSResource)resourceSet.createResource(xtextURI, "org.eclipse.ocl.xtext.oclinecore");
        xtextResource.updateFrom(asResource, (EnvironmentFactory)environmentFactory);
        DebugTimestamp debugTimestamp = new DebugTimestamp((String)ClassUtil.nonNullState((Object)xtextResource.getURI().toString()));
        xtextResource.save(XMIUtil.createSaveOptions());
        debugTimestamp.log("Serialization save done");
        RoundTripTests.assertNoResourceErrors("Conversion failed", (Resource)xtextResource);
        RoundTripTests.assertNoDiagnosticErrors("Concrete Syntax validation failed", (XtextResource)xtextResource);
        return xtextResource;
    }

    public void doRoundTripFromCompleteOCL(URI inputURI) throws IOException, InterruptedException {
        OCL ocl0 = OCL.newInstance((ProjectManager)RoundTripTests.getProjectMap());
        ResourceSet resourceSet = ocl0.getResourceSet();
        CS2AS.MessageBinder savedMessageBinder = CS2AS.setMessageBinder((CS2AS.MessageBinder)CS2AS.MessageBinderWithLineContext.INSTANCE);
        StandaloneProjectMap projectMap = RoundTripTests.getProjectMap();
        try {
            ocl0.dispose();
            if (!resourceSet.getURIConverter().exists(inputURI, null)) {
                System.err.println(String.valueOf(this.getTestName()) + " skipped since '" + inputURI + "' is missing.");
                return;
            }
            if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
                ProjectManager.IProjectDescriptor projectDescriptor = (ProjectManager.IProjectDescriptor)ClassUtil.nonNullState((Object)projectMap.getProjectDescriptor("org.eclipse.uml2.uml"));
                projectDescriptor.initializeURIMap((Map)ClassUtil.nonNullState((Object)URIConverter.URI_MAP));
            }
            URI outputURI = inputURI.trimFileExtension().appendFileExtension("regenerated.ocl");
            OCLInternal ocl1 = OCLInternal.newInstance((ProjectManager)RoundTripTests.getProjectMap(), null);
            EnvironmentFactoryInternal environmentFactory1 = ocl1.getEnvironmentFactory();
            environmentFactory1.adapt((Notifier)resourceSet);
            BaseCSResource xtextResource1 = this.createXtextFromURI(environmentFactory1, inputURI);
            ASResource pivotResource1 = this.createPivotFromXtext(environmentFactory1, xtextResource1, 1);
            pivotResource1.save(XMIUtil.createSaveOptions());
            ASResource pivotResource2 = (ASResource)ClassUtil.nonNullState((Object)CompleteOCLSplitter.separate((EnvironmentFactoryInternal)environmentFactory1, (Resource)pivotResource1));
            CSResource xtextResource2 = this.createCompleteOCLXtextFromPivot(environmentFactory1, pivotResource2, outputURI);
            ocl1.dispose();
            ocl1 = null;
            OCLInternal ocl3 = OCLInternal.newInstance((ProjectManager)RoundTripTests.getProjectMap(), null);
            EnvironmentFactoryInternal environmentFactory3 = ocl3.getEnvironmentFactory();
            BaseCSResource xtextResource3 = this.createXtextFromURI(environmentFactory3, outputURI);
            ASResource pivotResource3 = this.createPivotFromXtext(environmentFactory3, xtextResource3, 1);
            ocl3.dispose();
        }
        finally {
            CS2AS.setMessageBinder((CS2AS.MessageBinder)savedMessageBinder);
        }
    }

    public void doRoundTripFromEcore(@NonNull URI inputURI) throws IOException, InterruptedException, ParserException {
        this.doRoundTripFromEcore(inputURI, inputURI, null);
    }

    public void doRoundTripFromEcore(@NonNull URI inputURI, @NonNull URI referenceURI, Map<@NonNull String, @Nullable Object> saveOptions) throws IOException, InterruptedException, ParserException {
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            TestUtil.initializeEcoreEAnnotationValidators();
        }
        OCLInternal ocl = OCLInternal.newInstance((ProjectManager)RoundTripTests.getProjectMap(), null);
        this.doRoundTripFromEcore(ocl.getEnvironmentFactory(), inputURI, referenceURI, saveOptions);
        ocl.dispose();
    }

    protected void doRoundTripFromEcore(@NonNull EnvironmentFactoryInternal environmentFactory, URI inputURI, URI referenceURI, Map<@NonNull String, @Nullable Object> saveOptions) throws IOException, InterruptedException, ParserException {
        String stem = inputURI.trimFileExtension().lastSegment();
        String pivotName = String.valueOf(stem) + ".ecore.oclas";
        String outputName = String.valueOf(stem) + ".regenerated.ecore";
        URI pivotURI = this.getTestFileURI(pivotName);
        URI outputURI = this.getTestFileURI(outputName);
        ResourceSet resourceSet = environmentFactory.getResourceSet();
        Resource inputResource = (Resource)ClassUtil.nonNullState((Object)resourceSet.getResource(inputURI, true));
        RoundTripTests.assertNoResourceErrors("Ecore load", inputResource);
        RoundTripTests.assertNoValidationErrors("Ecore load", inputResource);
        Ecore2AS ecore2as = Ecore2AS.getAdapter((Resource)inputResource, (EnvironmentFactoryInternal)environmentFactory);
        Model pivotModel = ecore2as.getASModel();
        ASResource asResource = (ASResource)pivotModel.eResource();
        boolean wasSaveable = asResource.setSaveable(true);
        asResource.setURI(pivotURI);
        RoundTripTests.assertNoResourceErrors("Ecore2AS failed", (Resource)asResource);
        TreeIterator tit = asResource.getAllContents();
        while (tit.hasNext()) {
            EObject eObject = (EObject)tit.next();
            if (!(eObject instanceof ExpressionInOCL)) continue;
            ExpressionInOCL specification = (ExpressionInOCL)eObject;
            if (specification.getOwnedBody() != null || specification.getBody() != null) {
                ((EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)environmentFactory).parseSpecification((LanguageExpression)specification);
            }
            tit.prune();
        }
        asResource.save(XMIUtil.createSaveOptions((XMLResource)asResource));
        asResource.setSaveable(wasSaveable);
        @NonNull String @NonNull [] validationDiagnostics = saveOptions != null ? (String[])saveOptions.get(AS2ES_VALIDATION_ERRORS) : NO_MESSAGES;
        RoundTripTests.assertValidationDiagnostics("Ecore2AS invalid", (Resource)asResource, validationDiagnostics);
        XMLResource outputResource = AS2Ecore.createResource((EnvironmentFactoryInternal)environmentFactory, (Resource)asResource, (URI)inputURI, saveOptions);
        RoundTripTests.assertNoResourceErrors("Ecore2AS failed", (Resource)outputResource);
        OutputStream outputStream = resourceSet.getURIConverter().createOutputStream(outputURI);
        outputResource.save(outputStream, XMIUtil.createSaveOptions((XMLResource)outputResource));
        outputStream.close();
        RoundTripTests.assertNoValidationErrors("Ecore2AS invalid", (Resource)outputResource);
        if (referenceURI != null) {
            ResourceSetImpl resourceSet2 = new ResourceSetImpl();
            StandaloneProjectMap.getAdapter((ResourceSet)resourceSet).initializeResourceSet((ResourceSet)resourceSet2);
            Resource referenceResource = (Resource)ClassUtil.nonNullState((Object)resourceSet2.getResource(referenceURI, true));
            TestUtil.assertSameModel(referenceResource, (Resource)outputResource);
            RoundTripTests.unloadResourceSet((ResourceSet)resourceSet2);
        }
    }

    public void doRoundTripFromOCLinEcore(@NonNull TestFile testFile) throws IOException, InterruptedException {
        this.doRoundTripFromOCLinEcore(testFile.getFileURI());
    }

    public void doRoundTripFromOCLinEcore(@NonNull URI inputURI) throws IOException, InterruptedException {
        OCLInternal ocl1 = OCLInternal.newInstance((ProjectManager)RoundTripTests.getProjectMap(), null);
        String stem = inputURI.trimFileExtension().lastSegment();
        String ecoreName = String.valueOf(stem) + ".ecore";
        String outputName = String.valueOf(stem) + ".regenerated.oclinecore";
        URI ecoreURI = this.getTestFileURI(ecoreName);
        URI outputURI = this.getTestFileURI(outputName);
        EnvironmentFactoryInternal environmentFactory1 = ocl1.getEnvironmentFactory();
        BaseCSResource xtextResource1 = this.createXtextFromURI(environmentFactory1, inputURI);
        ASResource pivotResource1 = this.createPivotFromXtext(environmentFactory1, xtextResource1, 1);
        Resource ecoreResource = this.createEcoreFromPivot(environmentFactory1, pivotResource1, ecoreURI);
        ThreadLocalExecutor.resetEnvironmentFactory();
        OCLInternal ocl2 = OCLInternal.newInstance((ProjectManager)RoundTripTests.getProjectMap(), null);
        EnvironmentFactoryInternal environmentFactory2 = ocl2.getEnvironmentFactory();
        ASResource pivotResource2 = this.createPivotFromEcore(environmentFactory2, ecoreResource);
        BaseCSResource xtextResource2 = this.createXtextFromPivot(environmentFactory2, pivotResource2, outputURI);
        ocl2.dispose();
        ocl2 = null;
        ThreadLocalExecutor.resetEnvironmentFactory();
        OCLInternal ocl3 = OCLInternal.newInstance((ProjectManager)RoundTripTests.getProjectMap(), null);
        EnvironmentFactoryInternal environmentFactory3 = ocl3.getEnvironmentFactory();
        BaseCSResource xtextResource3 = this.createXtextFromURI(environmentFactory3, outputURI);
        ASResource pivotResource3 = this.createPivotFromXtext(environmentFactory3, xtextResource3, 1);
        pivotResource1.setSaveable(true);
        pivotResource1.save(XMIUtil.createSaveOptions((XMLResource)pivotResource1));
        pivotResource3.setSaveable(true);
        pivotResource3.save(XMIUtil.createSaveOptions((XMLResource)pivotResource3));
        String expected = EmfFormatter.listToStr((List)pivotResource1.getContents());
        String actual = EmfFormatter.listToStr((List)pivotResource3.getContents()).replace(".regenerated.oclinecore", ".oclinecore");
        RoundTripTests.assertEquals((String)expected, (String)actual);
        ocl3.dispose();
        ocl1.dispose();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Deprecated
    public void doRoundTripFromUml(String stem) throws IOException, InterruptedException, ParserException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getPackageRegistry().put((Object)"http://www.eclipse.org/uml2/5.0.0/UML", (Object)UMLPackage.eINSTANCE);
        String inputName = String.valueOf(stem) + ".uml";
        String pivotName = String.valueOf(stem) + ".oclas";
        String outputName = String.valueOf(stem) + ".regenerated.uml";
        URI inputURI = this.getProjectFileURI(inputName);
        URI pivotURI = this.getTestFileURI(pivotName);
        URI outputURI = this.getTestFileURI(outputName);
        Resource inputResource = (Resource)ClassUtil.nonNullState((Object)resourceSet.getResource(inputURI, true));
        RoundTripTests.assertNoResourceErrors("UML load", inputResource);
        RoundTripTests.assertNoValidationErrors("UML load", inputResource);
        OCLInternal ocl = OCLInternal.newInstance((ProjectManager)RoundTripTests.getProjectMap(), null);
        EnvironmentFactoryInternal environmentFactory = ocl.getEnvironmentFactory();
        UML2AS uml2as = UML2AS.getAdapter((Resource)inputResource, (EnvironmentFactoryInternal)environmentFactory);
        Model pivotModel = uml2as.getASModel();
        Resource asResource = pivotModel.eResource();
        asResource.setURI(pivotURI);
        RoundTripTests.assertNoResourceErrors("UML2AS failed", asResource);
        asResource.save(XMIUtil.createSaveOptions());
        RoundTripTests.assertNoValidationErrors("UML2AS invalid", asResource);
        @NonNull EList outputObjects = new ArrayList(AS2UML.createResource((EnvironmentFactoryInternal)environmentFactory, (Resource)asResource));
        @NonNull List castOutputObjects = (List)outputObjects;
        outputObjects.remove(RoundTripTests.getNamedElement(castOutputObjects, "orphanage"));
        if (outputObjects.size() == 1) {
            Package outputPackages = (Package)ClassUtil.nonNullState((Object)((Package)outputObjects.get(0)));
            outputObjects = ClassUtil.nullFree((EList)outputPackages.getNestedPackages());
        }
        Resource outputResource = resourceSet.createResource(outputURI);
        outputResource.getContents().addAll(outputObjects);
        RoundTripTests.assertNoResourceErrors("UML2AS failed", outputResource);
        outputResource.save(XMIUtil.createSaveOptions());
        RoundTripTests.assertNoValidationErrors("UML2AS invalid", outputResource);
        TestUtil.assertSameModel(inputResource, outputResource);
        ocl.dispose();
    }

    public static <T extends NamedElement> @Nullable T getNamedElement(Collection<T> elements, String name) {
        if (elements == null) {
            return null;
        }
        for (NamedElement element : elements) {
            if (!ClassUtil.safeEquals((Object)name, (Object)((NamedElement)ClassUtil.nonNullState((Object)element)).getName())) continue;
            return (T)element;
        }
        return null;
    }

    public void testBug350894RoundTrip() throws IOException, InterruptedException {
        String testFileContentsA = "package a : aa = 'aaa'\n{\nclass A;\n}\n";
        OCLInternal ocl1 = OCLInternal.newInstance((ProjectManager)RoundTripTests.getProjectMap(), null);
        this.createEcoreFile((OCL)ocl1, "Bug350894A", testFileContentsA);
        ocl1.dispose();
        String testFileContentsB = "import aa : 'Bug350894A.ecore#/';\npackage b : bb = 'bbb'\n{\nclass B\n{\ninvariant alias: not oclIsKindOf(aa::A);\ninvariant nsURI: not oclIsKindOf(aaa::A);\ninvariant file: not oclIsKindOf(_'Bug350894A.ecore#/'::A);\n}\n}\n";
        TestFile testFile = this.createOCLinEcoreFile("Bug350894B.oclinecore", testFileContentsB);
        this.doRoundTripFromOCLinEcore(testFile);
    }

    public void testBug356243_oclinecore() throws IOException, InterruptedException {
        String testFileContents = "package any : any = 'http:/any'\n{\n\tclass Bug356243\n\t{\n\t\tproperty is_always_typed : OclAny { ordered };\n\t}\n}\n";
        TestFile testFile = this.createOCLinEcoreFile("Bug356243.oclinecore", testFileContents);
        this.doRoundTripFromOCLinEcore(testFile);
    }

    public void testBug426927_oclinecore() throws IOException, InterruptedException {
        String testFileContents = "package any : any = 'http:/any'\n{\n\tenum Enums\n\t{\n\t\tliteral ONE = 1;\n\t\tliteral MINUS_ONE = -1;\n\t}\n\tclass Bug426927\n\t{\n\t\tannotation {\n\t\t\treference Enums::MINUS_ONE;\n\t\t}\n\t}\n}\n";
        TestFile testFile = this.createOCLinEcoreFile("Bug426927.oclinecore", testFileContents);
        this.doRoundTripFromOCLinEcore(testFile);
    }

    public void testAggregatesRoundTrip() throws IOException, InterruptedException {
        String testFileContents = "package b : bb = 'bbb'\n{\nclass B\n{\nproperty bag0 : B[3..5|1] {!unique};\nproperty bag1 : B[*] {!unique};\nproperty bag2 : Bag(B);\nproperty bag3 : B[3..5] {!unique};\nproperty bag4 : Bag(B/*[1..3]*/)[4..6];\nproperty bag5 : Bag(B)[4..6|1];\nproperty setCollection : Set(Collection(B));\nproperty collection2 : Collection(B);\nproperty orderedset1 : B[*] {ordered};\nproperty orderedset2 : OrderedSet(B);\nproperty sequence1 : B[*] {ordered, !unique};\nproperty sequence2 : Sequence(B);\nproperty set1 : B[*];\nproperty set2 : Set(B);\n}\n}\n";
        TestFile testFile = this.createOCLinEcoreFile("Aggregates.oclinecore", testFileContents);
        this.doRoundTripFromOCLinEcore(testFile);
    }

    public void testAnnotationsRoundTrip_480635() throws IOException, InterruptedException {
        String testFileContents = "package b : bb = 'bbb'\n{\nenum Parameter_kind { serializable }\n{\n   literal DB_BOOLEAN { annotation documentation\n   (doc = 'test');\n   } \n   literal ENUMERATED = 1;\n   literal INT8 = 2;\n   literal INT16 = 3;\n}\n}\n";
        TestFile testFile = this.createOCLinEcoreFile("Annotations.oclinecore", testFileContents);
        this.doRoundTripFromOCLinEcore(testFile);
    }

    public void testCardinalityRoundTrip_402767() throws IOException, InterruptedException {
        String testFileContents = "package b : bb = 'bbb'\n{\nclass B\n{\nproperty vBlank : Real;\nproperty vQuery : Real[?];\nproperty vPlus : Real[+];\nproperty vStar : Real[*];\nproperty vOne : Real[1];\nproperty vThree : Real[3];\nproperty vOne2Three : Real[1..3];\nproperty vThree2Three : Real[3..3];\nproperty vThree2Star : Real[3..*];\n}\n}\n";
        TestFile testFile = this.createOCLinEcoreFile("Cardinality.oclinecore", testFileContents);
        this.doRoundTripFromOCLinEcore(testFile);
    }

    public void testCommentsRoundTrip_405145() throws IOException, InterruptedException {
        String testFileContents = "package b : bb = 'bbb'\n{\n/* a simple comment */\nclass B\n{\n/*\n * a multi line comment\n */\nproperty c1 : Real;\n/* another \n * multi line comment\n */\nproperty c2 : Real;\n/* an unformatted \n multi line comment\n */\nproperty c3 : Real;\n}\n}\n";
        TestFile testFile = this.createOCLinEcoreFile("Comments.oclinecore", testFileContents);
        this.doRoundTripFromOCLinEcore(testFile);
    }

    public void testGenericsRoundTrip_468846() throws IOException, InterruptedException {
        String testFileContents = "package basket : basket = 'http://www.example.org/basket'\n{\n\tabstract class Fruit;\n\tabstract class Basket(T extends Fruit)\n\t{\n\t\tproperty fruit : T[*] { ordered };\n\t}\n}";
        TestFile testFile = this.createOCLinEcoreFile("Bug468846.oclinecore", testFileContents);
        this.doRoundTripFromOCLinEcore(testFile);
    }

    public void testGenericsRoundTrip_492800() throws IOException, InterruptedException {
        String testFileContents = "package example : example = 'http://www.example.org/generics/opposite'\n{\n\tabstract class Interface(T extends Event)\n\t{\n\t\tproperty events#interface : T[*] { ordered composes };\n\t\tattribute name : String[1];\n\t}\n\tclass CallInterface extends Interface(CallEvent);\n\tclass ReplyInterface extends Interface(ReplyEvent);\n\tabstract class Event\n\t{\n\t\tproperty interface#events : Interface(Event)[?];\n\t\tattribute name : String[1];\n\t}\n\tabstract class CallEvent extends Event;\n\tclass ReplyEvent extends Event;\n}";
        TestFile testFile = this.createOCLinEcoreFile("Bug492800.oclinecore", testFileContents);
        this.doRoundTripFromOCLinEcore(testFile);
    }

    public void testInvariantCommentsRoundTrip_410682() throws IOException, InterruptedException {
        String testFileContents = "package b : bb = 'bbb'\n{\nclass B\n{\n/* an invariant comment */\ninvariant t : true;\n/* an operation comment */\noperation op(/* a parameter comment */p : Boolean, /* another parameter comment */q : Boolean) : Boolean\n{transient}\n{\n/* a precondition comment */\nprecondition: p;\n/* another precondition comment */\nprecondition too: p;\nbody: p or q;\n/* a postcondition comment */\npostcondition: result = p;\n/* another postcondition comment */\npostcondition too: result = q;\n}\n}\n}\n";
        TestFile testFile = this.createOCLinEcoreFile("InvariantComments.oclinecore", testFileContents);
        this.doRoundTripFromOCLinEcore(testFile);
    }

    public void testCompanyRoundTrip() throws IOException, InterruptedException, ParserException {
        this.doRoundTripFromEcore(RoundTripTests.getTestModelURI("models/ecore/Company.ecore"), RoundTripTests.getTestModelURI("models/ecore/Company.reference.ecore"), null);
    }

    public void testEcoreRoundTrip() throws IOException, InterruptedException, ParserException {
        this.doRoundTripFromEcore(RoundTripTests.getTestModelURI("models/ecore/Ecore.ecore"));
    }

    public void testEmptyRoundTrip() throws IOException, InterruptedException, ParserException {
        this.doRoundTripFromEcore(RoundTripTests.getTestModelURI("models/ecore/Empty.ecore"));
    }

    public void testImportsRoundTrip() throws IOException, InterruptedException, ParserException {
        this.doRoundTripFromEcore(RoundTripTests.getTestModelURI("models/ecore/Imports.ecore"));
    }

    public void testKeysRoundTrip() throws IOException, InterruptedException, ParserException {
        this.doRoundTripFromEcore(RoundTripTests.getTestModelURI("models/ecore/Keys.ecore"));
    }

    public void testBug492960RoundTrip() throws IOException, InterruptedException, ParserException {
        this.doRoundTripFromEcore(RoundTripTests.getTestModelURI("models/ecore/Bug492960.ecore"));
    }

    public void testBug510729_oclinecore() throws IOException, InterruptedException {
        String testFileContents = "package bug510729 : pfx = 'http:/org/eclipse/ocl/examples/test/xtext/models/Bug510729.oclinecore' {\n\tclass Artefact {\n\t\toperation paths(types : ocl::OclType) : ocl::Sequence(Artefact)[*];\n\t}\n}\n";
        TestFile testFile = this.createOCLinEcoreFile("Bug510729.oclinecore", testFileContents);
        this.doRoundTripFromOCLinEcore(testFile);
    }

    public void testBug516274_oclinecore() throws IOException, InterruptedException {
        String testFileContents = "package bug516274 : my = 'http:/org/eclipse/ocl/examples/test/xtext/models/Bug516274.oclinecore'\n{\n  abstract class Generic(T extends Generic(T));\n  class Concrete extends Generic(Concrete);\n}\n";
        TestFile testFile = this.createOCLinEcoreFile("Bug516274.oclinecore", testFileContents);
        this.doRoundTripFromOCLinEcore(testFile);
    }

    public void testBug521094_oclinecore() throws IOException, InterruptedException {
        String testFileContents = "import 'http://www.eclipse.org/emf/2002/Ecore';\nimport 'http://www.eclipse.org/emf/2003/XMLType';\n\npackage stk : stk = 'http://stk' {}";
        TestFile testFile = this.createOCLinEcoreFile("Bug521094.oclinecore", testFileContents);
        this.doRoundTripFromOCLinEcore(testFile);
    }

    public void testCompleteOCLRoundTrip_Bug496768() throws IOException, InterruptedException {
        OCL ocl = OCL.newInstance((ProjectManager)RoundTripTests.getProjectMap());
        this.getTestFileURI("Bug496768.ecore", ocl, RoundTripTests.getTestModelURI("models/ecore/Bug496768.ecore"));
        URI inputURI = this.getTestFileURI("Fruit.ocl", ocl, RoundTripTests.getTestModelURI("models/ecore/Bug496768.ocl"));
        ocl.dispose();
        this.doRoundTripFromCompleteOCL(inputURI);
    }

    public void testCompleteOCLRoundTrip_Fruit() throws IOException, InterruptedException {
        UMLStandaloneSetup.init();
        OCL ocl = OCL.newInstance((ProjectManager)RoundTripTests.getProjectMap());
        Map uriMap = ocl.getResourceSet().getURIConverter().getURIMap();
        uriMap.putAll(UML402UMLExtendedMetaData.getURIMap());
        this.getTestFileURI("Fruit.uml", ocl, RoundTripTests.getTestModelURI("models/uml/Fruit.uml"));
        URI inputURI = this.getTestFileURI("Fruit.ocl", ocl, RoundTripTests.getTestModelURI("models/uml/Fruit.ocl"));
        ocl.dispose();
        this.doRoundTripFromCompleteOCL(inputURI);
    }

    public void testCompleteOCLRoundTrip_Maps() throws IOException, InterruptedException {
        OCL ocl = OCL.newInstance((ProjectManager)RoundTripTests.getProjectMap());
        this.getTestFileURI("Maps.ecore", ocl, RoundTripTests.getTestModelURI("models/ecore/Maps.ecore"));
        URI inputURI = this.getTestFileURI("Maps.ocl", ocl, RoundTripTests.getTestModelURI("models/ecore/Maps.ocl"));
        ocl.dispose();
        this.doRoundTripFromCompleteOCL(inputURI);
    }

    public void testCompleteOCLRoundTrip_Names() throws IOException, InterruptedException {
        OCL ocl = OCL.newInstance((ProjectManager)RoundTripTests.getProjectMap());
        this.getTestFileURI("Names.ecore", ocl, RoundTripTests.getTestModelURI("models/ecore/Names.ecore"));
        URI inputURI = this.getTestFileURI("Names.ocl", ocl, RoundTripTests.getTestModelURI("models/ecore/Names.ocl"));
        ocl.dispose();
        this.doRoundTripFromCompleteOCL(inputURI);
    }

    public void testCompleteOCLRoundTrip_UML() throws IOException, InterruptedException {
        URI uml_2_5 = URI.createPlatformResourceURI((String)"UML-2.5/XMI-5-Jan-2012/Semanticed UML.ocl", (boolean)false);
        this.doRoundTripFromCompleteOCL(uml_2_5);
    }

    public void testMaps_oclinecore() throws IOException, InterruptedException {
        String testFileContents = "package any : any = 'http:/any'\n{\n\tclass Maps\n\t{\n\t\tproperty eMap2 : KeyToValue[*|1] { ordered, unique };\n\t\tproperty eMap2o : KeyToValue[*|?] { ordered, unique };\n\t\tproperty oMap1 : Map(String[1],Integer[?]);\n\t\tproperty oMap2 : Map(String[1],Integer[1]);\n\t\tproperty oMap3 : Map(String[?],Integer[?]);\n\t\tproperty oMap4 : Map(String[?],Integer[1]);\n\t\tproperty oMap5 : Map(String[1],Integer[?])[1];\n\t\tproperty oMap6 : Map(String[1],Integer[1])[1];\n\t\tproperty oMap7 : Map(String[?],Integer[?])[1];\n\t\tproperty oMap8 : Map(String[?],Integer[1])[1];\n\t\tinvariant MapIterators: Map{1 with 1}->collect(k with v | v * k)->notEmpty();\n\t}\n\tclass KeyToValue : 'java.util.Map$Entry'\n\t{\n\t\tproperty key : String[1];\n\t\tproperty value : Integer[1];\n\t}\n}\n";
        TestFile testFile = this.createOCLinEcoreFile("Maps.oclinecore", testFileContents);
        this.doRoundTripFromOCLinEcore(testFile);
    }

    public void testMultiplicitiesRoundTrip_540244() throws IOException, InterruptedException {
        String testFileContents = "package p : p = 'p'\n{\n\tclass c\n\t{\n\t\tproperty endpoints : Port[*|1] { ordered };\n\t\tproperty ports : Port[2|1] { ordered } {\n\t\t\tinitial: let v = OrderedSet{endpoints->first(), endpoints->last()}->oclAsType(OrderedSet(Port[2|1])) in v;\n\t\t}\n\t}\n\tclass Port;\n}";
        TestFile testFile = this.createOCLinEcoreFile("Multiplicities.oclinecore", testFileContents);
        this.doRoundTripFromOCLinEcore(testFile);
    }

    public void testOCLinEcoreCSTRoundTrip() throws IOException, InterruptedException, ParserException {
        URI uri = URI.createPlatformResourceURI((String)"/org.eclipse.ocl.xtext.oclinecore/model/OCLinEcoreCS.ecore", (boolean)true);
        OCLInternal ocl = OCLInternal.newInstance((ProjectManager)RoundTripTests.getProjectMap(), null);
        EnvironmentFactoryInternal environmentFactory = ocl.getEnvironmentFactory();
        RoundTripTests.getProjectMap().configureLoadFirst(environmentFactory.getResourceSet(), "http://www.eclipse.org/emf/2002/Ecore");
        this.doRoundTripFromEcore(environmentFactory, uri, uri, null);
        ocl.dispose();
    }

    public void testPivotRoundTrip() throws IOException, InterruptedException, ParserException {
        URI uri = URI.createPlatformResourceURI((String)"/org.eclipse.ocl.pivot/model/Pivot.ecore", (boolean)true);
        HashMap<@NonNull String, @Nullable Object> saveOptions = new HashMap<String, Object>();
        saveOptions.put("invariantPrefix", "validate");
        saveOptions.put("generateStructuralXmiIds", Boolean.TRUE);
        this.doRoundTripFromEcore(uri, uri, saveOptions);
    }

    public void testOCLstdlibRoundTrip() throws IOException, InterruptedException, ParserException {
        this.doRoundTripFromEcore(RoundTripTests.getTestModelURI("models/ecore/OCLstdlib.ecore"));
    }

    public void testOCLRoundTrip() throws IOException, InterruptedException, ParserException {
        HashMap<@NonNull String, @Nullable Object> options = new HashMap<String, Object>();
        options.put("addInvariantComments", true);
        this.doRoundTripFromEcore(RoundTripTests.getTestModelURI("models/ecore/OCL.ecore"), RoundTripTests.getTestModelURI("models/ecore/OCL.ecore"), options);
    }

    public void testOCLCSTRoundTrip() throws IOException, InterruptedException, ParserException {
        this.doRoundTripFromEcore(RoundTripTests.getTestModelURI("models/ecore/OCLCST.ecore"));
    }

    public void testOCLEcoreRoundTrip() throws IOException, InterruptedException, ParserException {
        this.doRoundTripFromEcore(RoundTripTests.getTestModelURI("models/ecore/OCLEcore.ecore"));
    }

    public void testSysMLRoundTrip() throws IOException, InterruptedException {
        String testFileContents = "package b : bb = 'bbb'\n{\nclass B\n{\nsysml { stereotype = 'SysML::Block'; }\n}\n}\n";
        TestFile testFile = this.createOCLinEcoreFile("SysML.oclinecore", testFileContents);
        this.doRoundTripFromOCLinEcore(testFile);
    }

    public void testTuplesRoundTrip_509533a() throws IOException, InterruptedException {
        String testFileContents = "package bug509533 : bug509533 = 'http://www.example.org/bug509533'\n{\n\tdatatype HSV : 'java.lang.String';\n\tdatatype RGB : 'java.lang.String';\n\tclass Bug509533\n\t{\n\t\toperation hsv2rgb(color : HSV) : RGB[1]\n{\n\tbody: let hsv : Sequence(String) = color.tokenize(',') in\n\tlet h : Integer = hsv->at(1).toReal().round() in\n\tlet s : Real = hsv->at(2).toReal()/100.0 in\n\tlet v : Real = hsv->at(3).toReal()/100.0 in\n\tlet c : Real = v * s in\n\tlet hh1 : Real = h/120 in\n\tlet hh2 : Real = 2 * (hh1 - hh1.floor()) in\n\tlet x : Real = c * (1 - (hh2 - 1).abs()) in\n\tlet m : Real = v -c in\n\tlet t : Tuple(r:Real,g:Real,b:Real) =\n\tif h < 60 then Tuple{r=c,g=x,b=0.0}\n\telseif h < 120 then Tuple{r=x,g=c,b=0.0}\n\telseif h < 180 then Tuple{r=0.0,g=c,b=x}\n\telseif h < 240 then Tuple{r=0.0,g=x,b=c}\n\telseif h < 300 then Tuple{r=x,g=0.0,b=c}\n\telse Tuple{r=c,g=0.0,b=x} endif in\n\tlet r = (255 * (t.r + m)).round() in\n\tlet g = (255 * (t.g + m)).round() in\n\tlet b = (255 * (t.b + m)).round() in\n\tRGB{value=r.toString() + ',' + g.toString() + ',' + b.toString()};\n}\n\n\t}\n}";
        TestFile testFile = this.createOCLinEcoreFile("Bug509533a.oclinecore", testFileContents);
        this.doRoundTripFromOCLinEcore(testFile);
    }

    public void testTuplesRoundTrip_509533b() throws IOException, InterruptedException, ParserException {
        this.doRoundTripFromEcore(RoundTripTests.getTestModelURI("models/ecore/Bug509533b.ecore"));
    }

    public void testTypes_ecore() throws IOException, InterruptedException, ParserException {
        this.doRoundTripFromEcore(RoundTripTests.getTestModelURI("models/ecore/Types.ecore"));
    }

    public void testTypes_oclinecore() throws IOException, InterruptedException {
        OCLInternal ocl = OCLInternal.newInstance((ProjectManager)RoundTripTests.getProjectMap(), null);
        TestFile testFile = this.getTestFile("Types.oclinecore", (OCL)ocl, RoundTripTests.getTestModelURI("models/oclinecore/Types.oclinecore"));
        ocl.dispose();
        this.doRoundTripFromOCLinEcore(testFile.getFileURI());
    }

    public void testXMLNamespaceRoundTrip() throws IOException, InterruptedException, ParserException {
        this.doRoundTripFromEcore(RoundTripTests.getTestModelURI("models/ecore/XMLNamespace.ecore"));
    }

    public void testXMLTypeRoundTrip() throws IOException, InterruptedException, ParserException {
        this.doRoundTripFromEcore(RoundTripTests.getTestModelURI("models/ecore/XMLType.ecore"));
    }
}

