/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.test.xtext;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.extlibrary.Book;
import org.eclipse.ocl.examples.extlibrary.EXTLibraryFactory;
import org.eclipse.ocl.examples.extlibrary.EXTLibraryPackage;
import org.eclipse.ocl.examples.extlibrary.Library;
import org.eclipse.ocl.examples.xtext.tests.XtextTestCase;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.internal.labels.LabelSubstitutionLabelProvider;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.Query;
import org.eclipse.ocl.pivot.validation.ComposedEValidator;
import org.eclipse.ocl.pivot.validation.ValidationRegistryAdapter;
import org.eclipse.ocl.xtext.completeocl.validation.CompleteOCLEObjectValidator;

public class PivotDocumentationExamples
extends XtextTestCase {
    public void debugPrintf(String format, Object ... args) {
    }

    public InputStream getInputStream(String fileName) throws MalformedURLException, IOException {
        URI uri = PivotDocumentationExamples.getTestModelURI(fileName);
        URL url = new URL(uri.toString());
        return url.openStream();
    }

    public URI getInputURI(String fileName) throws MalformedURLException, IOException {
        return PivotDocumentationExamples.getTestModelURI(fileName);
    }

    private @NonNull List<Library> getLibraries(ResourceSet resourceSet) {
        URI uri = PivotDocumentationExamples.getTestModelURI("models/documentation/PivotDocumentationExamples.extlibrary");
        resourceSet.getPackageRegistry().put((Object)"http://www.org.eclipse/ocl/examples/library/extlibrary.ecore/1.0.0", (Object)EXTLibraryPackage.eINSTANCE);
        Resource resource = resourceSet.getResource(uri, true);
        EList libraries = resource.getContents();
        return libraries;
    }

    public Library getLibrary(ResourceSet resourceSet) {
        Resource resource = resourceSet.createResource(URI.createURI((String)"test.xmi"));
        Library library = EXTLibraryFactory.eINSTANCE.createLibrary();
        resource.getContents().add((Object)library);
        Book aBook = EXTLibraryFactory.eINSTANCE.createBook();
        aBook.setTitle("Bleak House");
        library.getBooks().add((Object)aBook);
        Book bBook = EXTLibraryFactory.eINSTANCE.createBook();
        bBook.setTitle("Bleak House");
        library.getBooks().add((Object)bBook);
        return library;
    }

    public void test_parsingConstraintsExample() throws IOException, ParserException {
        ResourceSetImpl myResourceSet = new ResourceSetImpl();
        OCL ocl = OCL.newInstance((ResourceSet)myResourceSet);
        assert (ocl != null && myResourceSet != null);
        ocl.dispose();
        OCL ocl2 = OCL.newInstance((ProjectManager)ProjectManager.CLASS_PATH);
        ResourceSet resourceSet = ocl2.getResourceSet();
        EClass contextEClass = EXTLibraryPackage.Literals.LIBRARY;
        ExpressionInOCL invariant = ocl2.createInvariant((EObject)contextEClass, "books->forAll(b1, b2 | b1 <> b2 implies b1.title <> b2.title)");
        ExpressionInOCL query = ocl2.createQuery((EObject)contextEClass, "books->collect(b : Book | b.category)->asSet()");
        EOperation contextEOperation = (EOperation)NameUtil.getENamedElement((Iterable)EcorePackage.Literals.EMODEL_ELEMENT.getEOperations(), (String)"getEAnnotation");
        ExpressionInOCL body = ocl2.createPostcondition(contextEOperation, "result = self.eAnnotations->any(ann | ann.source = source)");
        EReference contextEReference = EcorePackage.Literals.EREFERENCE__EREFERENCE_TYPE;
        ExpressionInOCL derive = ocl2.createQuery((EObject)contextEReference, "self.eType->any(true).oclAsType(EClass)");
        try {
            ocl2.createInvariant((EObject)contextEClass, "books->forall(true)");
        }
        catch (ParserException parserException) {
            // empty catch block
        }
        ocl2.dispose();
        if (body != derive || invariant == query) {
            // empty if block
        }
    }

    public void test_evaluatingConstraintsExample() throws IOException, ParserException {
        OCL ocl = OCL.newInstance((ProjectManager)OCL.CLASS_PATH);
        ResourceSet resourceSet = ocl.getResourceSet();
        ExpressionInOCL invariant = ocl.createInvariant((EObject)EXTLibraryPackage.Literals.LIBRARY, "books->forAll(b1, b2 | b1 <> b2 implies b1.title <> b2.title)");
        ExpressionInOCL query = ocl.createQuery((EObject)EXTLibraryPackage.Literals.LIBRARY, "books->collect(b : Book | b.category)->asSet()");
        Query queryEval = ocl.createQuery(query);
        Query constraintEval = ocl.createQuery(invariant);
        List<Library> libraries = this.getLibraries(resourceSet);
        for (Library next : libraries) {
            if (!constraintEval.checkEcore((Object)next)) continue;
            Set categories = (Set)queryEval.evaluateUnboxed((Object)next);
            this.debugPrintf("%s: %s%n\n", next.getName(), categories);
        }
        Library lib = this.getLibrary(resourceSet);
        this.debugPrintf("%s valid: %b\n", lib.getName(), ocl.check((Object)lib, invariant));
        for (Library next : constraintEval.selectEcore(libraries)) {
            Set categories = (Set)queryEval.evaluateUnboxed((Object)next);
            this.debugPrintf("%s: %s%n\n", next.getName(), categories);
        }
        ocl.dispose();
    }

    public void test_parsingDocumentsExample() throws IOException, ParserException {
        OCL ocl1 = OCL.newInstance((ProjectManager)OCL.CLASS_PATH);
        ocl1.dispose();
        EPackageRegistryImpl registry = new EPackageRegistryImpl();
        registry.put((Object)"http://www.org.eclipse/ocl/examples/library/extlibrary.ecore/1.0.0", (Object)EXTLibraryPackage.eINSTANCE);
        OCL ocl = OCL.newInstance((EPackage.Registry)registry);
        ResourceSet resourceSet = ocl.getResourceSet();
        URI uri = this.getInputURI("/models/documentation/parsingDocumentsExample.ocl");
        Resource asResource = (Resource)ClassUtil.nonNullState((Object)ocl.parse(uri));
        HashMap<String, ExpressionInOCL> constraintMap = new HashMap<String, ExpressionInOCL>();
        TreeIterator tit = asResource.getAllContents();
        while (tit.hasNext()) {
            String name;
            Constraint constraint;
            ExpressionInOCL expressionInOCL;
            EObject next = (EObject)tit.next();
            if (!(next instanceof Constraint) || (expressionInOCL = ocl.getSpecification(constraint = (Constraint)next)) == null || (name = constraint.getName()) == null) continue;
            constraintMap.put(name, expressionInOCL);
            this.debugPrintf("%s: %s%n\n", name, expressionInOCL.getOwnedBody());
        }
        Library library = this.getLibrary(resourceSet);
        ExpressionInOCL expression = ocl.createQuery((EObject)EXTLibraryPackage.Literals.LIBRARY, "getBooks('Bleak House')->asSequence()->first()");
        Book book = (Book)ocl.evaluate((Object)library, expression);
        this.debugPrintf("Got book: %s%n\n", book);
        boolean isValid = ocl.check((Object)book, (ExpressionInOCL)ClassUtil.nonNullState((Object)((ExpressionInOCL)constraintMap.get("unique_title"))));
        this.debugPrintf("Validate book: %b%n\n", isValid);
        EXTLibraryPackage extPackage = EXTLibraryPackage.eINSTANCE;
        ValidationRegistryAdapter validationRegistry = ValidationRegistryAdapter.getAdapter((ResourceSet)resourceSet);
        ComposedEValidator newEValidator = ComposedEValidator.install((EValidator.Registry)validationRegistry, (EPackage)extPackage);
        newEValidator.addChild((EValidator)new CompleteOCLEObjectValidator((EPackage)extPackage, uri));
        Resource resource = library.eResource();
        MyDiagnostician diagnostician = new MyDiagnostician((EValidator.Registry)validationRegistry);
        Diagnostic diagnostics = diagnostician.validate(resource);
        if (diagnostics.getSeverity() != 0) {
            String formattedDiagnostics = PivotUtil.formatDiagnostics((Diagnostic)diagnostics, (String)"\n");
            this.debugPrintf("Validation: %s\n", formattedDiagnostics);
        }
        PivotDocumentationExamples.assertEquals((int)4, (int)diagnostics.getSeverity());
        PivotDocumentationExamples.assertEquals((int)4, (int)diagnostics.getChildren().size());
        ocl.dispose();
    }

    public void zztest_code_snippets() {
        EObject eObject = null;
        Diagnostician diagnostician = Diagnostician.INSTANCE;
        Map context = diagnostician.createDefaultContext();
        BasicDiagnostic diagnostics = diagnostician.createDefaultDiagnostic(eObject);
        diagnostician.validate(eObject, (DiagnosticChain)diagnostics, context);
    }

    public class MyDiagnostician
    extends Diagnostician {
        public MyDiagnostician(EValidator.Registry eValidatorRegistry) {
            super(eValidatorRegistry);
        }

        public Map<Object, Object> createDefaultContext() {
            Map context = super.createDefaultContext();
            context.put(EValidator.SubstitutionLabelProvider.class, new LabelSubstitutionLabelProvider());
            return context;
        }

        public BasicDiagnostic createDefaultDiagnostic(Resource resource) {
            return new BasicDiagnostic("org.eclipse.emf.ecore", 0, EMFEditUIPlugin.INSTANCE.getString("_UI_DiagnosisOfNObjects_message", (Object[])new String[]{"1"}), new Object[]{resource});
        }

        public Diagnostic validate(Resource resource) {
            BasicDiagnostic diagnostics = this.createDefaultDiagnostic(resource);
            Map<Object, Object> context = this.createDefaultContext();
            for (EObject eObject : resource.getContents()) {
                this.validate(eObject, (DiagnosticChain)diagnostics, context);
            }
            return diagnostics;
        }
    }
}

