/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.impactanalyzer.benchmark.preparation.notifications;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EEnumImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.ocl.examples.impactanalyzer.benchmark.preparation.notifications.NotificationHelper;
import org.eclipse.ocl.examples.impactanalyzer.benchmark.preparation.notifications.RealWorldReplayNotificationProducer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RawNotification {
    public static final String LINK_ADD_EVENT = "LinkAddEvent";
    public static final String LINK_REMOVE_EVENT = "LinkRemoveEvent";
    public static final String ATTRIBUTE_VALUE_CHANGE_EVENT = "AttributeValueChangeEvent";
    public static final String ELEMENT_DELETE_EVENT = "ElementDeleteEvent";
    public static final String ELEMENT_CREATE_EVENT = "ElementCreateEvent";
    private final String eventType;
    private final Map<String, String> attributeMap;
    private int splitNumber = -1;

    public RawNotification(String eventType, Map<String, String> attributeMap) {
        this.eventType = eventType;
        this.attributeMap = attributeMap;
    }

    public String getEventType() {
        return this.eventType;
    }

    public Map<String, String> getAttributeMap() {
        return this.attributeMap;
    }

    public boolean isSplitCandidate() {
        return this.getEventType().equals(LINK_ADD_EVENT) || this.getEventType().equals(LINK_REMOVE_EVENT);
    }

    public boolean wasSplitted() {
        return this.isSplitCandidate() && this.splitNumber >= 0;
    }

    public int getSplitNumber() {
        assert (this.wasSplitted());
        return this.splitNumber;
    }

    private void setSplitNumber(int i) {
        assert (this.isSplitCandidate());
        this.splitNumber = i;
    }

    public ArrayList<RawNotification> split() {
        if (!this.isSplitCandidate()) {
            throw new RuntimeException("This notification cannot be splitted");
        }
        ArrayList<RawNotification> result = new ArrayList<RawNotification>();
        if (this.getEventType().equals(LINK_ADD_EVENT) || this.getEventType().equals(LINK_REMOVE_EVENT)) {
            int i = 0;
            while (i < 2) {
                RawNotification noti = new RawNotification(this.getEventType(), this.getAttributeMap());
                noti.setSplitNumber(i);
                result.add(noti);
                ++i;
            }
        }
        return result;
    }

    public Notification convertToNotification(Resource resource) {
        if (this.getEventType().equals(ATTRIBUTE_VALUE_CHANGE_EVENT)) {
            String mofId = this.getAttributeMap().get("MRI").split("#")[1];
            EObject obj = resource.getEObject(mofId);
            EAttribute attribute = null;
            if (obj != null) {
                for (EObject contentObject : obj.eClass().getEAllAttributes()) {
                    if (!(contentObject instanceof EAttribute) || !((EAttribute)contentObject).getName().equals(this.getAttributeMap().get("attribute"))) continue;
                    attribute = (EAttribute)contentObject;
                }
                if (attribute != null) {
                    String oldValue = this.getAttributeMap().get("oldValue");
                    String newValue = this.getAttributeMap().get("newValue");
                    Object oldValueParsed = null;
                    Object newValueParsed = null;
                    if (oldValue.equalsIgnoreCase("true") || oldValue.equalsIgnoreCase("false")) {
                        oldValueParsed = Boolean.parseBoolean(oldValue);
                        newValueParsed = Boolean.parseBoolean(newValue);
                    }
                    if (oldValueParsed == null || newValueParsed == null) {
                        try {
                            oldValueParsed = Integer.parseInt(oldValue);
                            newValueParsed = Integer.parseInt(newValue);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if (oldValueParsed == null || newValueParsed == null) {
                        oldValueParsed = oldValue;
                        newValueParsed = newValue;
                    }
                    if (attribute.getEAttributeType() instanceof EEnumImpl) {
                        EEnumImpl enumType = (EEnumImpl)attribute.getEAttributeType();
                        Class enumClass = enumType.getInstanceClass();
                        T[] TArray = enumClass.getEnumConstants();
                        int n = TArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object constant = TArray[n2];
                            if (constant.toString().equals(oldValue)) {
                                oldValueParsed = constant;
                            }
                            if (constant.toString().equals(newValue)) {
                                newValueParsed = constant;
                            }
                            ++n2;
                        }
                        if (oldValue.equals("null")) {
                            oldValueParsed = null;
                        }
                        if (newValue.equals("null")) {
                            newValueParsed = null;
                        }
                    }
                    return NotificationHelper.createAttributeChangeNotification((EObject)obj, (EAttribute)attribute, (Object)oldValueParsed, (Object)newValueParsed);
                }
            }
        } else if (this.getEventType().equals(LINK_REMOVE_EVENT)) {
            String mofId1 = this.getAttributeMap().get("MRI1").split("#")[1];
            EObject obj1 = resource.getEObject(mofId1);
            String mofId2 = this.getAttributeMap().get("MRI2").split("#")[1];
            EObject obj2 = resource.getEObject(mofId2);
            if (obj1 != null && obj2 != null) {
                if (this.wasSplitted() && this.getSplitNumber() == 0) {
                    return this.createLinkRemoveNotification(obj1, obj2);
                }
                if (this.wasSplitted() && this.getSplitNumber() == 1) {
                    return this.createLinkRemoveNotification(obj2, obj1);
                }
                return null;
            }
        } else if (this.getEventType().equals(LINK_ADD_EVENT)) {
            String mofId1 = this.getAttributeMap().get("MRI1").split("#")[1];
            EObject obj1 = resource.getEObject(mofId1);
            String mofId2 = this.getAttributeMap().get("MRI2").split("#")[1];
            EObject obj2 = resource.getEObject(mofId2);
            String rolename1 = this.getAttributeMap().get("AE2");
            String rolename2 = this.getAttributeMap().get("AE3");
            if (obj1 != null && obj2 != null) {
                if (this.wasSplitted() && this.getSplitNumber() == 0) {
                    return this.createLinkAddNotification(obj1, obj2, rolename1, rolename2);
                }
                if (this.wasSplitted() && this.getSplitNumber() == 1) {
                    return this.createLinkAddNotification(obj2, obj1, rolename2, rolename1);
                }
                return null;
            }
        } else if (this.getEventType().equals(ELEMENT_DELETE_EVENT)) {
            String mofId = this.getAttributeMap().get("MRI").split("#")[1];
            EObject obj = resource.getEObject(mofId);
            if (obj != null) {
                return NotificationHelper.createElementDeleteNotification((EObject)obj);
            }
        } else if (this.getEventType().equals(ELEMENT_CREATE_EVENT)) {
            ClassLoader classLoader = RealWorldReplayNotificationProducer.class.getClassLoader();
            try {
                String type = this.getAttributeMap().get("type");
                String[] splittedType = type.split("\\.");
                String clazz = splittedType[splittedType.length - 1];
                String packagePath = type.split(clazz)[0];
                String fullPackagePath = String.valueOf(packagePath.toLowerCase()) + splittedType[splittedType.length - 2].substring(0, 1).toUpperCase() + splittedType[splittedType.length - 2].substring(1).toLowerCase() + "Package";
                Class<?> aClass = classLoader.loadClass(fullPackagePath);
                Field instance = aClass.getField("eINSTANCE");
                EPackage pack = (EPackage)instance.get(null);
                Method thisMethod = pack.getClass().getDeclaredMethod("get" + clazz, new Class[0]);
                EClass classToCreate = (EClass)thisMethod.invoke((Object)pack, new Object[0]);
                EObject obj = pack.getEFactoryInstance().create(classToCreate);
                Notification res = NotificationHelper.createNewElementAddToResourceNotification((EObject)obj, (Resource)resource);
                ((XMLResource)resource).setID(obj, this.getAttributeMap().get("MRI").split("#")[1]);
                return res;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private Notification createLinkRemoveNotification(EObject obj1, EObject obj2) {
        for (EReference reference : obj1.eClass().getEAllReferences()) {
            if (obj1.eGet((EStructuralFeature)reference) == null) continue;
            if (obj1.eGet((EStructuralFeature)reference) instanceof EList) {
                EList eObjectList = (EList)obj1.eGet((EStructuralFeature)reference);
                for (EObject referencedObj : eObjectList) {
                    if (!referencedObj.equals(obj2)) continue;
                    return NotificationHelper.createReferenceRemoveNotification((EObject)obj1, (EReference)reference, (EObject)obj2);
                }
                continue;
            }
            if (!obj1.eGet((EStructuralFeature)reference).equals(obj2)) continue;
            return NotificationHelper.createReferenceRemoveNotification((EObject)obj1, (EReference)reference, (EObject)obj2);
        }
        return null;
    }

    private Notification createLinkAddNotification(EObject obj1, EObject obj2, String rolename1, String rolename2) {
        Notification result = null;
        for (EReference reference : obj1.eClass().getEAllReferences()) {
            if (!reference.getEType().isInstance((Object)obj2) || !reference.getName().equals(rolename1) && !reference.getName().equals(rolename2)) continue;
            result = NotificationHelper.createReferenceAddNotification((EObject)obj1, (EReference)reference, (EObject)obj2);
        }
        return result;
    }
}

