/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.test.xtext;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.utilities.CGUtil;
import org.eclipse.ocl.examples.pivot.tests.TestOCL;
import org.eclipse.ocl.examples.xtext.idioms.IdiomsStandaloneSetup;
import org.eclipse.ocl.examples.xtext.serializer.DeclarativeFormatter;
import org.eclipse.ocl.examples.xtext.tests.XtextTestCase;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.DebugTimestamp;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.XMIUtil;
import org.eclipse.ocl.xtext.base.BaseStandaloneSetup;
import org.eclipse.ocl.xtext.completeocl.CompleteOCLStandaloneSetup;
import org.eclipse.ocl.xtext.essentialocl.EssentialOCLStandaloneSetup;
import org.eclipse.ocl.xtext.oclinecore.OCLinEcoreStandaloneSetup;
import org.eclipse.ocl.xtext.oclstdlib.OCLstdlibStandaloneSetup;
import org.eclipse.xtext.formatting.INodeModelFormatter;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

public class IdiomsLoadTests
extends XtextTestCase {
    protected static final @NonNull String @NonNull [] NO_MESSAGES = new String[0];

    public @Nullable String readFile(@NonNull InputStream inputStream) throws IOException {
        int len;
        InputStreamReader reader = new InputStreamReader(inputStream);
        StringBuilder s = new StringBuilder();
        char[] buf = new char[16384];
        while ((len = reader.read(buf)) >= 0) {
            s.append(buf, 0, len);
        }
        ((Reader)reader).close();
        return s.toString();
    }

    public @NonNull TestOCL createOCL() {
        return new TestOCL(this.getTestFileSystem(), "LoadTests", this.getName(), OCL.NO_PROJECTS, null);
    }

    public @NonNull TestOCL createOCLWithProjectMap() {
        return new TestOCL(this.getTestFileSystem(), "LoadTests", this.getName(), (ProjectManager)IdiomsLoadTests.getProjectMap(), null);
    }

    public Resource doLoad_Idioms(@NonNull OCL ocl, URI inputURI) throws IOException {
        ResourceSet resourceSet = ocl.getResourceSet();
        IdiomsLoadTests.getProjectMap().initializeResourceSet(resourceSet);
        InputStream oldStream = resourceSet.getURIConverter().createInputStream(inputURI, null);
        String oldText = this.readFile(oldStream);
        String extension = inputURI.fileExtension();
        String stem = inputURI.trimFileExtension().lastSegment();
        String outputName = String.valueOf(stem) + "." + extension + ".xmi";
        String output2Name = String.valueOf(stem) + ".saved." + extension;
        URI outputURI = this.getTestFileURI(outputName);
        URI output2URI = this.getTestFileURI(output2Name);
        Resource xtextResource = null;
        xtextResource = resourceSet.getResource(inputURI, true);
        IdiomsLoadTests.assertNoResourceErrors("Load failed", xtextResource);
        IdiomsLoadTests.assertNoUnresolvedProxies("Unresolved proxies", xtextResource);
        IdiomsLoadTests.assertNoValidationErrors("Validation errors", (EObject)xtextResource.getContents().get(0));
        xtextResource.setURI(output2URI);
        DebugTimestamp debugTimestamp = new DebugTimestamp(xtextResource.getURI().toString());
        xtextResource.save(XMIUtil.createSaveOptions());
        debugTimestamp.log("Serialization save done");
        IdiomsLoadTests.assertNoResourceErrors("Save failed", xtextResource);
        InputStream newStream = resourceSet.getURIConverter().createInputStream(xtextResource.getURI(), null);
        String newText = this.readFile(newStream);
        IdiomsLoadTests.assertEquals((String)oldText, (String)newText);
        Resource xmiResource = resourceSet.createResource(outputURI);
        xmiResource.getContents().addAll((Collection)xtextResource.getContents());
        return xmiResource;
    }

    public void doReformat_Idioms(@NonNull OCL ocl, URI inputURI) throws IOException {
        ResourceSet resourceSet = ocl.getResourceSet();
        IdiomsLoadTests.getProjectMap().initializeResourceSet(resourceSet);
        String extension = inputURI.fileExtension();
        String stem = inputURI.trimFileExtension().lastSegment();
        String outputName = String.valueOf(stem) + "." + extension + ".xmi";
        String output2Name = String.valueOf(stem) + ".saved." + extension;
        URI outputURI = this.getTestFileURI(outputName);
        URI output2URI = this.getTestFileURI(output2Name);
        Resource xtextResource = null;
        xtextResource = resourceSet.getResource(inputURI, true);
        IdiomsLoadTests.assertNoResourceErrors("Load failed", xtextResource);
        IdiomsLoadTests.assertNoUnresolvedProxies("Unresolved proxies", xtextResource);
        IdiomsLoadTests.assertNoValidationErrors("Validation errors", (EObject)xtextResource.getContents().get(0));
        xtextResource.setURI(output2URI);
        EObject rootEObject = (EObject)xtextResource.getContents().get(0);
        ICompositeNode rootNode = NodeModelUtils.getNode((EObject)rootEObject);
        assert (rootNode != null);
        int rootOffset = rootNode.getOffset();
        int rootLength = rootNode.getLength();
        int totalOffset = rootNode.getTotalOffset();
        int totalLength = rootNode.getTotalLength();
        String text = rootNode.getText();
        DeclarativeFormatter instance = (DeclarativeFormatter)new IdiomsStandaloneSetup().createInjector().getInstance(DeclarativeFormatter.class);
        rootOffset += rootLength / 4;
        INodeModelFormatter.IFormattedRegion region = instance.format(rootNode, rootOffset, rootLength /= 2);
        String formattedText = region.getFormattedText();
        if (rootOffset == 0) {
            IdiomsLoadTests.assertEquals((String)text, (String)formattedText);
        } else if (!text.contains(formattedText)) {
            IdiomsLoadTests.assertEquals((String)text, (String)formattedText);
        }
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        IdiomsStandaloneSetup.doSetup();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testIdiomsLoad_Base_idioms() throws IOException, InterruptedException {
        TestOCL ocl = this.createOCL();
        URI idiomsURI = this.getTestFileURI("Base.idioms", BaseStandaloneSetup.class.getResourceAsStream("Base.idioms"));
        this.doLoad_Idioms((OCL)ocl, idiomsURI);
        ocl.dispose();
    }

    public void testIdiomsLoad_CompleteOCL_idioms() throws IOException, InterruptedException {
        if (CGUtil.isMavenSurefire() || CGUtil.isTychoSurefire()) {
            System.err.println(String.valueOf(this.getName()) + " has been disabled -see Bug 569138");
            return;
        }
        TestOCL ocl = this.createOCL();
        URI idiomsURI = this.getTestFileURI("CompleteOCL.idioms", CompleteOCLStandaloneSetup.class.getResourceAsStream("CompleteOCL.idioms"));
        this.doLoad_Idioms((OCL)ocl, idiomsURI);
        ocl.dispose();
    }

    public void testIdiomsLoad_DebugTest_idioms() throws IOException, InterruptedException {
        TestOCL ocl = this.createOCL();
        URI idiomsURI = URI.createPlatformResourceURI((String)"/org.eclipse.ocl.examples.xtext.tests/models/idioms/DebugTest.idioms", (boolean)true);
        this.doLoad_Idioms((OCL)ocl, idiomsURI);
        ocl.dispose();
    }

    public void testIdiomsLoad_Reformat_DebugTest_idioms() throws IOException, InterruptedException {
        TestOCL ocl = this.createOCL();
        URI idiomsURI = URI.createPlatformResourceURI((String)"/org.eclipse.ocl.examples.xtext.tests/models/idioms/DebugTest.idioms", (boolean)true);
        this.doReformat_Idioms((OCL)ocl, idiomsURI);
        ocl.dispose();
    }

    public void testIdiomsLoad_EssentialOCL_idioms() throws IOException, InterruptedException {
        if (CGUtil.isMavenSurefire() || CGUtil.isTychoSurefire()) {
            System.err.println(String.valueOf(this.getName()) + " has been disabled -see Bug 569138");
            return;
        }
        TestOCL ocl = this.createOCL();
        URI idiomsURI = this.getTestFileURI("EssentialOCL.idioms", EssentialOCLStandaloneSetup.class.getResourceAsStream("EssentialOCL.idioms"));
        this.doLoad_Idioms((OCL)ocl, idiomsURI);
        ocl.dispose();
    }

    public void testIdiomsLoad_Idioms_idioms() throws IOException, InterruptedException {
        TestOCL ocl = this.createOCL();
        URI idiomsURI = this.getTestFileURI("Idioms.idioms", IdiomsStandaloneSetup.class.getResourceAsStream("Idioms.idioms"));
        this.doLoad_Idioms((OCL)ocl, idiomsURI);
        ocl.dispose();
    }

    public void testIdiomsLoad_Reformat_Idioms_idioms() throws IOException, InterruptedException {
        TestOCL ocl = this.createOCL();
        URI idiomsURI = this.getTestFileURI("Idioms.idioms", IdiomsStandaloneSetup.class.getResourceAsStream("Idioms.idioms"));
        this.doReformat_Idioms((OCL)ocl, idiomsURI);
        ocl.dispose();
    }

    public void testIdiomsLoad_OCLinEcore_idioms() throws IOException, InterruptedException {
        if (CGUtil.isMavenSurefire() || CGUtil.isTychoSurefire()) {
            System.err.println(String.valueOf(this.getName()) + " has been disabled -see Bug 569138");
            return;
        }
        TestOCL ocl = this.createOCL();
        URI idiomsURI = this.getTestFileURI("OCLinEcore.idioms", OCLinEcoreStandaloneSetup.class.getResourceAsStream("OCLinEcore.idioms"));
        this.doLoad_Idioms((OCL)ocl, idiomsURI);
        ocl.dispose();
    }

    public void testIdiomsLoad_OCLstdlib_idioms() throws IOException, InterruptedException {
        if (CGUtil.isMavenSurefire() || CGUtil.isTychoSurefire()) {
            System.err.println(String.valueOf(this.getName()) + " has been disabled -see Bug 569138");
            return;
        }
        TestOCL ocl = this.createOCL();
        URI idiomsURI = this.getTestFileURI("OCLstdlib.idioms", OCLstdlibStandaloneSetup.class.getResourceAsStream("OCLstdlib.idioms"));
        this.doLoad_Idioms((OCL)ocl, idiomsURI);
        ocl.dispose();
    }

    public void testIdiomsLoad_Test_idioms() throws IOException, InterruptedException {
        TestOCL ocl = this.createOCL();
        URI idiomsURI = URI.createPlatformResourceURI((String)"/org.eclipse.ocl.examples.xtext.tests/models/idioms/Test.idioms", (boolean)true);
        this.doLoad_Idioms((OCL)ocl, idiomsURI);
        ocl.dispose();
    }

    public void testIdiomsLoad_Xtext_idioms() throws IOException, InterruptedException {
        TestOCL ocl = this.createOCL();
        URI idiomsURI = URI.createPlatformResourceURI((String)"/org.eclipse.ocl.examples.xtext.tests/models/idioms/Xtext.idioms", (boolean)true);
        this.doLoad_Idioms((OCL)ocl, idiomsURI);
        ocl.dispose();
    }

    public void testIdiomsLoad_Reformat_Xtext_idioms() throws IOException, InterruptedException {
        TestOCL ocl = this.createOCL();
        URI idiomsURI = URI.createPlatformResourceURI((String)"/org.eclipse.ocl.examples.xtext.tests/models/idioms/Xtext.idioms", (boolean)true);
        this.doReformat_Idioms((OCL)ocl, idiomsURI);
        ocl.dispose();
    }
}

