/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.taglib.control;

import java.text.MessageFormat;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.XPathContextExtender;
import org.eclipse.jet.internal.l10n.JET2Messages;
import org.eclipse.jet.taglib.AbstractIteratingTag;
import org.eclipse.jet.taglib.JET2TagException;
import org.eclipse.jet.taglib.TagInfo;
import org.eclipse.jet.xpath.NodeSet;

public class IterateTag
extends AbstractIteratingTag {
    private Object[] selectedObjects;
    private int currentIndex;
    private String varName;
    private Object savedVarValue = null;
    private boolean nodeSetIteration;
    private long maxIterations = 0L;

    public boolean doEvalLoopCondition(TagInfo tc, JET2Context context) throws JET2TagException {
        boolean doAnotherIteration;
        boolean bl = doAnotherIteration = (long)this.currentIndex < this.maxIterations;
        if (doAnotherIteration) {
            if (this.nodeSetIteration) {
                context.setVariable(this.varName, this.selectedObjects[this.currentIndex]);
            } else {
                context.setVariable(this.varName, new Long(this.currentIndex + 1));
            }
        } else {
            context.removeVariable(this.varName);
            if (this.savedVarValue != null) {
                context.setVariable(this.varName, this.savedVarValue);
            }
        }
        ++this.currentIndex;
        return doAnotherIteration;
    }

    public void doInitializeLoop(TagInfo td, JET2Context context) throws JET2TagException {
        Object resultObject;
        String selectXPath = this.getAttribute("select");
        this.varName = this.getAttribute("var");
        this.setDelimiter(this.getAttribute("delimiter"));
        XPathContextExtender xpathContext = XPathContextExtender.getInstance(context);
        if (context.hasVariable(this.varName)) {
            this.savedVarValue = context.getVariable(this.varName);
        }
        if ((resultObject = xpathContext.resolveAsObject(xpathContext.currentXPathContextObject(), selectXPath)) instanceof Number) {
            this.nodeSetIteration = false;
            this.maxIterations = ((Number)resultObject).longValue();
        } else if (resultObject instanceof NodeSet) {
            this.nodeSetIteration = true;
            this.selectedObjects = ((NodeSet)resultObject).toArray();
            this.maxIterations = this.selectedObjects.length;
        } else {
            throw new JET2TagException(MessageFormat.format(JET2Messages.IterateTag_CannotIterateOnResult, selectXPath));
        }
        this.currentIndex = 0;
    }
}

