/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.blackbox;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalModuleEnv;
import org.eclipse.m2m.internal.qvt.oml.blackbox.AbstractCompilationUnitDescriptor;
import org.eclipse.m2m.internal.qvt.oml.blackbox.BlackboxException;
import org.eclipse.m2m.internal.qvt.oml.blackbox.CompilationUnit;
import org.eclipse.m2m.internal.qvt.oml.blackbox.LoadContext;
import org.eclipse.m2m.internal.qvt.oml.blackbox.ResolutionContext;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModuleInstance;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModuleInstanceFactory;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CallHandler;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CallHandlerAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBlackboxProvider {
    protected AbstractBlackboxProvider() {
    }

    protected String getProviderID() {
        return "unknown";
    }

    protected CompilationUnit createCompilationUnit(QvtOperationalModuleEnv moduleEnv) {
        return this.createCompilationUnit(Collections.singletonList(moduleEnv));
    }

    protected CompilationUnit createCompilationUnit(final List<QvtOperationalModuleEnv> loadedModules) {
        return new CompilationUnit(){

            @Override
            public List<QvtOperationalModuleEnv> getElements() {
                return Collections.unmodifiableList(loadedModules);
            }
        };
    }

    protected void setInstanceAdapterFactory(Module module, final InstanceAdapterFactory factory) {
        ModuleInstanceFactory moduleInstanceFactory = (ModuleInstanceFactory)module.getEFactoryInstance();
        moduleInstanceFactory.addPostCreateHandler(new ModuleInstanceFactory.PostCreateHandler(){

            public void created(ModuleInstance moduleInstance) {
                Object adapterInstance = factory.createAdapter(moduleInstance);
                moduleInstance.getAdapter(ModuleInstance.Internal.class).addAdapter(adapterInstance);
            }
        });
    }

    protected void setOperationHandler(EOperation operation, final CallHandler handler, boolean adaptSource) {
        CallHandler actualHandler = handler;
        if (adaptSource) {
            actualHandler = new CallHandler(){

                public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
                    return handler.invoke(module, source, args, evalEnv);
                }
            };
        }
        CallHandlerAdapter.attach(operation, actualHandler);
    }

    public abstract List<AbstractCompilationUnitDescriptor> getModuleDescriptors(ResolutionContext var1);

    public abstract AbstractCompilationUnitDescriptor getModuleDescriptor(String var1, ResolutionContext var2);

    public abstract CompilationUnit loadCompilationUnit(AbstractCompilationUnitDescriptor var1, LoadContext var2) throws BlackboxException;

    protected static interface InstanceAdapterFactory {
        public Object createAdapter(EObject var1);
    }
}

