/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.gmf.internal.xpand.BuiltinMetaModel;

public class CollectionTypesSupport {
    private final Map<EClassifier, EClass> collectionsM1 = new HashMap<EClassifier, EClass>();
    private final Map<EClassifier, EClass> listsM1 = new HashMap<EClassifier, EClass>();
    private final Map<EClassifier, EClass> setsM1 = new HashMap<EClassifier, EClass>();
    static final EClass COLLECTION_TYPE = EcoreFactory.eINSTANCE.createEClass();
    static final EClass LIST_TYPE = EcoreFactory.eINSTANCE.createEClass();
    static final EClass SET_TYPE = EcoreFactory.eINSTANCE.createEClass();
    static EClass COLLECTION_OF_OBJECT;
    static EClass LIST_OF_OBJECT;
    static EClass SET_OF_OBJECT;

    void init(EPackage xecore, EClass parameterizedType) {
        COLLECTION_TYPE.setName("Collection");
        LIST_TYPE.setName("List");
        SET_TYPE.setName("Set");
        COLLECTION_TYPE.getESuperTypes().add((Object)parameterizedType);
        LIST_TYPE.getESuperTypes().add((Object)COLLECTION_TYPE);
        SET_TYPE.getESuperTypes().add((Object)COLLECTION_TYPE);
        xecore.getEClassifiers().add((Object)COLLECTION_TYPE);
        xecore.getEClassifiers().add((Object)LIST_TYPE);
        xecore.getEClassifiers().add((Object)SET_TYPE);
        COLLECTION_OF_OBJECT = CollectionTypesSupport.newCollectionType((EClassifier)EcorePackage.eINSTANCE.getEJavaObject());
        LIST_OF_OBJECT = CollectionTypesSupport.newListType((EClassifier)EcorePackage.eINSTANCE.getEJavaObject());
        SET_OF_OBJECT = CollectionTypesSupport.newSetType((EClassifier)EcorePackage.eINSTANCE.getEJavaObject());
        this.collectionsM1.put(null, CollectionTypesSupport.newCollectionType((EClassifier)BuiltinMetaModel.VOID));
        this.listsM1.put(null, CollectionTypesSupport.newListType((EClassifier)BuiltinMetaModel.VOID));
        this.setsM1.put(null, CollectionTypesSupport.newSetType((EClassifier)BuiltinMetaModel.VOID));
    }

    public boolean isCollectionMetaType(String name) {
        return COLLECTION_TYPE.getName().equals(name) || LIST_TYPE.getName().equals(name) || SET_TYPE.getName().equals(name);
    }

    public EClass getCollectionType(String metaTypeName, EClassifier innerType) {
        assert (this.isCollectionMetaType(metaTypeName));
        if (LIST_TYPE.getName().equals(metaTypeName)) {
            return this.getListType(innerType);
        }
        if (SET_TYPE.getName().equals(metaTypeName)) {
            return this.getSetType(innerType);
        }
        if (COLLECTION_TYPE.getName().equals(metaTypeName)) {
            return this.getCollectionType(innerType);
        }
        throw new IllegalStateException();
    }

    EClass getCollectionType(EClass metaType, EClassifier innerType) {
        if (LIST_TYPE.equals(metaType)) {
            return this.getListType(innerType);
        }
        if (SET_TYPE.equals(metaType)) {
            return this.getSetType(innerType);
        }
        if (COLLECTION_TYPE.equals(metaType)) {
            return this.getCollectionType(innerType);
        }
        throw new IllegalStateException();
    }

    Collection newInstance(EClassifier m1) {
        if (m1.eClass() == LIST_TYPE) {
            return new LinkedList();
        }
        if (m1.eClass() == SET_TYPE) {
            return new HashSet();
        }
        return null;
    }

    public EClass getCollectionType(EClassifier innerType) {
        EClass existing = this.collectionsM1.get(innerType);
        if (existing == null) {
            existing = CollectionTypesSupport.newCollectionType(innerType);
            this.collectionsM1.put(innerType, existing);
        }
        return existing;
    }

    public EClass getListType(EClassifier innerType) {
        EClass existing = this.listsM1.get(innerType);
        if (existing == null) {
            existing = CollectionTypesSupport.newListType(innerType);
            this.listsM1.put(innerType, existing);
        }
        return existing;
    }

    public EClass getSetType(EClassifier innerType) {
        EClass existing = this.setsM1.get(innerType);
        if (existing == null) {
            existing = CollectionTypesSupport.newSetType(innerType);
            this.setsM1.put(innerType, existing);
        }
        return existing;
    }

    private static EClass newCollectionType(EClassifier innerType) {
        EClass c = BuiltinMetaModel.internalNewParameterizedType(COLLECTION_TYPE, innerType);
        c.getESuperTypes().add((Object)EcorePackage.eINSTANCE.getEObject());
        return c;
    }

    private static EClass newListType(EClassifier innerType) {
        EClass c = BuiltinMetaModel.internalNewParameterizedType(LIST_TYPE, innerType);
        c.getESuperTypes().add((Object)COLLECTION_OF_OBJECT);
        return c;
    }

    private static EClass newSetType(EClassifier innerType) {
        EClass c = BuiltinMetaModel.internalNewParameterizedType(SET_TYPE, innerType);
        c.getESuperTypes().add((Object)COLLECTION_OF_OBJECT);
        return c;
    }
}

