/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand;

public class StringHelper {
    public static String escape(String src) {
        String result = src.replace("\\", "\\\\");
        result = result.replace("\t", "\\t");
        result = result.replace("\r", "\\r");
        result = result.replace("\n", "\\n");
        result = result.replace("\"", "\\\"");
        return result;
    }

    public static String unescape(String src) {
        if (src == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < src.length()) {
            char curChar = src.charAt(i);
            if (curChar != '\\') {
                result.append(curChar);
            } else {
                if (++i >= src.length()) {
                    throw new IllegalArgumentException("String ends with '\\'");
                }
                result.append(StringHelper.unescapeChar(src.charAt(i)));
            }
            ++i;
        }
        return result.toString();
    }

    private static char unescapeChar(char escapedChar) {
        switch (escapedChar) {
            case '\\': {
                return '\\';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 't': {
                return '\t';
            }
            case '\"': {
                return '\"';
            }
        }
        throw new IllegalArgumentException("unsupported string format: '\\" + escapedChar + "' is not supported.");
    }

    public static String strip(String s, int numStart, int numEnd) {
        if (s == null) {
            return s;
        }
        return s.substring(numStart, s.length() - numEnd);
    }

    public static String firstUpper(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        char[] arr = str.toCharArray();
        arr[0] = Character.toUpperCase(arr[0]);
        return new String(arr);
    }

    public static String firstLower(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        char[] arr = str.toCharArray();
        arr[0] = Character.toLowerCase(arr[0]);
        return new String(arr);
    }
}

