/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.figures;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.swt.graphics.Color;

public class OneLineBorder
extends LineBorder {
    private int position = 8;

    public OneLineBorder() {
    }

    public OneLineBorder(int width, int position) {
        super(width);
        this.position = position;
    }

    public OneLineBorder(Color color) {
        super(color);
    }

    public OneLineBorder(Color color, int width, int position) {
        super(color, width);
        this.position = position;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public Insets getInsets(IFigure figure) {
        switch (this.position) {
            case 8: {
                return new Insets(this.getWidth(), 0, 0, 0);
            }
            case 1: {
                return new Insets(0, this.getWidth(), 0, 0);
            }
            case 32: {
                return new Insets(0, 0, this.getWidth(), 0);
            }
            case 4: {
                return new Insets(0, 0, 0, this.getWidth());
            }
        }
        return IFigure.NO_INSETS;
    }

    public void paint(IFigure figure, Graphics graphics, Insets insets) {
        tempRect.setBounds(OneLineBorder.getPaintRectangle((IFigure)figure, (Insets)insets));
        if (this.getWidth() % 2 == 1) {
            --OneLineBorder.tempRect.width;
            --OneLineBorder.tempRect.height;
        }
        tempRect.shrink(this.getWidth() / 2, this.getWidth() / 2);
        graphics.setLineWidth(this.getWidth());
        switch (this.position) {
            case 8: {
                graphics.drawLine(tempRect.getTopLeft(), tempRect.getTopRight());
                break;
            }
            case 32: {
                graphics.drawLine(tempRect.getBottomLeft(), tempRect.getBottomRight());
                break;
            }
            case 1: {
                graphics.drawLine(tempRect.getTopLeft(), tempRect.getBottomLeft());
                break;
            }
            case 4: {
                graphics.drawLine(tempRect.getTopRight(), tempRect.getBottomRight());
            }
        }
    }
}

