/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.graphdef.codegen;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.gmfgraph.Canvas;
import org.eclipse.gmf.gmfgraph.Compartment;
import org.eclipse.gmf.gmfgraph.Connection;
import org.eclipse.gmf.gmfgraph.CustomFigure;
import org.eclipse.gmf.gmfgraph.DiagramLabel;
import org.eclipse.gmf.gmfgraph.Figure;
import org.eclipse.gmf.gmfgraph.FigureDescriptor;
import org.eclipse.gmf.gmfgraph.FigureGallery;
import org.eclipse.gmf.gmfgraph.GMFGraphFactory;
import org.eclipse.gmf.gmfgraph.GMFGraphPackage;
import org.eclipse.gmf.gmfgraph.Node;
import org.eclipse.gmf.gmfgraph.RealFigure;
import org.eclipse.gmf.gmfgraph.util.FigureQualifiedNameSwitch;
import org.eclipse.gmf.graphdef.codegen.StandaloneGenerator;
import org.eclipse.gmf.internal.graphdef.codegen.DiagramElementsCopier;
import org.eclipse.gmf.internal.graphdef.codegen.GalleryMirrorProcessor;

public class CanvasProcessor
extends StandaloneGenerator.Processor {
    private final DiagramElementsCopier myElementCopier;
    private StandaloneGenerator.ProcessorCallback myCallback;
    final Canvas myInput;
    private Canvas myOutcome;
    private FigureGallery myOutcomeGallery;

    public CanvasProcessor(Canvas input) {
        assert (input != null);
        this.myInput = input;
        this.myElementCopier = new DiagramElementsCopier();
    }

    public Canvas getOutcome() {
        return this.myOutcome;
    }

    public void go(StandaloneGenerator.ProcessorCallback callback, StandaloneGenerator.Config config) throws InterruptedException {
        this.myCallback = callback;
        this.myOutcomeGallery = GMFGraphFactory.eINSTANCE.createFigureGallery();
        this.myOutcomeGallery.setName(this.myInput.getFigures().size() == 1 ? ((FigureGallery)this.myInput.getFigures().get(0)).getName() : "GeneratedGallery");
        this.myOutcomeGallery.setImplementationBundle(config.getPluginID());
        this.handleNodes();
        this.handleLinks();
        this.handleCompartments();
        this.handleLabels();
        this.myOutcome = GMFGraphFactory.eINSTANCE.createCanvas();
        this.myOutcome.setName(this.myInput.getName());
        this.myOutcome.getFigures().add((Object)this.myOutcomeGallery);
        this.myOutcome.getCompartments().addAll(this.myElementCopier.copyAll((Collection)this.myInput.getCompartments()));
        this.myOutcome.getLabels().addAll(this.myElementCopier.copyAll((Collection)this.myInput.getLabels()));
        this.myOutcome.getNodes().addAll(this.myElementCopier.copyAll((Collection)this.myInput.getNodes()));
        this.myOutcome.getConnections().addAll(this.myElementCopier.copyAll((Collection)this.myInput.getConnections()));
        if (!this.myOutcome.eContents().isEmpty()) {
            this.myElementCopier.copyReferences();
        }
        this.myCallback = null;
    }

    public String[] getRequiredBundles(FigureQualifiedNameSwitch fqnSwitch) {
        HashSet<String> rv = new HashSet<String>();
        for (FigureGallery next : this.myInput.getFigures()) {
            if (next.getImplementationBundle() != null && next.getImplementationBundle().trim().length() > 0) {
                rv.add(next.getImplementationBundle());
            }
            if (fqnSwitch == null) continue;
            rv.addAll((Collection)Arrays.asList(fqnSwitch.getDependencies(next)));
        }
        return rv.toArray(new String[rv.size()]);
    }

    private void handleNodes() throws InterruptedException {
        for (Node next : this.myInput.getNodes()) {
            this.handleFigure(next.getFigure());
        }
    }

    private void handleLinks() throws InterruptedException {
        for (Connection next : this.myInput.getConnections()) {
            this.handleFigure(next.getFigure());
        }
    }

    private void handleCompartments() throws InterruptedException {
        for (Compartment next : this.myInput.getCompartments()) {
            FigureDescriptor nextFigure = next.getFigure();
            if (nextFigure == null) {
                throw new NullPointerException("Compartment without figure : " + next);
            }
            this.handleFigure(nextFigure);
        }
    }

    private void handleLabels() throws InterruptedException {
        for (DiagramLabel next : this.myInput.getLabels()) {
            if (next.getAccessor() != null) {
                next.getAccessor();
                continue;
            }
            this.handleFigure(next.getFigure());
        }
    }

    private void handleFigure(FigureDescriptor fd) throws InterruptedException {
        if (this.myElementCopier.isSubstituted(fd)) {
            return;
        }
        if (fd.getActualFigure() instanceof CustomFigure && CanvasProcessor.isPlainBareCustomFigure((CustomFigure)fd.getActualFigure())) {
            CustomFigure f = (CustomFigure)fd.getActualFigure();
            this.myOutcomeGallery.getFigures().add((Object)((RealFigure)this.myElementCopier.xcopy(f)));
        } else {
            String fqn = this.myCallback.visitFigure(fd);
            this.myElementCopier.registerSubstitution(fd, this.createCustomFigure(fd, fqn));
        }
    }

    private static boolean isPlainBareCustomFigure(CustomFigure figure) {
        if (!figure.getChildren().isEmpty()) {
            return false;
        }
        LinkedList featuresToCheck = new LinkedList(figure.eClass().getEAllStructuralFeatures());
        featuresToCheck.remove(GMFGraphPackage.eINSTANCE.getRealFigure_Name());
        featuresToCheck.remove(GMFGraphPackage.eINSTANCE.getRealFigure_Children());
        featuresToCheck.remove(GMFGraphPackage.eINSTANCE.getCustomClass_QualifiedClassName());
        featuresToCheck.remove(GMFGraphPackage.eINSTANCE.getCustomFigure_CustomChildren());
        for (EStructuralFeature next : featuresToCheck) {
            if (next.isDerived() || !figure.eIsSet(next)) continue;
            return false;
        }
        return true;
    }

    private FigureDescriptor createCustomFigure(FigureDescriptor original, String fqn) {
        CustomFigure cf = GalleryMirrorProcessor.createCustomFigure(original.getActualFigure());
        cf.setQualifiedClassName(fqn);
        FigureDescriptor fd = GMFGraphFactory.eINSTANCE.createFigureDescriptor();
        fd.setName(original.getName());
        fd.setActualFigure((Figure)cf);
        this.myOutcomeGallery.getDescriptors().add((Object)fd);
        return fd;
    }
}

