/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.graphdef.editor.edit.parts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.tools.AbstractTool;
import org.eclipse.gmf.gmfgraph.Alignment;
import org.eclipse.gmf.gmfgraph.BorderLayout;
import org.eclipse.gmf.gmfgraph.BorderLayoutData;
import org.eclipse.gmf.gmfgraph.FlowLayout;
import org.eclipse.gmf.gmfgraph.GridLayout;
import org.eclipse.gmf.gmfgraph.Layout;
import org.eclipse.gmf.gmfgraph.LayoutData;
import org.eclipse.gmf.gmfgraph.Layoutable;
import org.eclipse.gmf.gmfgraph.LineKind;
import org.eclipse.gmf.gmfgraph.RealFigure;
import org.eclipse.gmf.gmfgraph.XYLayoutData;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ConnectionHandleEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.handles.ConnectionHandle;
import org.eclipse.gmf.runtime.notation.View;

public abstract class AbstractFigureEditPart
extends ShapeNodeEditPart {
    public static final String EMPTY_STRING = "";

    public AbstractFigureEditPart(View view) {
        super(view);
    }

    public Object getLayoutConstraint() {
        Layoutable layoutable = (Layoutable)((View)this.getModel()).getElement();
        if (layoutable == null || layoutable.getLayoutData() == null) {
            return null;
        }
        LayoutData layoutData = layoutable.getLayoutData();
        switch (layoutData.eClass().getClassifierID()) {
            case 57: {
                BorderLayoutData borderLayoutData = (BorderLayoutData)layoutData;
                if (borderLayoutData.getAlignment() == null) break;
                switch (borderLayoutData.getAlignment().getValue()) {
                    case 1: 
                    case 3: {
                        return org.eclipse.draw2d.BorderLayout.CENTER;
                    }
                    case 0: {
                        return borderLayoutData.isVertical() ? org.eclipse.draw2d.BorderLayout.TOP : org.eclipse.draw2d.BorderLayout.LEFT;
                    }
                    case 2: {
                        return borderLayoutData.isVertical() ? org.eclipse.draw2d.BorderLayout.BOTTOM : org.eclipse.draw2d.BorderLayout.RIGHT;
                    }
                }
                break;
            }
            case 55: {
                break;
            }
            case 56: {
                break;
            }
            case 65: {
                XYLayoutData xyLayoutData = (XYLayoutData)layoutData;
                Rectangle result = new Rectangle();
                if (xyLayoutData.getTopLeft() != null) {
                    result.setLocation(this.getMapMode().DPtoLP(xyLayoutData.getTopLeft().getX()), this.getMapMode().DPtoLP(xyLayoutData.getTopLeft().getY()));
                }
                if (xyLayoutData.getSize() != null) {
                    result.setSize(this.getMapMode().DPtoLP(xyLayoutData.getSize().getDx()), this.getMapMode().DPtoLP(xyLayoutData.getSize().getDy()));
                }
                return result;
            }
        }
        return null;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        LayoutManager layoutManager;
        IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
        Object layoutConstraint = null;
        if (childEditPart instanceof AbstractFigureEditPart) {
            layoutConstraint = ((AbstractFigureEditPart)childEditPart).getLayoutConstraint();
        }
        if ((layoutManager = this.getContentPane().getLayoutManager()) instanceof org.eclipse.draw2d.BorderLayout) {
            if (org.eclipse.draw2d.BorderLayout.BOTTOM != layoutConstraint && org.eclipse.draw2d.BorderLayout.CENTER != layoutConstraint && org.eclipse.draw2d.BorderLayout.LEFT != layoutConstraint && org.eclipse.draw2d.BorderLayout.RIGHT != layoutConstraint && org.eclipse.draw2d.BorderLayout.TOP != layoutConstraint) {
                layoutConstraint = null;
            }
        } else if (!(layoutManager instanceof GridLayout) && layoutManager instanceof XYLayout && !(layoutConstraint instanceof Rectangle)) {
            layoutConstraint = null;
        }
        this.getContentPane().add(child, layoutConstraint, index);
    }

    protected void layoutDataChanged(LayoutData layoutData) {
        if (this.isFigureRefreshAllowed()) {
            this.handleMajorSemanticChange();
        }
    }

    protected void layoutChanged(Layout layout) {
        if (layout == null) {
            this.setFigureLayoutManager(null);
            return;
        }
        switch (layout.eClass().getClassifierID()) {
            case 62: {
                org.eclipse.draw2d.BorderLayout layoutManager;
                BorderLayout borderLayout = (BorderLayout)layout;
                if (this.getFigureLayoutManager() instanceof org.eclipse.draw2d.BorderLayout) {
                    layoutManager = (org.eclipse.draw2d.BorderLayout)this.getFigureLayoutManager();
                } else {
                    layoutManager = new org.eclipse.draw2d.BorderLayout();
                    this.setFigureLayoutManager((LayoutManager)layoutManager);
                }
                if (borderLayout.getSpacing() == null) break;
                layoutManager.setHorizontalSpacing(this.getMapMode().DPtoLP(borderLayout.getSpacing().getDx()));
                layoutManager.setVerticalSpacing(this.getMapMode().DPtoLP(borderLayout.getSpacing().getDy()));
                break;
            }
            case 60: {
                break;
            }
            case 63: {
                org.eclipse.draw2d.FlowLayout layoutManager;
                FlowLayout flowLayout = (FlowLayout)layout;
                if (flowLayout.isForceSingleLine()) {
                    ToolbarLayout layoutManager2;
                    if (this.getFigureLayoutManager() instanceof ToolbarLayout) {
                        layoutManager2 = (ToolbarLayout)this.getFigureLayoutManager();
                    } else {
                        layoutManager2 = new ToolbarLayout();
                        this.setFigureLayoutManager((LayoutManager)layoutManager2);
                    }
                    layoutManager2.setStretchMinorAxis(flowLayout.isMatchMinorSize());
                    layoutManager2.setMinorAlignment(this.getDraw2dAllignment(flowLayout.getMinorAlignment(), flowLayout.isForceSingleLine()));
                    layoutManager2.setSpacing(flowLayout.getMajorSpacing());
                    layoutManager2.setVertical(flowLayout.isVertical());
                    break;
                }
                if (this.getFigureLayoutManager() instanceof org.eclipse.draw2d.FlowLayout) {
                    layoutManager = (org.eclipse.draw2d.FlowLayout)this.getFigureLayoutManager();
                } else {
                    layoutManager = new org.eclipse.draw2d.FlowLayout();
                    this.setFigureLayoutManager((LayoutManager)layoutManager);
                }
                layoutManager.setStretchMinorAxis(flowLayout.isMatchMinorSize());
                layoutManager.setMinorAlignment(this.getDraw2dAllignment(flowLayout.getMinorAlignment(), flowLayout.isForceSingleLine()));
                layoutManager.setMajorAlignment(this.getDraw2dAllignment(flowLayout.getMajorAlignment(), flowLayout.isForceSingleLine()));
                layoutManager.setMajorSpacing(flowLayout.getMajorSpacing());
                layoutManager.setMinorSpacing(flowLayout.getMinorSpacing());
                layoutManager.setHorizontal(!flowLayout.isVertical());
                break;
            }
            case 61: {
                break;
            }
            case 66: {
                if (this.getFigureLayoutManager() instanceof StackLayout) break;
                this.setFigureLayoutManager((LayoutManager)new StackLayout());
                break;
            }
            case 64: {
                if (this.getFigureLayoutManager() instanceof XYLayout) break;
                this.setFigureLayoutManager((LayoutManager)new XYLayout());
            }
        }
        if (this.isFigureRefreshAllowed()) {
            this.handleMajorSemanticChange();
        }
    }

    private boolean isFigureRefreshAllowed() {
        return this.figure != null;
    }

    protected abstract LayoutManager getFigureLayoutManager();

    protected abstract void setFigureLayoutManager(LayoutManager var1);

    private int getDraw2dAllignment(Alignment alignment, boolean isToolbar) {
        switch (alignment.getValue()) {
            case 0: {
                return isToolbar ? 1 : 1;
            }
            case 2: {
                return isToolbar ? 2 : 2;
            }
        }
        return isToolbar ? 0 : 0;
    }

    protected int getLineStyle(LineKind lineKind) {
        switch (lineKind.getValue()) {
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
        }
        return 1;
    }

    protected PointList getPointList(Collection template) {
        PointList result = new PointList();
        for (org.eclipse.gmf.gmfgraph.Point nextPoint : template) {
            result.addPoint(new Point(this.getMapMode().DPtoLP(nextPoint.getX()), this.getMapMode().DPtoLP(nextPoint.getY())));
        }
        return result;
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("ConnectionHandlesPolicy", (EditPolicy)new MyConnectionHandleEditPolicy());
    }

    private static class MyConnectionHandle
    extends ConnectionHandle {
        private final MyHandleTool myTool;

        public MyConnectionHandle(IGraphicalEditPart ownerEditPart, EditPart nextChild, String tooltip) {
            super(ownerEditPart, ConnectionHandle.HandleDirection.INCOMING, tooltip);
            this.myTool = new MyHandleTool(nextChild, tooltip);
        }

        protected DragTracker createDragTracker() {
            return this.myTool;
        }
    }

    private static class MyConnectionHandleEditPolicy
    extends ConnectionHandleEditPolicy {
        private MyConnectionHandleEditPolicy() {
        }

        protected List getHandleFigures() {
            IGraphicalEditPart selectedPart = (IGraphicalEditPart)this.getHost();
            ArrayList<MyConnectionHandle> result = new ArrayList<MyConnectionHandle>(selectedPart.getChildren().size());
            int i = 0;
            while (i < selectedPart.getChildren().size()) {
                EditPart next = (EditPart)selectedPart.getChildren().get(i);
                String tooltip = AbstractFigureEditPart.EMPTY_STRING;
                if (next instanceof AbstractFigureEditPart) {
                    AbstractFigureEditPart nextAF = (AbstractFigureEditPart)next;
                    View model = (View)nextAF.getModel();
                    RealFigure modelElement = (RealFigure)model.getElement();
                    String name = modelElement.getName();
                    tooltip = String.valueOf(modelElement.eClass().getName()) + ":" + (name != null && name.length() != 0 ? name : String.valueOf(i + 1));
                }
                result.add(new MyConnectionHandle(selectedPart, next, tooltip));
                ++i;
            }
            return result;
        }
    }

    private static class MyHandleTool
    extends AbstractTool
    implements DragTracker {
        private final EditPart myTarget;
        private final String myCommandName;

        public MyHandleTool(EditPart target, String commandName) {
            this.myTarget = target;
            this.myCommandName = commandName;
        }

        protected boolean handleButtonUp(int button) {
            this.myTarget.getViewer().select(this.myTarget);
            return true;
        }

        protected String getCommandName() {
            return this.myCommandName;
        }
    }
}

