/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.graphdef.editor.edit.parts;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.gmfgraph.Alignment;
import org.eclipse.gmf.gmfgraph.BorderLayout;
import org.eclipse.gmf.gmfgraph.BorderLayoutData;
import org.eclipse.gmf.gmfgraph.FlowLayout;
import org.eclipse.gmf.gmfgraph.GridLayout;
import org.eclipse.gmf.gmfgraph.Layout;
import org.eclipse.gmf.gmfgraph.LayoutData;
import org.eclipse.gmf.gmfgraph.Layoutable;
import org.eclipse.gmf.gmfgraph.LineKind;
import org.eclipse.gmf.gmfgraph.XYLayoutData;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.notation.View;

public abstract class AbstractFigureEditPart
extends ShapeNodeEditPart {
    public AbstractFigureEditPart(View view) {
        super(view);
    }

    public Object getLayoutConstraint() {
        Layoutable layoutable = (Layoutable)((View)this.getModel()).getElement();
        if (layoutable == null || layoutable.getLayoutData() == null) {
            return null;
        }
        LayoutData layoutData = layoutable.getLayoutData();
        switch (layoutData.eClass().getClassifierID()) {
            case 52: {
                BorderLayoutData borderLayoutData = (BorderLayoutData)layoutData;
                if (borderLayoutData.getAlignment() == null) break;
                switch (borderLayoutData.getAlignment().getValue()) {
                    case 1: 
                    case 3: {
                        return org.eclipse.draw2d.BorderLayout.CENTER;
                    }
                    case 0: {
                        return borderLayoutData.isVertical() ? org.eclipse.draw2d.BorderLayout.TOP : org.eclipse.draw2d.BorderLayout.LEFT;
                    }
                    case 2: {
                        return borderLayoutData.isVertical() ? org.eclipse.draw2d.BorderLayout.BOTTOM : org.eclipse.draw2d.BorderLayout.RIGHT;
                    }
                }
                break;
            }
            case 50: {
                break;
            }
            case 51: {
                break;
            }
            case 60: {
                XYLayoutData xyLayoutData = (XYLayoutData)layoutData;
                Rectangle result = new Rectangle();
                if (xyLayoutData.getTopLeft() != null) {
                    result.setLocation(this.getMapMode().DPtoLP(xyLayoutData.getTopLeft().getX()), this.getMapMode().DPtoLP(xyLayoutData.getTopLeft().getY()));
                }
                if (xyLayoutData.getSize() != null) {
                    result.setSize(this.getMapMode().DPtoLP(xyLayoutData.getSize().getDx()), this.getMapMode().DPtoLP(xyLayoutData.getSize().getDy()));
                }
                return result;
            }
        }
        return null;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        LayoutManager layoutManager;
        IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
        Object layoutConstraint = null;
        if (childEditPart instanceof AbstractFigureEditPart) {
            layoutConstraint = ((AbstractFigureEditPart)childEditPart).getLayoutConstraint();
        }
        if ((layoutManager = this.getContentPane().getLayoutManager()) instanceof org.eclipse.draw2d.BorderLayout) {
            if (org.eclipse.draw2d.BorderLayout.BOTTOM != layoutConstraint && org.eclipse.draw2d.BorderLayout.CENTER != layoutConstraint && org.eclipse.draw2d.BorderLayout.LEFT != layoutConstraint && org.eclipse.draw2d.BorderLayout.RIGHT != layoutConstraint && org.eclipse.draw2d.BorderLayout.TOP != layoutConstraint) {
                layoutConstraint = null;
            }
        } else if (!(layoutManager instanceof GridLayout) && layoutManager instanceof XYLayout && !(layoutConstraint instanceof Rectangle)) {
            layoutConstraint = null;
        }
        this.getContentPane().add(child, layoutConstraint, index);
    }

    protected void layoutDataChanged(LayoutData layoutData) {
        if (this.isFigureRefreshAllowed()) {
            this.handleMajorSemanticChange();
        }
    }

    protected void layoutChanged(Layout layout) {
        if (layout == null) {
            this.setFigureLayoutManager(null);
            return;
        }
        switch (layout.eClass().getClassifierID()) {
            case 57: {
                org.eclipse.draw2d.BorderLayout layoutManager;
                BorderLayout borderLayout = (BorderLayout)layout;
                if (this.getFigureLayoutManager() instanceof org.eclipse.draw2d.BorderLayout) {
                    layoutManager = (org.eclipse.draw2d.BorderLayout)this.getFigureLayoutManager();
                } else {
                    layoutManager = new org.eclipse.draw2d.BorderLayout();
                    this.setFigureLayoutManager((LayoutManager)layoutManager);
                }
                if (borderLayout.getSpacing() == null) break;
                layoutManager.setHorizontalSpacing(this.getMapMode().DPtoLP(borderLayout.getSpacing().getDx()));
                layoutManager.setVerticalSpacing(this.getMapMode().DPtoLP(borderLayout.getSpacing().getDy()));
                break;
            }
            case 55: {
                break;
            }
            case 58: {
                org.eclipse.draw2d.FlowLayout layoutManager;
                FlowLayout flowLayout = (FlowLayout)layout;
                if (flowLayout.isForceSingleLine()) {
                    ToolbarLayout layoutManager2;
                    if (this.getFigureLayoutManager() instanceof ToolbarLayout) {
                        layoutManager2 = (ToolbarLayout)this.getFigureLayoutManager();
                    } else {
                        layoutManager2 = new ToolbarLayout();
                        this.setFigureLayoutManager((LayoutManager)layoutManager2);
                    }
                    layoutManager2.setStretchMinorAxis(flowLayout.isMatchMinorSize());
                    layoutManager2.setMinorAlignment(this.getDraw2dAllignment(flowLayout.getMinorAlignment(), flowLayout.isForceSingleLine()));
                    layoutManager2.setSpacing(flowLayout.getMajorSpacing());
                    layoutManager2.setVertical(flowLayout.isVertical());
                    break;
                }
                if (this.getFigureLayoutManager() instanceof org.eclipse.draw2d.FlowLayout) {
                    layoutManager = (org.eclipse.draw2d.FlowLayout)this.getFigureLayoutManager();
                } else {
                    layoutManager = new org.eclipse.draw2d.FlowLayout();
                    this.setFigureLayoutManager((LayoutManager)layoutManager);
                }
                layoutManager.setStretchMinorAxis(flowLayout.isMatchMinorSize());
                layoutManager.setMinorAlignment(this.getDraw2dAllignment(flowLayout.getMinorAlignment(), flowLayout.isForceSingleLine()));
                layoutManager.setMajorAlignment(this.getDraw2dAllignment(flowLayout.getMajorAlignment(), flowLayout.isForceSingleLine()));
                layoutManager.setMajorSpacing(flowLayout.getMajorSpacing());
                layoutManager.setMinorSpacing(flowLayout.getMinorSpacing());
                layoutManager.setHorizontal(!flowLayout.isVertical());
                break;
            }
            case 56: {
                break;
            }
            case 61: {
                if (this.getFigureLayoutManager() instanceof StackLayout) break;
                this.setFigureLayoutManager((LayoutManager)new StackLayout());
                break;
            }
            case 59: {
                if (this.getFigureLayoutManager() instanceof XYLayout) break;
                this.setFigureLayoutManager((LayoutManager)new XYLayout());
            }
        }
        if (this.isFigureRefreshAllowed()) {
            this.handleMajorSemanticChange();
        }
    }

    private boolean isFigureRefreshAllowed() {
        return this.figure != null;
    }

    protected abstract LayoutManager getFigureLayoutManager();

    protected abstract void setFigureLayoutManager(LayoutManager var1);

    private int getDraw2dAllignment(Alignment alignment, boolean isToolbar) {
        switch (alignment.getValue()) {
            case 0: {
                return isToolbar ? 1 : 1;
            }
            case 2: {
                return isToolbar ? 2 : 2;
            }
        }
        return isToolbar ? 0 : 0;
    }

    protected int getLineStyle(LineKind lineKind) {
        switch (lineKind.getValue()) {
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
        }
        return 1;
    }

    protected PointList getPointList(Collection template) {
        PointList result = new PointList();
        Iterator it = template.iterator();
        while (it.hasNext()) {
            org.eclipse.gmf.gmfgraph.Point nextPoint = (org.eclipse.gmf.gmfgraph.Point)it.next();
            result.addPoint(new Point(this.getMapMode().DPtoLP(nextPoint.getX()), this.getMapMode().DPtoLP(nextPoint.getY())));
        }
        return result;
    }
}

