/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.expression.ast;

import java.util.Set;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.gmf.internal.xpand.eval.EvaluationListener;
import org.eclipse.gmf.internal.xpand.expression.AnalysationIssue;
import org.eclipse.gmf.internal.xpand.expression.Analyzable;
import org.eclipse.gmf.internal.xpand.expression.Evaluatable;
import org.eclipse.gmf.internal.xpand.expression.EvaluationException;
import org.eclipse.gmf.internal.xpand.expression.ExecutionContext;
import org.eclipse.gmf.internal.xpand.expression.ast.Identifier;
import org.eclipse.gmf.internal.xpand.expression.ast.SyntaxElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Expression
extends SyntaxElement
implements Analyzable,
Evaluatable {
    public Expression(int start, int end, int line) {
        super(start, end, line);
    }

    protected EClassifier findType(Identifier type, ExecutionContext ctx, Set<AnalysationIssue> issues) {
        EClassifier toCast = ctx.getTypeForName(type.getValue());
        if (toCast == null) {
            issues.add(new AnalysationIssue(AnalysationIssue.Type.TYPE_NOT_FOUND, type.getValue(), type));
        }
        return toCast;
    }

    @Override
    public final Object evaluate(ExecutionContext ctx) {
        try {
            this.notifyEnter(ctx);
            Object object = this.evaluateInternal(ctx);
            return object;
        }
        catch (EvaluationException eve) {
            throw eve;
        }
        catch (RuntimeException ex) {
            throw new EvaluationException(ex, (SyntaxElement)this);
        }
        finally {
            this.notifyLeave(ctx);
        }
    }

    protected abstract Object evaluateInternal(ExecutionContext var1);

    private void notifyEnter(ExecutionContext ctx) {
        EvaluationListener l = ctx.getEvaluationListener();
        if (l != null) {
            l.enter(this, ctx);
        }
    }

    private void notifyLeave(ExecutionContext ctx) {
        EvaluationListener l = ctx.getEvaluationListener();
        if (l != null) {
            l.leave(this, ctx);
        }
    }
}

