/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.migration;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.gmf.internal.xpand.ast.AbstractDefinition;
import org.eclipse.gmf.internal.xpand.ast.ErrorStatement;
import org.eclipse.gmf.internal.xpand.ast.ExpandStatement;
import org.eclipse.gmf.internal.xpand.ast.ExpressionStatement;
import org.eclipse.gmf.internal.xpand.ast.FileStatement;
import org.eclipse.gmf.internal.xpand.ast.ForEachStatement;
import org.eclipse.gmf.internal.xpand.ast.IfStatement;
import org.eclipse.gmf.internal.xpand.ast.LetStatement;
import org.eclipse.gmf.internal.xpand.ast.Statement;
import org.eclipse.gmf.internal.xpand.expression.ast.BooleanOperation;
import org.eclipse.gmf.internal.xpand.expression.ast.Case;
import org.eclipse.gmf.internal.xpand.expression.ast.Cast;
import org.eclipse.gmf.internal.xpand.expression.ast.ChainExpression;
import org.eclipse.gmf.internal.xpand.expression.ast.CollectionExpression;
import org.eclipse.gmf.internal.xpand.expression.ast.DeclaredParameter;
import org.eclipse.gmf.internal.xpand.expression.ast.Expression;
import org.eclipse.gmf.internal.xpand.expression.ast.FeatureCall;
import org.eclipse.gmf.internal.xpand.expression.ast.IfExpression;
import org.eclipse.gmf.internal.xpand.expression.ast.LetExpression;
import org.eclipse.gmf.internal.xpand.expression.ast.ListLiteral;
import org.eclipse.gmf.internal.xpand.expression.ast.OperationCall;
import org.eclipse.gmf.internal.xpand.expression.ast.SwitchExpression;
import org.eclipse.gmf.internal.xpand.expression.ast.SyntaxElement;
import org.eclipse.gmf.internal.xpand.expression.ast.TypeSelectExpression;
import org.eclipse.gmf.internal.xpand.xtend.ast.ExpressionExtensionStatement;
import org.eclipse.gmf.internal.xpand.xtend.ast.Extension;

public class VariableNameDispatcher {
    private static final String ITERATOR_PREFIX = "it";
    private static final String VARIABLE_PREFIX = "tmpVar";
    private Set<String> definedVariables = new HashSet<String>();

    public VariableNameDispatcher() {
    }

    public VariableNameDispatcher(Extension extension) {
        this.initDefinedVariables(extension);
    }

    public VariableNameDispatcher(AbstractDefinition definition) {
        this.initDefinedVariables(definition);
    }

    private void initDefinedVariables(AbstractDefinition definition) {
        SyntaxElement[] syntaxElementArray = definition.getParams();
        int n = syntaxElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            DeclaredParameter parameter = syntaxElementArray[n2];
            this.definedVariables.add(parameter.getName().getValue());
            ++n2;
        }
        syntaxElementArray = definition.getBody();
        n = syntaxElementArray.length;
        n2 = 0;
        while (n2 < n) {
            SyntaxElement statement = syntaxElementArray[n2];
            this.initDefinedVariables((Statement)statement);
            ++n2;
        }
    }

    private void initDefinedVariables(Statement statement) {
        block10: {
            block15: {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                block9: {
                                    if (!(statement instanceof ExpressionStatement)) break block9;
                                    ExpressionStatement expressionStatement = (ExpressionStatement)statement;
                                    this.initDefinedVariables(expressionStatement.getExpression());
                                    break block10;
                                }
                                if (!(statement instanceof ErrorStatement)) break block11;
                                ErrorStatement errorStatement = (ErrorStatement)statement;
                                this.initDefinedVariables(errorStatement.getMessage());
                                break block10;
                            }
                            if (!(statement instanceof ExpandStatement)) break block12;
                            ExpandStatement expandStatement = (ExpandStatement)statement;
                            Expression[] expressionArray = expandStatement.getParameters();
                            int n = expressionArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Expression parameter = expressionArray[n2];
                                this.initDefinedVariables(parameter);
                                ++n2;
                            }
                            if (expandStatement.getTarget() != null) {
                                this.initDefinedVariables(expandStatement.getTarget());
                            }
                            if (expandStatement.getSeparator() == null) break block10;
                            this.initDefinedVariables(expandStatement.getSeparator());
                            break block10;
                        }
                        if (!(statement instanceof FileStatement)) break block13;
                        FileStatement fileStatement = (FileStatement)statement;
                        this.initDefinedVariables(fileStatement.getTargetFileName());
                        Statement[] statementArray = fileStatement.getBody();
                        int n = statementArray.length;
                        int n3 = 0;
                        while (n3 < n) {
                            Statement bodyStatement = statementArray[n3];
                            this.initDefinedVariables(bodyStatement);
                            ++n3;
                        }
                        break block10;
                    }
                    if (!(statement instanceof ForEachStatement)) break block14;
                    ForEachStatement forEach = (ForEachStatement)statement;
                    this.initDefinedVariables(forEach.getTarget());
                    if (forEach.getSeparator() != null) {
                        this.initDefinedVariables(forEach.getSeparator());
                    }
                    Statement[] statementArray = forEach.getBody();
                    int n = statementArray.length;
                    int n4 = 0;
                    while (n4 < n) {
                        Statement bodyStatement = statementArray[n4];
                        this.initDefinedVariables(bodyStatement);
                        ++n4;
                    }
                    break block10;
                }
                if (!(statement instanceof IfStatement)) break block15;
                IfStatement ifStatement = (IfStatement)statement;
                if (ifStatement.getCondition() != null) {
                    this.initDefinedVariables(ifStatement.getCondition());
                }
                Statement[] statementArray = ifStatement.getThenPart();
                int n = statementArray.length;
                int n5 = 0;
                while (n5 < n) {
                    Statement thenStatement = statementArray[n5];
                    this.initDefinedVariables(thenStatement);
                    ++n5;
                }
                if (ifStatement.getElseIf() == null) break block10;
                this.initDefinedVariables(ifStatement.getElseIf());
                break block10;
            }
            if (statement instanceof LetStatement) {
                LetStatement letStatement = (LetStatement)statement;
                this.initDefinedVariables(letStatement.getVarValue());
                Statement[] statementArray = letStatement.getBody();
                int n = statementArray.length;
                int n6 = 0;
                while (n6 < n) {
                    Statement bodyStatement = statementArray[n6];
                    this.initDefinedVariables(bodyStatement);
                    ++n6;
                }
            }
        }
    }

    private void initDefinedVariables(Extension extension) {
        for (String parameterName : extension.getParameterNames()) {
            this.definedVariables.add(parameterName);
        }
        if (extension instanceof ExpressionExtensionStatement) {
            this.initDefinedVariables(((ExpressionExtensionStatement)extension).getExpression());
        }
    }

    private void initDefinedVariables(Expression expression) {
        block4: {
            block13: {
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                block8: {
                                    block7: {
                                        block6: {
                                            block5: {
                                                block3: {
                                                    if (!(expression instanceof BooleanOperation)) break block3;
                                                    BooleanOperation booleanOperation = (BooleanOperation)expression;
                                                    this.initDefinedVariables(booleanOperation.getLeft());
                                                    this.initDefinedVariables(booleanOperation.getRight());
                                                    break block4;
                                                }
                                                if (!(expression instanceof Cast)) break block5;
                                                Cast cast = (Cast)expression;
                                                this.initDefinedVariables(cast.getTarget());
                                                break block4;
                                            }
                                            if (!(expression instanceof ChainExpression)) break block6;
                                            ChainExpression chainExpression = (ChainExpression)expression;
                                            this.initDefinedVariables(chainExpression.getFirst());
                                            this.initDefinedVariables(chainExpression.getNext());
                                            break block4;
                                        }
                                        if (!(expression instanceof CollectionExpression)) break block7;
                                        CollectionExpression collectionExpression = (CollectionExpression)expression;
                                        this.initDefinedVariables(collectionExpression.getClosure());
                                        this.initDefinedVariablesOfTarget(collectionExpression);
                                        this.definedVariables.add(collectionExpression.getElementName());
                                        break block4;
                                    }
                                    if (!(expression instanceof OperationCall)) break block8;
                                    OperationCall operationCall = (OperationCall)expression;
                                    this.initDefinedVariablesOfTarget(operationCall);
                                    int i = 0;
                                    while (i < operationCall.getParams().length) {
                                        this.initDefinedVariables(operationCall.getParams()[i]);
                                        ++i;
                                    }
                                    break block4;
                                }
                                if (!(expression instanceof TypeSelectExpression)) break block9;
                                TypeSelectExpression typeSelect = (TypeSelectExpression)expression;
                                this.initDefinedVariablesOfTarget(typeSelect);
                                break block4;
                            }
                            if (!(expression instanceof FeatureCall)) break block10;
                            FeatureCall featureCall = (FeatureCall)expression;
                            this.initDefinedVariablesOfTarget(featureCall);
                            break block4;
                        }
                        if (!(expression instanceof IfExpression)) break block11;
                        IfExpression ifExpression = (IfExpression)expression;
                        this.initDefinedVariables(ifExpression.getCondition());
                        this.initDefinedVariables(ifExpression.getThenPart());
                        this.initDefinedVariables(ifExpression.getElsePart());
                        break block4;
                    }
                    if (!(expression instanceof LetExpression)) break block12;
                    LetExpression letExpression = (LetExpression)expression;
                    this.initDefinedVariables(letExpression.getVarExpression());
                    this.initDefinedVariables(letExpression.getTargetExpression());
                    this.definedVariables.add(letExpression.getVarName().getValue());
                    break block4;
                }
                if (!(expression instanceof ListLiteral)) break block13;
                ListLiteral listLiteral = (ListLiteral)expression;
                int i = 0;
                while (i < listLiteral.getElements().length) {
                    this.initDefinedVariables(listLiteral.getElements()[i]);
                    ++i;
                }
                break block4;
            }
            if (!(expression instanceof SwitchExpression)) break block4;
            SwitchExpression switchExpression = (SwitchExpression)expression;
            this.initDefinedVariables(switchExpression.getSwitchExpr());
            this.initDefinedVariables(switchExpression.getDefaultExpr());
            for (Case caseExpresion : switchExpression.getCases()) {
                this.initDefinedVariables(caseExpresion.getCondition());
                this.initDefinedVariables(caseExpresion.getThenPart());
            }
        }
    }

    private void initDefinedVariablesOfTarget(FeatureCall featrueCall) {
        if (featrueCall.getTarget() != null) {
            this.initDefinedVariables(featrueCall.getTarget());
        }
    }

    public String getNextIteratorName() {
        return this.getUniqueName(ITERATOR_PREFIX);
    }

    public String getNextVariableName() {
        return this.getUniqueName(VARIABLE_PREFIX);
    }

    private String getUniqueName(String prefix) {
        String iteratorName = prefix;
        int i = 1;
        while (this.definedVariables.contains(iteratorName)) {
            iteratorName = String.valueOf(prefix) + "_" + i;
            ++i;
        }
        this.definedVariables.add(iteratorName);
        return iteratorName;
    }
}

