/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.gmf.internal.xpand.build.WorkspaceResourceManager;
import org.eclipse.gmf.internal.xpand.migration.Activator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootManager {
    public static final IPath PROJECT_RELATIVE_PATH_TO_CONFIG_FILE = new Path(".xpand-root");
    private final IFile myConfig;
    private List<RootDescription> myRoots;
    private List<IRootChangeListener> myListeners = new ArrayList<IRootChangeListener>(2);
    private RootDescription myFallbackRoot;
    private IProject myProject;
    private static final List<IPath> DEFAULT_ROOTS = Collections.singletonList(new Path("templates"));

    public RootManager(IProject project) {
        this.myConfig = project.getFile(PROJECT_RELATIVE_PATH_TO_CONFIG_FILE);
        this.myProject = project;
    }

    public void addRootChangeListener(IRootChangeListener l) {
        if (l != null && !this.myListeners.contains(l)) {
            this.myListeners.add(l);
        }
    }

    public void removeRootChangeListener(IRootChangeListener l) {
        this.myListeners.remove(l);
    }

    public void rootsChanged() {
        this.myRoots = null;
        for (IRootChangeListener next : this.myListeners) {
            next.rootsChanged(this);
        }
    }

    protected IProject getProject() {
        return this.myConfig.getProject();
    }

    public boolean isTemplateRoot(IContainer container) {
        for (RootDescription nextDescription : this.getRoots()) {
            if (!nextDescription.contains((IResource)container) || !nextDescription.getRelativePath((IResource)container).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public List<IFolder> getXpandRootFolders() {
        ArrayList<IFolder> rootFolders = new ArrayList<IFolder>();
        for (RootDescription rootDescription : this.getRoots()) {
            IPath mainIPath = rootDescription.getMainIPath();
            if (mainIPath == null) continue;
            IFolder rootFolder = null;
            if (mainIPath.isAbsolute()) {
                assert (mainIPath.segmentCount() > 1);
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(mainIPath.segment(0));
                if (project.isAccessible() && project.equals((Object)this.myProject)) {
                    rootFolder = this.myProject.getFolder(mainIPath.removeFirstSegments(1));
                }
            } else {
                rootFolder = this.myProject.getFolder(mainIPath);
            }
            if (rootFolder == null || !rootFolder.exists()) continue;
            rootFolders.add(rootFolder);
        }
        return rootFolders;
    }

    public String getTemplateFullName(IFile file) {
        IPath relativePath = null;
        Iterator<RootDescription> it = this.getRoots().iterator();
        while (it.hasNext() && relativePath == null) {
            RootDescription nextDescription = it.next();
            if (!nextDescription.contains((IResource)file)) continue;
            relativePath = nextDescription.getRelativePath((IResource)file);
        }
        if (relativePath == null) {
            relativePath = this.getFallbackRoot().getRelativePath((IResource)file);
        }
        if (relativePath == null) {
            return null;
        }
        String templateFullName = (relativePath = relativePath.removeFileExtension()).toString();
        if (templateFullName.startsWith("/")) {
            templateFullName = templateFullName.substring(1);
        }
        if (templateFullName.endsWith("/")) {
            templateFullName = templateFullName.substring(0, templateFullName.length() - 1);
        }
        return templateFullName.replace("/", "::");
    }

    public WorkspaceResourceManager getResourceManager(IFile file) {
        for (RootDescription nextDescription : this.getRoots()) {
            if (!nextDescription.contains((IResource)file)) continue;
            return nextDescription.getManager();
        }
        return this.getFallbackRoot().getManager();
    }

    private RootDescription getFallbackRoot() {
        if (this.myFallbackRoot == null) {
            this.myFallbackRoot = new RootDescription(Collections.singletonList(new Path("")));
        }
        return this.myFallbackRoot;
    }

    private List<RootDescription> getRoots() {
        if (this.myRoots == null) {
            this.reloadRoots();
        }
        return this.myRoots;
    }

    /*
     * Unable to fully structure code
     */
    private void reloadRoots() {
        block21: {
            if (!this.myConfig.exists()) {
                this.myRoots = Collections.singletonList(new RootDescription(RootManager.DEFAULT_ROOTS));
                return;
            }
            read = new ArrayList<RootDescription>();
            in = null;
            try {
                in = new BufferedReader(new InputStreamReader(this.myConfig.getContents(), this.myConfig.getCharset()));
                while ((line = in.readLine()) != null) {
                    if ((line = line.trim()).length() <= 0 || line.charAt(0) == '#') continue;
                    split = line.split(",");
                    nextPaths = new ArrayList<IPath>(split.length);
                    var9_9 = split;
                    var8_8 = split.length;
                    var7_7 = 0;
                    while (var7_7 < var8_8) {
                        nextPath = var9_9[var7_7];
                        if (!((nextPath = nextPath.trim()).length() <= 0 || (toAdd = new Path(nextPath)).isAbsolute() && toAdd.segmentCount() < 2)) {
                            nextPaths.add((IPath)toAdd);
                        }
                        ++var7_7;
                    }
                    if (nextPaths.size() <= 0) continue;
                    read.add(new RootDescription(nextPaths));
                }
            }
            catch (CoreException v0) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException v1) {}
                }
                break block21;
            }
            catch (IOException v2) {
                try {
                    ** if (in == null) goto lbl-1000
                }
                catch (Throwable var11_11) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException v4) {}
                    }
                    throw var11_11;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        in.close();
                    }
                    catch (IOException v3) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block21;
                }
            }
            if (in == null) break block21;
            try {
                in.close();
            }
            catch (IOException v5) {}
        }
        this.myRoots = read;
    }

    public Set<IProject> getReferencedProjects() {
        LinkedHashSet<IProject> result = new LinkedHashSet<IProject>();
        for (RootDescription nextDescription : this.getRoots()) {
            for (IPath next : nextDescription.getRoots()) {
                IProject candidate;
                if (!next.isAbsolute() || next.segmentCount() <= 1 || !(candidate = ResourcesPlugin.getWorkspace().getRoot().getProject(next.segment(0))).isAccessible()) continue;
                result.add(candidate);
            }
        }
        return result;
    }

    public boolean containsProject(IPath projectPath) {
        if (this.myRoots == null) {
            return false;
        }
        for (RootDescription nextRoots : this.myRoots) {
            for (IPath next : nextRoots.getRoots()) {
                if (!next.isAbsolute() || !projectPath.isPrefixOf(next)) continue;
                return true;
            }
        }
        return false;
    }

    public List<IPath> getMigratedXpandRootEntry(IContainer rootFolder, IFolder templatesOutputFolder) {
        assert (rootFolder instanceof IFolder || rootFolder instanceof IProject);
        if (rootFolder instanceof IFolder) {
            RootDescription rootDescription = this.getRootDescription((IFolder)rootFolder);
            assert (rootDescription != null);
            ArrayList<IPath> newRoots = new ArrayList<IPath>(rootDescription.getOriginalRoots());
            int i = 0;
            while (i < newRoots.size()) {
                if (i == 0) {
                    newRoots.set(0, templatesOutputFolder.getProjectRelativePath());
                } else {
                    newRoots.set(i, Activator.getDefault().getLegacyTemplateRootRegistry().getMigratedRoot((IPath)newRoots.get(i)));
                }
                ++i;
            }
            return newRoots;
        }
        return Collections.singletonList(templatesOutputFolder.getProjectRelativePath());
    }

    private RootDescription getRootDescription(IFolder rootFolder) {
        for (RootDescription rootDescription : this.getRoots()) {
            IPath mainIPath = rootDescription.getMainIPath();
            if (mainIPath == null) continue;
            IFolder descriptionRootFolder = null;
            if (mainIPath.isAbsolute()) {
                assert (mainIPath.segmentCount() > 1);
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(mainIPath.segment(0));
                if (project.isAccessible() && project.equals((Object)this.myProject)) {
                    descriptionRootFolder = this.myProject.getFolder(mainIPath.removeFirstSegments(1));
                }
            } else {
                descriptionRootFolder = this.myProject.getFolder(mainIPath);
            }
            if (descriptionRootFolder == null || !descriptionRootFolder.exists() || !descriptionRootFolder.equals((Object)rootFolder)) continue;
            return rootDescription;
        }
        return null;
    }

    public static interface IRootChangeListener {
        public void rootsChanged(RootManager var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class RootDescription {
        private final List<IPath> myOriginalRoots;
        private final List<IPath> myRoots;
        private WorkspaceResourceManager myManager;

        public RootDescription(List<IPath> roots) {
            assert (roots.size() > 0);
            this.myOriginalRoots = roots;
            this.myRoots = new ArrayList<IPath>(roots.size());
            for (IPath iPath : roots) {
                this.myRoots.add(Activator.getDefault().getLegacyTemplateRootRegistry().getActualRoot(iPath));
            }
        }

        public List<IPath> getOriginalRoots() {
            return this.myOriginalRoots;
        }

        public List<IPath> getRoots() {
            return this.myRoots;
        }

        public WorkspaceResourceManager getManager() {
            if (this.myManager == null) {
                this.myManager = new WorkspaceResourceManager(RootManager.this.getProject(), this.myRoots.toArray(new IPath[this.myRoots.size()]));
            }
            return this.myManager;
        }

        public boolean contains(IResource resource) {
            if (resource == null) {
                return false;
            }
            for (IPath nextRoot : this.myRoots) {
                if (!(nextRoot.isAbsolute() ? nextRoot.isPrefixOf(resource.getFullPath()) : resource.getProject().equals((Object)RootManager.this.getProject()) && nextRoot.isPrefixOf(resource.getProjectRelativePath()))) continue;
                return true;
            }
            return false;
        }

        public IPath getRelativePath(IResource resource) {
            for (IPath nextRoot : this.myRoots) {
                if (nextRoot.isAbsolute()) {
                    IPath fullPath = resource.getFullPath();
                    if (!nextRoot.isPrefixOf(fullPath)) continue;
                    return fullPath.removeFirstSegments(nextRoot.segmentCount());
                }
                IPath projectRelativePath = resource.getProjectRelativePath();
                if (!resource.getProject().equals((Object)RootManager.this.getProject()) || !nextRoot.isPrefixOf(projectRelativePath)) continue;
                return projectRelativePath.removeFirstSegments(nextRoot.segmentCount());
            }
            return null;
        }

        public IPath getMainIPath() {
            return this.myRoots.get(0);
        }
    }
}

