/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.lite.validation;

import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gmf.runtime.lite.validation.ValidationState;
import org.eclipse.gmf.runtime.lite.validation.ViolationDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationStateEvent
extends EventObject {
    private final Map<URI, Collection<ViolationDescriptor>> myOldViolations;
    private final Map<URI, Collection<ViolationDescriptor>> myNewViolations;
    private final Set<URI> myAllKeys;

    public ValidationStateEvent(ValidationState state, Map<URI, Collection<ViolationDescriptor>> oldViolations, Map<URI, Collection<ViolationDescriptor>> newViolations) {
        super(state);
        this.myOldViolations = oldViolations;
        this.myNewViolations = newViolations;
        this.myAllKeys = new HashSet<URI>(this.myOldViolations.keySet());
        this.myAllKeys.addAll(this.myNewViolations.keySet());
    }

    public ValidationState getSourceValidationState() {
        return (ValidationState)this.getSource();
    }

    public Collection<ViolationDescriptor> getOldViolations(URI uri) {
        Collection<ViolationDescriptor> result = this.myOldViolations.get(uri);
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    public Collection<ViolationDescriptor> getNewViolations(URI uri) {
        Collection<ViolationDescriptor> result = this.myNewViolations.get(uri);
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    public Iterable<URI> getViolationKeys() {
        return this.myAllKeys;
    }
}

