/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.lite.services;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;

public class ParserUtil {
    private ParserUtil() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object parseValue(EAttribute feature, Object value) throws IllegalArgumentException {
        if (value == null) {
            return null;
        }
        EDataType type = feature.getEAttributeType();
        Class iClass = type.getInstanceClass();
        if (Boolean.TYPE.equals(iClass) || Boolean.class.equals((Object)iClass)) {
            if (value instanceof Boolean) return value;
            if (!(value instanceof String)) throw new IllegalArgumentException("Value of type Boolean is expected");
            return Boolean.valueOf((String)value);
        }
        if (Character.TYPE.equals(iClass) || Character.class.equals((Object)iClass)) {
            if (value instanceof Character) return value;
            if (!(value instanceof String)) throw new IllegalArgumentException("Value of type Character is expected");
            String s = (String)value;
            if (s.length() != 0) return new Character(s.charAt(0));
            throw new IllegalArgumentException();
        }
        if (Byte.TYPE.equals(iClass) || Byte.class.equals((Object)iClass)) {
            if (value instanceof Byte) return value;
            if (value instanceof Number) {
                return new Byte(((Number)value).byteValue());
            }
            if (!(value instanceof String)) throw new IllegalArgumentException("Value of type Byte is expected");
            String s = (String)value;
            if (s.length() == 0) {
                return null;
            }
            try {
                return Byte.valueOf(s);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("String value does not convert to Byte value");
            }
        }
        if (Short.TYPE.equals(iClass) || Short.class.equals((Object)iClass)) {
            if (value instanceof Short) return value;
            if (value instanceof Number) {
                return new Short(((Number)value).shortValue());
            }
            if (!(value instanceof String)) throw new IllegalArgumentException("Value of type Short is expected");
            String s = (String)value;
            if (s.length() == 0) {
                return null;
            }
            try {
                return Short.valueOf(s);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("String value does not convert to Short value");
            }
        }
        if (Integer.TYPE.equals(iClass) || Integer.class.equals((Object)iClass)) {
            if (value instanceof Integer) return value;
            if (value instanceof Number) {
                return new Integer(((Number)value).intValue());
            }
            if (!(value instanceof String)) throw new IllegalArgumentException("Value of type Integer is expected");
            String s = (String)value;
            if (s.length() == 0) {
                return null;
            }
            try {
                return Integer.valueOf(s);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("String value does not convert to Integer value");
            }
        }
        if (Long.TYPE.equals(iClass) || Long.class.equals((Object)iClass)) {
            if (value instanceof Long) return value;
            if (value instanceof Number) {
                return new Long(((Number)value).longValue());
            }
            if (!(value instanceof String)) throw new IllegalArgumentException("Value of type Long is expected");
            String s = (String)value;
            if (s.length() == 0) {
                return null;
            }
            try {
                return Long.valueOf(s);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("String value does not convert to Long value");
            }
        }
        if (Float.TYPE.equals(iClass) || Float.class.equals((Object)iClass)) {
            if (value instanceof Float) return value;
            if (value instanceof Number) {
                return new Float(((Number)value).floatValue());
            }
            if (!(value instanceof String)) throw new IllegalArgumentException("Value of type Float is expected");
            String s = (String)value;
            if (s.length() == 0) {
                return null;
            }
            try {
                return Float.valueOf(s);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("String value does not convert to Float value");
            }
        }
        if (Double.TYPE.equals(iClass) || Double.class.equals((Object)iClass)) {
            if (value instanceof Double) return value;
            if (value instanceof Number) {
                return new Double(((Number)value).doubleValue());
            }
            if (!(value instanceof String)) throw new IllegalArgumentException("Value of type Double is expected");
            String s = (String)value;
            if (s.length() == 0) {
                return null;
            }
            try {
                return Double.valueOf(s);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("String value does not convert to Double value");
            }
        }
        if (String.class.equals((Object)iClass)) {
            return String.valueOf(value);
        }
        if (!(type instanceof EEnum)) throw new IllegalArgumentException("Unsupported type");
        if (!(value instanceof String)) throw new IllegalArgumentException("Value of type String is expected");
        EEnumLiteral literal = ((EEnum)type).getEEnumLiteralByLiteral((String)value);
        if (literal != null) return literal.getInstance();
        throw new IllegalArgumentException("Unknown literal: " + value);
    }
}

