/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.commands;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramCommandStack;

public class SemanticCreateCommand
extends AbstractCommand {
    CreateElementRequestAdapter requestAdapter;
    private ICommand realSemanticCommand;

    public SemanticCreateCommand(CreateElementRequestAdapter requestAdapter, Command realSemanticCommand) {
        super(realSemanticCommand.getLabel() == null ? "" : realSemanticCommand.getLabel(), null);
        Assert.isNotNull((Object)requestAdapter);
        Assert.isNotNull((Object)realSemanticCommand);
        this.requestAdapter = requestAdapter;
        this.realSemanticCommand = DiagramCommandStack.getICommand(realSemanticCommand);
        this.recomputeContexts();
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        this.realSemanticCommand.execute(progressMonitor, info);
        CommandResult result = this.realSemanticCommand.getCommandResult();
        if (result.getStatus().isOK()) {
            Object object = result.getReturnValue();
            if (object instanceof Collection) {
                Collection col = (Collection)object;
                Object object2 = object = col.isEmpty() ? null : (Object)col.iterator().next();
            }
            if (object != null) {
                Assert.isTrue((boolean)(object instanceof EObject), (String)"Failed to get an IElement out of the semantic command returned value");
                EObject element = (EObject)object;
                this.requestAdapter.setNewElement(element);
            }
            result = CommandResult.newOKCommandResult((Object)this.requestAdapter);
        }
        this.recomputeContexts();
        return result;
    }

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        this.realSemanticCommand.redo(progressMonitor, info);
        CommandResult result = this.realSemanticCommand.getCommandResult();
        this.recomputeContexts();
        return result;
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        this.realSemanticCommand.undo(progressMonitor, info);
        CommandResult result = this.realSemanticCommand.getCommandResult();
        this.recomputeContexts();
        return result;
    }

    public boolean canExecute() {
        return this.realSemanticCommand.canExecute();
    }

    public boolean canUndo() {
        return this.realSemanticCommand.canUndo();
    }

    public boolean canRedo() {
        return this.realSemanticCommand.canRedo();
    }

    public List getAffectedFiles() {
        return this.realSemanticCommand.getAffectedFiles();
    }

    private void recomputeContexts() {
        IUndoContext[] realContexts = this.realSemanticCommand.getContexts();
        IUndoContext[] myContexts = this.getContexts();
        int i = 0;
        while (i < myContexts.length) {
            this.removeContext(myContexts[i]);
            ++i;
        }
        i = 0;
        while (i < realContexts.length) {
            this.addContext(realContexts[i]);
            ++i;
        }
    }

    public void addContext(IUndoContext context) {
        super.addContext(context);
        this.realSemanticCommand.addContext(context);
    }

    public void removeContext(IUndoContext context) {
        super.removeContext(context);
        this.realSemanticCommand.removeContext(context);
    }

    public void dispose() {
        super.dispose();
        this.realSemanticCommand.dispose();
    }
}

