/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.common.reconcile;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.internal.common.reconcile.Copier;
import org.eclipse.gmf.internal.common.reconcile.Decision;
import org.eclipse.gmf.internal.common.reconcile.Matcher;
import org.eclipse.gmf.internal.common.reconcile.ReconcilerConfig;
import org.eclipse.gmf.internal.common.reconcile.ReflectiveMatcher;

public class ReconcilerConfigBase
implements ReconcilerConfig {
    private static final EClassRecord EMPTY_RECORD = new EClassRecord();
    private final HashMap<EClass, EClassRecord> myEClass2Record = new HashMap();
    private final HashMap<EClass, EClassRecord> myAbstractEClass2SubclassesRecord = new HashMap();
    protected static final Matcher ALWAYS_MATCH = new Matcher(){

        public boolean match(EObject current, EObject old) {
            return current.eClass().equals(old.eClass());
        }
    };

    public final Matcher getMatcher(EClass eClass) {
        Matcher result = this.getRecord(eClass, false).getMatcher();
        if (result != Matcher.FALSE) {
            return result;
        }
        return this.getExistingRecordFromHierarchy(eClass).getMatcher();
    }

    public Copier getCopier(EClass eClass) {
        return this.getRecord(eClass, false).getCopier();
    }

    public final Decision[] getDecisions(EClass eClass) {
        return this.getRecord(eClass, false).getDecisions();
    }

    protected final void setMatcher(EClass eClass, Matcher matcher) {
        this.getRecord(eClass, true).setMatcher(matcher);
    }

    protected final void setCopier(EClass eClass, Copier copier) {
        this.getRecord(eClass, true).setCopier(copier);
    }

    protected final void setMatcherForAllSubclasses(EClass eClass, Matcher matcher) {
        if (!eClass.isAbstract()) {
            throw new IllegalArgumentException("This is not safe method that may lead to strange behaviour in case of multiple inheritance. We tried to limit its usage as much as possible");
        }
        this.getTemplateRecord(eClass, true).setMatcher(matcher);
    }

    protected final void addDecision(EClass eClass, Decision decision) {
        this.getRecord(eClass, true).addDecision(decision);
    }

    protected final void setMatcher(EClass eClass, EAttribute attribute) {
        this.checkStructuralFeature(eClass, attribute);
        ReflectiveMatcher matcher = new ReflectiveMatcher((EStructuralFeature)attribute);
        this.setMatcher(eClass, matcher);
    }

    protected final void setMatcher(EClass eClass, EReference reference) {
        if (eClass.getEPackage().equals(reference.eClass().getEPackage())) {
            this.setMatcher(eClass, new ReflectiveMatcher((EStructuralFeature)reference));
        } else {
            this.setMatcher(eClass, new ReflectiveMatcher((EStructuralFeature)reference));
        }
    }

    private EClassRecord getRecord(EClass eClass, boolean force) {
        EClassRecord result = this.myEClass2Record.get(eClass);
        if (result == null) {
            if (force) {
                result = new EClassRecord();
                this.myEClass2Record.put(eClass, result);
            } else {
                result = this.getExistingRecordFromHierarchy(eClass);
                if (result != EMPTY_RECORD) {
                    this.myEClass2Record.put(eClass, result);
                }
            }
        }
        return result;
    }

    private EClassRecord getExistingRecordFromHierarchy(EClass eClass) {
        EClassRecord result = EMPTY_RECORD;
        Iterator superClasses = eClass.getEAllSuperTypes().iterator();
        while (result == EMPTY_RECORD && superClasses.hasNext()) {
            EClass nextSuper = (EClass)superClasses.next();
            if (!nextSuper.isAbstract()) continue;
            result = this.getTemplateRecord(nextSuper, false);
        }
        return result;
    }

    private EClassRecord getTemplateRecord(EClass abstractSuperClass, boolean force) {
        assert (abstractSuperClass.isAbstract());
        EClassRecord result = this.myAbstractEClass2SubclassesRecord.get(abstractSuperClass);
        if (result == null && force) {
            result = new EClassRecord();
            this.myAbstractEClass2SubclassesRecord.put(abstractSuperClass, result);
        }
        return result == null ? EMPTY_RECORD : result;
    }

    private void checkStructuralFeature(EClass expectedClass, EAttribute feature) {
        if (expectedClass.getEStructuralFeature(feature.getFeatureID()) != feature) {
            throw new IllegalArgumentException(MessageFormat.format("Alien feature {0} for EClass {1}", feature, expectedClass));
        }
    }

    private static class EClassRecord {
        private Matcher myMatcher = Matcher.FALSE;
        private Copier myCopier = Copier.NEVER_COPY;
        private final List<Decision> myDecisions = new LinkedList<Decision>();
        private Decision[] myMakersArray;

        private EClassRecord() {
        }

        public void addDecision(Decision maker) {
            this.myDecisions.add(maker);
            this.makersSetChanged();
        }

        public void setCopier(Copier copier) {
            this.myCopier = copier;
        }

        public Decision[] getDecisions() {
            if (this.myMakersArray == null) {
                this.myMakersArray = this.myDecisions.toArray(new Decision[this.myDecisions.size()]);
            }
            return this.myMakersArray;
        }

        public void setMatcher(Matcher matcher) {
            this.myMatcher = matcher;
        }

        public Matcher getMatcher() {
            return this.myMatcher;
        }

        public Copier getCopier() {
            return this.myCopier;
        }

        private void makersSetChanged() {
            this.myMakersArray = null;
        }
    }
}

