/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.codegen.dispatch;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.eclipse.emf.codegen.jet.JETEmitter;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.gmf.common.UnexpectedBehaviourException;
import org.eclipse.gmf.internal.codegen.dispatch.EmitterFactory;
import org.eclipse.gmf.internal.codegen.dispatch.NoSuchTemplateException;
import org.eclipse.gmf.internal.codegen.dispatch.TemplateRegistry;

public class EmitterFactoryImpl
implements EmitterFactory {
    private final TemplateRegistry myTemplates;
    private final boolean myUsePrecompiled;
    private final String[] myVariables;
    private String[] myTemplatePath;

    public EmitterFactoryImpl(String[] templatePath, TemplateRegistry templates) {
        this(templatePath, templates, true, null);
    }

    public EmitterFactoryImpl(String[] templatePath, TemplateRegistry templates, boolean usePrecompiled, String[] variables) {
        assert (templatePath != null && templatePath.length > 0 && templates != null);
        assert (variables == null || !Arrays.asList(variables).contains(null));
        this.myTemplatePath = templatePath;
        this.myTemplates = templates;
        this.myUsePrecompiled = usePrecompiled;
        this.myVariables = variables == null ? new String[]{} : variables;
    }

    public boolean checkEmitter(Object key) {
        return this.myTemplates.getTemplatePath(key) != null;
    }

    public JETEmitter acquireEmitter(Object key) throws NoSuchTemplateException, UnexpectedBehaviourException {
        String relativePath = this.constructPath(key);
        ClassLoader cl = this.precompiledInUse(key) ? this.myTemplates.getGeneratorClass(key).getClassLoader() : this.myTemplates.getTemplateClassLoader(key);
        JETEmitter em = new JETEmitter(this.myTemplatePath, relativePath, cl);
        this.feedVariables(em);
        this.initPrecompiled(key, em);
        return em;
    }

    private boolean precompiledInUse(Object key) {
        return this.myUsePrecompiled && this.myTemplates.hasGeneratorClass(key);
    }

    private void initPrecompiled(Object key, JETEmitter em) throws UnexpectedBehaviourException {
        try {
            if (this.precompiledInUse(key)) {
                Method m = this.myTemplates.getGeneratorClass(key).getMethod("generate", Object.class);
                em.setMethod(m);
            }
        }
        catch (NoSuchMethodException ex) {
            throw new UnexpectedBehaviourException("Bad template class", ex);
        }
    }

    private String constructPath(Object key) throws UnexpectedBehaviourException, NoSuchTemplateException {
        String path = this.myTemplates.getTemplatePath(key);
        if (path == null) {
            throw new NoSuchTemplateException(String.valueOf(key));
        }
        return path;
    }

    private void feedVariables(JETEmitter em) throws UnexpectedBehaviourException {
        try {
            int i = 0;
            while (i < this.myVariables.length) {
                em.addVariable(null, this.myVariables[i]);
                ++i;
            }
        }
        catch (JETException ex) {
            throw new UnexpectedBehaviourException(ex.getMessage(), ex);
        }
    }
}

