/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe.core.resources;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.emf.mwe.core.resources.ResourceLoader;
import org.eclipse.emf.mwe.internal.core.MWEPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceLoaderDefaultImpl
implements ResourceLoader {
    @Override
    public final InputStream getResourceAsStream(String path) {
        URL resource = this.getResource(path);
        if (resource != null) {
            try {
                return resource.openStream();
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    @Override
    public final Class<?> loadClass(String clazzName) {
        try {
            return MWEPlugin.loadClass("org.eclipse.emf.mwe.core", clazzName);
        }
        catch (Exception exception) {
            try {
                return this.internalLoadClass(clazzName);
            }
            catch (Exception exception2) {
                if (clazzName.startsWith("mwe")) {
                    return this.loadClass(clazzName.replaceFirst("mwe", "org.eclipse.emf.mwe"));
                }
                return null;
            }
        }
    }

    protected Class<?> internalLoadClass(String clazzName) throws ClassNotFoundException {
        return Class.forName(clazzName, true, Thread.currentThread().getContextClassLoader());
    }

    @Override
    public final URL getResource(String path) {
        URL url = this.loadDirectly(path);
        if (url == null) {
            url = this.loadFromBaseURL(path);
        }
        if (url == null) {
            url = this.loadFromContextClassLoader(path);
        }
        if (url == null) {
            url = this.loadFromFile(path);
        }
        return url;
    }

    private URL loadFromFile(String path) {
        try {
            File f = new File(path);
            if (f.exists()) {
                return f.toURL();
            }
        }
        catch (Exception exception) {}
        return null;
    }

    private URL loadFromBaseURL(String path) {
        try {
            URL url = new URL(MWEPlugin.INSTANCE.getBaseURL() + path);
            if (url.getContent() != null) {
                return url;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    private URL loadDirectly(String path) {
        try {
            URL url = new URL(path);
            if (url.getContent() != null) {
                return url;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    protected URL loadFromContextClassLoader(String path) {
        return Thread.currentThread().getContextClassLoader().getResource(path);
    }
}

