/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.protocol;

import java.util.Collection;
import org.eclipse.emf.cdo.core.protocol.AbstractCDOProtocol;
import org.eclipse.emf.cdo.server.Mapper;
import org.eclipse.emf.cdo.server.ServerCDOProtocol;
import org.eclipse.emf.cdo.server.ServerCDOResProtocol;
import org.eclipse.emf.cdo.server.protocol.AnnouncePackageIndication;
import org.eclipse.emf.cdo.server.protocol.CommitTransactionIndication;
import org.eclipse.emf.cdo.server.protocol.DescribePackageIndication;
import org.eclipse.emf.cdo.server.protocol.InvalidationNotificationRequest;
import org.eclipse.emf.cdo.server.protocol.LoadObjectIndication;
import org.eclipse.emf.cdo.server.protocol.LoadResourceIndication;
import org.eclipse.emf.cdo.server.protocol.QueryExtentIndication;
import org.eclipse.emf.cdo.server.protocol.QueryXRefsIndication;
import org.eclipse.emf.cdo.server.protocol.RemovalNotificationRequest;
import org.eclipse.emf.cdo.server.protocol.ResourcePathIndication;
import org.eclipse.emf.cdo.server.protocol.ResourceRIDIndication;
import org.eclipse.net4j.core.Channel;
import org.eclipse.net4j.core.Indication;
import org.eclipse.net4j.core.Request;
import org.eclipse.net4j.spring.ValidationException;
import org.eclipse.net4j.util.ImplementationError;
import org.springframework.transaction.support.TransactionTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerCDOProtocolImpl
extends AbstractCDOProtocol
implements ServerCDOProtocol,
ServerCDOResProtocol.Listener {
    protected Mapper mapper;
    protected TransactionTemplate transactionTemplate;
    protected ServerCDOResProtocol serverCDOResProtocol;

    public int getType() {
        return 1;
    }

    public Indication createIndication(short signalId) {
        switch (signalId) {
            case 1: {
                return new AnnouncePackageIndication();
            }
            case 2: {
                return new DescribePackageIndication();
            }
            case 3: {
                return new ResourceRIDIndication();
            }
            case 4: {
                return new ResourcePathIndication();
            }
            case 5: {
                return new LoadResourceIndication();
            }
            case 6: {
                return new LoadObjectIndication();
            }
            case 7: {
                return new CommitTransactionIndication();
            }
            case 8: {
                return new QueryExtentIndication();
            }
            case 9: {
                return new QueryXRefsIndication();
            }
        }
        throw new ImplementationError("Invalid cdo signalId: " + signalId);
    }

    @Override
    public Mapper getMapper() {
        return this.mapper;
    }

    public void setMapper(Mapper mapper) {
        this.doSet("mapper", mapper);
    }

    @Override
    public TransactionTemplate getTransactionTemplate() {
        return this.transactionTemplate;
    }

    public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.doSet("transactionTemplate", transactionTemplate);
    }

    @Override
    public ServerCDOResProtocol getServerCDOResProtocol() {
        return this.serverCDOResProtocol;
    }

    public void setServerCDOResProtocol(ServerCDOResProtocol serverCDOResProtocol) {
        this.doSet("serverCDOResProtocol", serverCDOResProtocol);
    }

    @Override
    public void notifyRemoval(ServerCDOResProtocol protocol, Collection<Integer> rids) {
        this.fireRemovalNotification(rids);
    }

    @Override
    public void notifyInvalidation(ServerCDOResProtocol protocol, Collection<Long> modifiedOIDs) {
        this.fireInvalidationNotification(null, modifiedOIDs);
    }

    @Override
    public void fireRemovalNotification(Collection<Integer> rids) {
        Channel[] channelArray = this.getChannels();
        int n = 0;
        int n2 = channelArray.length;
        while (n < n2) {
            Channel channel = channelArray[n];
            try {
                RemovalNotificationRequest signal = new RemovalNotificationRequest(rids);
                channel.transmit((Request)signal);
            }
            catch (Exception ex) {
                this.error("Error while transmitting removal notifications for rids " + rids, ex);
            }
            ++n;
        }
    }

    @Override
    public void fireInvalidationNotification(Channel initiator, Collection<Long> changedObjectIds) {
        Channel[] channelArray = this.getChannels();
        int n = 0;
        int n2 = channelArray.length;
        while (n < n2) {
            Channel channel = channelArray[n];
            if (initiator == null || channel != initiator && channel.getConnector().getType() == initiator.getConnector().getType()) {
                try {
                    InvalidationNotificationRequest signal = new InvalidationNotificationRequest(changedObjectIds);
                    channel.transmit((Request)signal);
                }
                catch (Exception ex) {
                    this.error("Error while transmitting invalidation notifications for oids " + changedObjectIds, ex);
                }
            }
            ++n;
        }
    }

    protected void validate() throws ValidationException {
        super.validate();
        this.assertNotNull("mapper");
        this.assertNotNull("transactionTemplate");
    }

    protected void activate() throws Exception {
        super.activate();
        if (this.serverCDOResProtocol != null) {
            this.serverCDOResProtocol.addListener(this);
        }
    }

    protected void deactivate() throws Exception {
        if (this.serverCDOResProtocol != null) {
            this.serverCDOResProtocol.removeListener(this);
            this.serverCDOResProtocol = null;
        }
        this.mapper = null;
        this.transactionTemplate = null;
        super.deactivate();
    }
}

