/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.util;

import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IFilter;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.util.CDOPackageType;
import org.eclipse.emf.cdo.util.CDOPackageTypeRegistry;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.CDOAware;
import org.eclipse.emf.ecore.impl.EPackageImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.util.ModelUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.registry.HashMapRegistry;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CDOPackageTypeRegistryImpl
extends HashMapRegistry<String, CDOPackageType>
implements CDOPackageTypeRegistry {
    public static final CDOPackageTypeRegistryImpl INSTANCE = new CDOPackageTypeRegistryImpl();
    private static final String ECORE_ID = "org.eclipse.emf.ecore";
    private Object extensionTracker;

    private CDOPackageTypeRegistryImpl() {
        if (OMPlatform.INSTANCE.isOSGiRunning()) {
            this.initPackageTypes();
        }
    }

    @Override
    public CDOPackageType getPackageType(EPackage ePackage) {
        if (ePackage.getClass() == EPackageImpl.class) {
            return CDOPackageType.NATIVE;
        }
        EPackage topLevelPackage = ModelUtil.getTopLevelPackage(ePackage);
        EClass eClass = this.getAnyEClass(topLevelPackage);
        if (eClass == null) {
            throw new IllegalArgumentException("ePackage does not contain classes");
        }
        try {
            if (this.isConverted(eClass)) {
                return CDOPackageType.CONVERTED;
            }
        }
        catch (Throwable throwable) {}
        Class instanceClass = eClass.getInstanceClass();
        if (CDOObject.class.isAssignableFrom(instanceClass)) {
            return CDOPackageType.NATIVE;
        }
        return CDOPackageType.LEGACY;
    }

    @Override
    public void register(EPackage ePackage) {
        this.put(ePackage.getNsURI(), (Object)this.getPackageType(ePackage));
    }

    @Override
    public void registerLegacy(String uri) {
        this.put(uri, (Object)CDOPackageType.LEGACY);
    }

    @Override
    public void registerNative(String uri) {
        this.put(uri, (Object)CDOPackageType.NATIVE);
    }

    @Override
    public void registerConverted(String uri) {
        this.put(uri, (Object)CDOPackageType.CONVERTED);
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        if (OMPlatform.INSTANCE.isOSGiRunning()) {
            try {
                this.connectExtensionTracker();
            }
            catch (Throwable t) {
                OM.LOG.error(t);
            }
        }
    }

    protected void doDeactivate() throws Exception {
        if (OMPlatform.INSTANCE.isOSGiRunning()) {
            try {
                this.disconnectExtensionTracker();
            }
            catch (Throwable t) {
                OM.LOG.error(t);
            }
        }
        super.doDeactivate();
    }

    private void initPackageTypes() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(ECORE_ID, "generated_package");
        this.addPackageTypes(elements);
    }

    private void addPackageTypes(IConfigurationElement[] elements) {
        HashMap<String, CDOPackageType> bundles = new HashMap<String, CDOPackageType>();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String uri = element.getAttribute("uri");
            if (!StringUtil.isEmpty((String)uri) && !uri.equals(EresourcePackage.eINSTANCE.getNsURI())) {
                String bundleName = element.getContributor().getName();
                CDOPackageType packageType = (CDOPackageType)((Object)bundles.get(bundleName));
                if (packageType == null) {
                    Bundle bundle = Platform.getBundle((String)bundleName);
                    packageType = this.getBundleType(bundle);
                    bundles.put(bundleName, packageType);
                }
                this.put(uri, (Object)packageType);
            }
            ++n2;
        }
    }

    private CDOPackageType getBundleType(Bundle bundle) {
        if (bundle.getEntry("META-INF/CDO.MF") != null) {
            return CDOPackageType.NATIVE;
        }
        String version = (String)bundle.getHeaders().get("Bundle-Version");
        if (version.endsWith("-CDO")) {
            return CDOPackageType.CONVERTED;
        }
        return CDOPackageType.LEGACY;
    }

    private EClass getAnyEClass(EPackage ePackage) {
        for (EClassifier classifier : ePackage.getEClassifiers()) {
            if (!(classifier instanceof EClass)) continue;
            return (EClass)classifier;
        }
        for (EPackage subpackage : ePackage.getESubpackages()) {
            EClass eClass = this.getAnyEClass(subpackage);
            if (eClass == null) continue;
            return eClass;
        }
        return null;
    }

    private boolean isConverted(EClass eClass) {
        Class instanceClass = eClass.getInstanceClass();
        return CDOAware.class.isAssignableFrom(instanceClass);
    }

    private void connectExtensionTracker() {
        ExtensionTracker extensionTracker = new ExtensionTracker();
        extensionTracker.registerHandler(new IExtensionChangeHandler(){

            public void addExtension(IExtensionTracker tracker, IExtension extension) {
                IConfigurationElement[] elements = extension.getConfigurationElements();
                CDOPackageTypeRegistryImpl.this.addPackageTypes(elements);
            }

            public void removeExtension(IExtension extension, Object[] objects) {
            }
        }, this.createExtensionPointFilter());
        this.extensionTracker = extensionTracker;
    }

    private void disconnectExtensionTracker() {
        ExtensionTracker extensionTracker = (ExtensionTracker)this.extensionTracker;
        extensionTracker.close();
    }

    private IFilter createExtensionPointFilter() {
        final IExtensionPoint xpt = Platform.getExtensionRegistry().getExtensionPoint(EcorePlugin.getPlugin().getBundle().getSymbolicName(), "generated_package");
        return new IFilter(){

            public boolean matches(IExtensionPoint target) {
                return xpt.equals((Object)target);
            }
        };
    }
}

