/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.emf.cdo.internal.server.ContainerRepositoryProvider;
import org.eclipse.emf.cdo.internal.server.Repository;
import org.eclipse.emf.cdo.internal.server.RepositoryFactory;
import org.eclipse.emf.cdo.internal.server.protocol.CDOServerProtocolFactory;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IRepositoryProvider;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.factory.IFactory;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.OMPlatform;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CDOServerUtil {
    private CDOServerUtil() {
    }

    public static IRepository createRepository(String name, IStore store, Map<String, String> props) {
        Repository repository = new Repository();
        repository.setName(name);
        repository.setStore(store);
        repository.setProperties(props);
        return repository;
    }

    public static void prepareContainer(IManagedContainer container, IRepositoryProvider repositoryProvider) {
        container.registerFactory((IFactory)new CDOServerProtocolFactory(repositoryProvider));
    }

    public static void prepareContainer(IManagedContainer container) {
        CDOServerUtil.prepareContainer(container, new ContainerRepositoryProvider(container));
    }

    public static void addRepository(IManagedContainer container, IRepository repository) {
        LifecycleUtil.activate((Object)repository);
        container.putElement("org.eclipse.emf.cdo.server.repositories", "default", repository.getName(), (Object)repository);
    }

    public static IRepository getRepository(IManagedContainer container, String name) {
        return RepositoryFactory.get(container, name);
    }

    public static Element getRepositoryConfig(String repositoryName) throws ParserConfigurationException, SAXException, IOException {
        File configFile = OMPlatform.INSTANCE.getConfigFile("cdo.server.xml");
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(configFile);
        NodeList elements = document.getElementsByTagName("repository");
        int i = 0;
        while (i < elements.getLength()) {
            Element element;
            String name;
            Node node = elements.item(i);
            if (node instanceof Element && ObjectUtil.equals((Object)(name = (element = (Element)node).getAttribute("name")), (Object)repositoryName)) {
                return element;
            }
            ++i;
        }
        throw new IllegalStateException("Repository config not found: " + repositoryName);
    }
}

