/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.internal.utils;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.eclipse.emf.compare.graph.IGraph;
import org.eclipse.emf.compare.graph.IGraphView;
import org.eclipse.emf.compare.graph.PruningIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReadOnlyGraph<E>
implements IGraphView<E> {
    private final IGraph<E> graph;

    private ReadOnlyGraph(IGraph<E> graph) {
        this.graph = graph;
    }

    public static <E> ReadOnlyGraph<E> toReadOnlyGraph(IGraph<E> graph) {
        return new ReadOnlyGraph<E>(graph);
    }

    @Override
    public boolean contains(E element) {
        return this.graph.contains(element);
    }

    @Override
    public boolean hasChild(E parent, E potentialChild) {
        return this.graph.hasChild(parent, potentialChild);
    }

    @Override
    public ImmutableSet<E> getDirectParents(E element) {
        return ImmutableSet.copyOf(this.graph.getDirectParents(element));
    }

    @Override
    public E getParentData(E element) {
        return this.graph.getParentData(element);
    }

    @Override
    public ImmutableSet<E> getSubgraphContaining(E element) {
        return this.getSubgraphContaining(element, ImmutableSet.of());
    }

    @Override
    public ImmutableSet<E> getSubgraphContaining(E element, ImmutableSet<E> endPoints) {
        return ImmutableSet.copyOf(this.graph.getSubgraphContaining(element, (Set<E>)endPoints));
    }

    @Override
    public ImmutableSet<E> getTreeFrom(E root) {
        return this.getTreeFrom(root, (Set<E>)ImmutableSet.of());
    }

    @Override
    public ImmutableSet<E> getTreeFrom(E root, Set<E> endPoints) {
        return ImmutableSet.copyOf(this.graph.getTreeFrom(root, endPoints));
    }

    @Override
    public PruningIterator<E> breadthFirstIterator() {
        return this.graph.breadthFirstIterator();
    }
}

