/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.handler;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.command.ICompareCopyCommand;
import org.eclipse.emf.compare.domain.ICompareEditingDomain;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.handler.util.EMFCompareUIHandlerUtil;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.emf.edit.command.ChangeCommand;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class AbstractAcceptRejectAllChanges
extends AbstractHandler {
    protected CompareConfiguration configuration;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object editorInput = HandlerUtil.getVariable((ExecutionEvent)event, (String)"activeEditorInput");
        if (editorInput instanceof CompareEditorInput) {
            boolean leftEditableOnly;
            this.configuration = ((CompareEditorInput)editorInput).getCompareConfiguration();
            boolean rightEditableOnly = !this.configuration.isLeftEditable() && this.configuration.isRightEditable();
            boolean bl = leftEditableOnly = this.configuration.isLeftEditable() && !this.configuration.isRightEditable();
            if (leftEditableOnly) {
                this.manageChanges(false);
            } else if (rightEditableOnly) {
                this.manageChanges(true);
            }
        }
        return null;
    }

    protected abstract boolean isCopyDiffCase(Diff var1, boolean var2);

    private void manageChanges(final boolean leftToRight) {
        Comparison comparison = (Comparison)this.configuration.getProperty("org.eclipse.emf.compare.rcp.ui.COMPARE.RESULT");
        ImmutableList differences = comparison.isThreeWay() ? ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)comparison.getDifferences(), (Predicate)new Predicate<Diff>(){

            public boolean apply(Diff diff) {
                boolean fromRightToLeft;
                boolean unresolved = diff.getState() == DifferenceState.UNRESOLVED;
                boolean nonConflictual = diff.getConflict() == null;
                boolean fromLeftToRight = leftToRight && diff.getSource() == DifferenceSource.LEFT;
                boolean bl = fromRightToLeft = !leftToRight && diff.getSource() == DifferenceSource.RIGHT;
                return unresolved && nonConflictual && (fromLeftToRight || fromRightToLeft);
            }
        })) : ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)comparison.getDifferences(), (Predicate)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.UNRESOLVED})));
        if (differences.size() > 0) {
            ICompareEditingDomain editingDomain = (ICompareEditingDomain)this.configuration.getProperty("org.eclipse.emf.compare.rcp.ui.EDITING_DOMAIN");
            AcceptRejectAllChangesCompoundCommand compoundCommand = new AcceptRejectAllChangesCompoundCommand(leftToRight);
            for (Diff diff : differences) {
                if (DifferenceState.UNRESOLVED != diff.getState()) continue;
                if (this.isCopyDiffCase(diff, leftToRight)) {
                    EMFCompareUIHandlerUtil.setMergeDataForDiff(diff, leftToRight, this.configuration.isLeftEditable(), this.configuration.isRightEditable());
                    compoundCommand.append(editingDomain.createCopyCommand((List)Lists.newArrayList((Object[])new Diff[]{diff}), leftToRight, EMFCompareRCPPlugin.getDefault().getMergerRegistry()));
                    continue;
                }
                compoundCommand.append(this.createChangeStateFromUnresolvedToMergedCommand(diff, !leftToRight));
            }
            editingDomain.getCommandStack().execute((Command)compoundCommand);
        }
    }

    protected Command createChangeStateFromUnresolvedToMergedCommand(Diff diffToChangeState, boolean leftToRight) {
        if (diffToChangeState != null) {
            ICompareEditingDomain compareEditingDomain = (ICompareEditingDomain)this.configuration.getProperty("org.eclipse.emf.compare.rcp.ui.EDITING_DOMAIN");
            AcceptRejectAllChangesCommand changeStateCommand = new AcceptRejectAllChangesCommand(compareEditingDomain.getChangeRecorder(), diffToChangeState, leftToRight, this.configuration);
            return changeStateCommand;
        }
        return null;
    }

    private static class AcceptRejectAllChangesCommand
    extends ChangeCommand
    implements ICompareCopyCommand {
        private Diff difference;
        private boolean leftToRight;
        private CompareConfiguration configuration;

        public AcceptRejectAllChangesCommand(ChangeRecorder changeRecorder, Diff difference, boolean leftToRight, CompareConfiguration configuration) {
            super(changeRecorder, (Notifier)difference);
            this.difference = difference;
            this.leftToRight = leftToRight;
            this.configuration = configuration;
        }

        public void doExecute() {
            EMFCompareUIHandlerUtil.setMergeDataForDiff(this.difference, this.leftToRight, this.configuration.isLeftEditable(), this.configuration.isRightEditable());
            this.difference.setState(DifferenceState.MERGED);
        }

        public boolean isLeftToRight() {
            return this.leftToRight;
        }
    }

    private static class AcceptRejectAllChangesCompoundCommand
    extends CompoundCommand
    implements ICompareCopyCommand {
        private boolean leftToRight;

        public AcceptRejectAllChangesCompoundCommand(boolean leftToRight) {
            this.leftToRight = leftToRight;
        }

        public boolean isLeftToRight() {
            return this.leftToRight;
        }
    }
}

