/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.table;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.contentmergeviewer.IMergeViewerContentProvider;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.accessor.AccessorAdapter;
import org.eclipse.emf.compare.ide.utils.ResourceUtil;
import org.eclipse.emf.compare.rcp.ui.internal.contentmergeviewer.accessor.ICompareAccessor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

public class TableContentMergeViewerContentProvider
implements IMergeViewerContentProvider {
    public static final char ANCESTOR_CONTRIBUTOR = 'A';
    public static final char RIGHT_CONTRIBUTOR = 'R';
    public static final char LEFT_CONTRIBUTOR = 'L';
    private CompareConfiguration fCompareConfiguration;
    private String fAncestorError;
    private String fLeftError;
    private String fRightError;

    public TableContentMergeViewerContentProvider(CompareConfiguration cc) {
        this.fCompareConfiguration = cc;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer v, Object o1, Object o2) {
    }

    public void setAncestorError(String errorMessage) {
        this.fAncestorError = errorMessage;
    }

    public String getAncestorLabel(Object element) {
        if (this.fAncestorError != null) {
            return this.fAncestorError;
        }
        return this.fCompareConfiguration.getAncestorLabel(element);
    }

    public Image getAncestorImage(Object element) {
        if (this.fAncestorError != null) {
            return null;
        }
        return this.fCompareConfiguration.getAncestorImage(element);
    }

    public Object getAncestorContent(Object element) {
        if (element instanceof ICompareInput) {
            ITypedElement ancestor = ((ICompareInput)element).getAncestor();
            if (ancestor instanceof AccessorAdapter) {
                return ((AccessorAdapter)ancestor).getTarget();
            }
            return ancestor;
        }
        return null;
    }

    public boolean showAncestor(Object element) {
        return element instanceof ICompareInput;
    }

    public void setLeftError(String errorMessage) {
        this.fLeftError = errorMessage;
    }

    public String getLeftLabel(Object element) {
        if (this.fLeftError != null) {
            return this.fLeftError;
        }
        return this.fCompareConfiguration.getLeftLabel(element);
    }

    public Image getLeftImage(Object element) {
        if (this.fLeftError != null) {
            return null;
        }
        return this.fCompareConfiguration.getLeftImage(element);
    }

    public Object getLeftContent(Object element) {
        if (element instanceof ICompareInput) {
            ITypedElement left = ((ICompareInput)element).getLeft();
            if (left instanceof AccessorAdapter) {
                return ((AccessorAdapter)left).getTarget();
            }
            return left;
        }
        return null;
    }

    public boolean isLeftEditable(Object element) {
        return this.fCompareConfiguration.isLeftEditable();
    }

    public void saveLeftContent(Object element, byte[] bytes) {
        Object left = this.getLeftContent(element);
        if (left instanceof ICompareAccessor) {
            Comparison comparison = ((ICompareAccessor)left).getComparison();
            EList matches = comparison.getMatches();
            EObject leftEObject = null;
            for (Match match : matches) {
                leftEObject = match.getLeft();
                if (leftEObject != null) break;
            }
            if (leftEObject != null) {
                Resource eResource = leftEObject.eResource();
                ResourceSet resourceSet = eResource.getResourceSet();
                ResourceUtil.saveAllResources((ResourceSet)resourceSet, (Map)ImmutableMap.of((Object)"SAVE_ONLY_IF_CHANGED", (Object)"MEMORY_BUFFER"));
            }
        }
    }

    public void setRightError(String errorMessage) {
        this.fRightError = errorMessage;
    }

    public String getRightLabel(Object element) {
        if (this.fRightError != null) {
            return this.fRightError;
        }
        return this.fCompareConfiguration.getRightLabel(element);
    }

    public Image getRightImage(Object element) {
        if (this.fRightError != null) {
            return null;
        }
        return this.fCompareConfiguration.getRightImage(element);
    }

    public Object getRightContent(Object element) {
        if (element instanceof ICompareInput) {
            ITypedElement right = ((ICompareInput)element).getRight();
            if (right instanceof AccessorAdapter) {
                return ((AccessorAdapter)right).getTarget();
            }
            return right;
        }
        return null;
    }

    public boolean isRightEditable(Object element) {
        return this.fCompareConfiguration.isRightEditable();
    }

    public void saveRightContent(Object element, byte[] bytes) {
        Object right = this.getRightContent(element);
        if (right instanceof ICompareAccessor) {
            Comparison comparison = ((ICompareAccessor)right).getComparison();
            EList matches = comparison.getMatches();
            EObject rightEObject = null;
            for (Match match : matches) {
                rightEObject = match.getRight();
                if (rightEObject != null) break;
            }
            if (rightEObject != null) {
                Resource eResource = rightEObject.eResource();
                ResourceSet resourceSet = eResource.getResourceSet();
                ResourceUtil.saveAllResources((ResourceSet)resourceSet, (Map)ImmutableMap.of((Object)"SAVE_ONLY_IF_CHANGED", (Object)"MEMORY_BUFFER"));
            }
        }
    }
}

