/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.provider.spec;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.provider.AdapterFactoryUtil;
import org.eclipse.emf.compare.provider.IItemDescriptionProvider;
import org.eclipse.emf.compare.provider.IItemStyledLabelProvider;
import org.eclipse.emf.compare.provider.MatchItemProvider;
import org.eclipse.emf.compare.provider.spec.OverlayImageProvider;
import org.eclipse.emf.compare.provider.utils.ComposedStyledString;
import org.eclipse.emf.compare.provider.utils.IStyledString;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchItemProviderSpec
extends MatchItemProvider
implements IItemStyledLabelProvider,
IItemDescriptionProvider {
    private static final Predicate<ReferenceChange> CONTAINMENT_REFERENCE_CHANGE = new Predicate<ReferenceChange>(){

        public boolean apply(ReferenceChange input) {
            return input.getReference().isContainment();
        }
    };
    private static final Function<ReferenceChange, EObject> VALUE = new Function<ReferenceChange, EObject>(){

        public EObject apply(ReferenceChange input) {
            return input.getValue();
        }
    };
    private final OverlayImageProvider overlayProvider = new OverlayImageProvider(this.getResourceLocator());

    public MatchItemProviderSpec(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public Object getImage(Object object) {
        Match match = (Match)object;
        Object ret = AdapterFactoryUtil.getImage(this.getRootAdapterFactory(), match.getLeft());
        if (ret == null) {
            ret = AdapterFactoryUtil.getImage(this.getRootAdapterFactory(), match.getRight());
        }
        if (ret == null) {
            ret = AdapterFactoryUtil.getImage(this.getRootAdapterFactory(), match.getOrigin());
        }
        if (ret == null) {
            ret = super.getImage(object);
        }
        Object matchImage = this.overlayProvider.getComposedImage(match, ret);
        ret = this.overlayImage(object, matchImage);
        return ret;
    }

    @Override
    public String getText(Object object) {
        Match match = (Match)object;
        String ret = AdapterFactoryUtil.getText(this.getRootAdapterFactory(), match.getLeft());
        if (ret == null) {
            ret = AdapterFactoryUtil.getText(this.getRootAdapterFactory(), match.getRight());
        }
        if (ret == null) {
            ret = AdapterFactoryUtil.getText(this.getRootAdapterFactory(), match.getOrigin());
        }
        if (ret == null) {
            ret = super.getText(object);
        }
        return ret;
    }

    public Collection<?> getChildren(Object object) {
        Match match = (Match)object;
        Iterable<?> filteredChildren = this.getChildrenIterable(match);
        return ImmutableList.copyOf(filteredChildren);
    }

    public Iterable<?> getChildrenIterable(Match match) {
        ImmutableSet<EObject> containementDifferenceValues = MatchItemProviderSpec.containmentReferencesValues(match);
        Predicate childrenFilter = Predicates.not((Predicate)Predicates.or((Predicate[])new Predicate[]{MatchItemProviderSpec.matchOfContainmentDiff(containementDifferenceValues), MatchItemProviderSpec.emptyMatch(), Predicates.instanceOf(ResourceAttachmentChange.class)}));
        Iterable filteredChildren = Iterables.filter((Iterable)super.getChildren((Object)match), (Predicate)childrenFilter);
        return filteredChildren;
    }

    public Iterable<?> getFilteredChildren(Match match) {
        ImmutableSet<EObject> containementDifferenceValues = MatchItemProviderSpec.containmentReferencesValues(match);
        Predicate childrenFilter = Predicates.not((Predicate)Predicates.or((Predicate[])new Predicate[]{MatchItemProviderSpec.matchOfContainmentDiff(containementDifferenceValues), this.matchWithNoChildren(), MatchItemProviderSpec.emptyMatch(), Predicates.instanceOf(ResourceAttachmentChange.class)}));
        Iterable filteredChildren = Iterables.filter((Iterable)super.getChildren((Object)match), (Predicate)childrenFilter);
        return filteredChildren;
    }

    public static ImmutableSet<EObject> containmentReferencesValues(Match match) {
        EList differences = match.getDifferences();
        Iterable containmentReferenceChanges = Iterables.filter((Iterable)Iterables.filter((Iterable)differences, ReferenceChange.class), CONTAINMENT_REFERENCE_CHANGE);
        ImmutableSet containementDifferenceValues = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)containmentReferenceChanges, VALUE));
        return containementDifferenceValues;
    }

    public static Predicate<? super Object> matchOfContainmentDiff(final ImmutableSet<? extends EObject> containementDifferenceValues) {
        return new Predicate<Object>(){

            public boolean apply(Object input) {
                Match match;
                boolean ret = false;
                if (input instanceof Match && (containementDifferenceValues.contains((Object)(match = (Match)input).getLeft()) || containementDifferenceValues.contains((Object)match.getRight()) || containementDifferenceValues.contains((Object)match.getOrigin()))) {
                    ret = true;
                }
                return ret;
            }
        };
    }

    private Predicate<? super Object> matchWithNoChildren() {
        return new Predicate<Object>(){

            public boolean apply(Object input) {
                boolean ret = false;
                if (input instanceof Match) {
                    Match match = (Match)input;
                    ret = Iterables.isEmpty(MatchItemProviderSpec.this.getFilteredChildren(match));
                }
                return ret;
            }
        };
    }

    private static Predicate<? super Object> emptyMatch() {
        return new Predicate<Object>(){

            public boolean apply(Object input) {
                if (input instanceof Match) {
                    Match match = (Match)input;
                    return match.getLeft() == null && match.getRight() == null && match.getOrigin() == null;
                }
                return false;
            }
        };
    }

    public boolean hasChildren(Object object) {
        Match match = (Match)object;
        return !Iterables.isEmpty(this.getChildrenIterable(match));
    }

    @Override
    public IStyledString.IComposedStyledString getStyledText(Object object) {
        return new ComposedStyledString(this.getText(object));
    }

    @Override
    public String getDescription(Object object) {
        return this.getText(object);
    }
}

