/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.utils;

import com.google.common.io.Closeables;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.compare.ide.EMFCompareIDEPlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResourceUtil {
    private ResourceUtil() {
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Resource loadResource(IStorage storage, ResourceSet resourceSet, Map<?, ?> options) {
        Resource existing;
        URI uri;
        String resourceName = storage.getName();
        String path = storage.getFullPath().toString();
        if (!path.endsWith(resourceName)) {
            int endIndex = path.indexOf(resourceName) + resourceName.length();
            path = path.substring(0, endIndex);
        }
        if (!(uri = URI.createURI((String)path, (boolean)true)).isPlatformResource()) {
            uri = URI.createPlatformResourceURI((String)path, (boolean)true);
        }
        if ((existing = resourceSet.getResource(uri, false)) != null) {
            return existing;
        }
        InputStream stream = null;
        Resource resource = null;
        try {
            resource = resourceSet.createResource(uri);
            stream = storage.getContents();
            resource.load(stream, options);
        }
        catch (IOException iOException) {
            if (stream == null) return resource;
            try {
                stream.close();
                return resource;
            }
            catch (IOException iOException2) {}
            return resource;
        }
        catch (CoreException coreException) {
            if (stream == null) return resource;
            try {
                stream.close();
                return resource;
            }
            catch (IOException iOException) {}
            return resource;
        }
        catch (WrappedException wrappedException) {
            if (stream == null) return resource;
            {
                catch (Throwable throwable) {
                    if (stream == null) throw throwable;
                    try {
                        stream.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                stream.close();
                return resource;
            }
            catch (IOException iOException) {}
            return resource;
        }
        if (stream == null) return resource;
        try {
            stream.close();
            return resource;
        }
        catch (IOException iOException) {}
        return resource;
    }

    /*
     * Loose catch block
     * WARNING - bad return control flow
     */
    public static boolean binaryIdentical(IStorage left, IStorage right) {
        boolean bl;
        BufferedReader rightReader;
        block12: {
            BufferedReader leftReader = null;
            rightReader = null;
            try {
                leftReader = new BufferedReader(new InputStreamReader(left.getContents()));
                rightReader = new BufferedReader(new InputStreamReader(right.getContents()));
                char[] leftBuff = new char[16384];
                char[] rightBuff = new char[16384];
                int readLeft = leftReader.read(leftBuff);
                int readRight = rightReader.read(rightBuff);
                while (readLeft > 0 && readRight > 0 && ResourceUtil.equalArrays(readLeft, readRight, leftBuff, rightBuff)) {
                    readLeft = leftReader.read(leftBuff);
                    readRight = rightReader.read(rightBuff);
                }
                bl = ResourceUtil.equalArrays(readLeft, readRight, leftBuff, rightBuff);
                if (leftReader == null) break block12;
            }
            catch (CoreException e) {
                block13: {
                    ResourceUtil.logError((Exception)((Object)e));
                    if (leftReader == null) break block13;
                    Closeables.closeQuietly((Closeable)leftReader);
                }
                if (rightReader != null) {
                    Closeables.closeQuietly(rightReader);
                }
            }
            catch (IOException e2) {
                block14: {
                    ResourceUtil.logError(e2);
                    if (leftReader == null) break block14;
                    {
                        catch (Throwable throwable) {
                            if (leftReader != null) {
                                Closeables.closeQuietly(leftReader);
                            }
                            if (rightReader != null) {
                                Closeables.closeQuietly(rightReader);
                            }
                            throw throwable;
                        }
                    }
                    Closeables.closeQuietly((Closeable)leftReader);
                }
                if (rightReader != null) {
                    Closeables.closeQuietly(rightReader);
                }
            }
            Closeables.closeQuietly((Closeable)leftReader);
        }
        if (rightReader != null) {
            Closeables.closeQuietly((Closeable)rightReader);
        }
        return bl;
        return false;
    }

    /*
     * Loose catch block
     * WARNING - bad return control flow
     */
    public static boolean binaryIdentical(IStorage left, IStorage right, IStorage origin) {
        boolean bl;
        BufferedReader originReader;
        BufferedReader rightReader;
        block16: {
            BufferedReader leftReader = null;
            rightReader = null;
            originReader = null;
            try {
                leftReader = new BufferedReader(new InputStreamReader(left.getContents()));
                rightReader = new BufferedReader(new InputStreamReader(right.getContents()));
                originReader = new BufferedReader(new InputStreamReader(origin.getContents()));
                char[] leftBuff = new char[16384];
                char[] rightBuff = new char[16384];
                char[] originBuff = new char[16384];
                int readLeft = leftReader.read(leftBuff);
                int readRight = rightReader.read(rightBuff);
                int readOrigin = originReader.read(originBuff);
                while (readLeft > 0 && readRight > 0 && readOrigin > 0 && ResourceUtil.equalArrays(readLeft, readRight, readOrigin, leftBuff, rightBuff, originBuff)) {
                    readLeft = leftReader.read(leftBuff);
                    readRight = rightReader.read(rightBuff);
                    readOrigin = originReader.read(originBuff);
                }
                bl = ResourceUtil.equalArrays(readLeft, readRight, readOrigin, leftBuff, rightBuff, originBuff);
                if (leftReader == null) break block16;
            }
            catch (CoreException e) {
                block17: {
                    ResourceUtil.logError((Exception)((Object)e));
                    if (leftReader == null) break block17;
                    Closeables.closeQuietly((Closeable)leftReader);
                }
                if (rightReader != null) {
                    Closeables.closeQuietly(rightReader);
                }
                if (originReader != null) {
                    Closeables.closeQuietly(originReader);
                }
            }
            catch (IOException e2) {
                block18: {
                    ResourceUtil.logError(e2);
                    if (leftReader == null) break block18;
                    {
                        catch (Throwable throwable) {
                            if (leftReader != null) {
                                Closeables.closeQuietly(leftReader);
                            }
                            if (rightReader != null) {
                                Closeables.closeQuietly(rightReader);
                            }
                            if (originReader != null) {
                                Closeables.closeQuietly(originReader);
                            }
                            throw throwable;
                        }
                    }
                    Closeables.closeQuietly((Closeable)leftReader);
                }
                if (rightReader != null) {
                    Closeables.closeQuietly(rightReader);
                }
                if (originReader != null) {
                    Closeables.closeQuietly(originReader);
                }
            }
            Closeables.closeQuietly((Closeable)leftReader);
        }
        if (rightReader != null) {
            Closeables.closeQuietly((Closeable)rightReader);
        }
        if (originReader != null) {
            Closeables.closeQuietly((Closeable)originReader);
        }
        return bl;
        return false;
    }

    public static URI createURIFor(IStorage storage) {
        URI uri;
        String resourceName = storage.getName();
        String path = storage.getFullPath().toString();
        if (!path.endsWith(resourceName)) {
            int endIndex = path.indexOf(resourceName) + resourceName.length();
            path = path.substring(0, endIndex);
        }
        if (!(uri = URI.createURI((String)path, (boolean)true)).isPlatformResource()) {
            uri = URI.createPlatformResourceURI((String)path, (boolean)true);
        }
        return uri;
    }

    public static void saveAllResources(ResourceSet resourceSet, Map<?, ?> options) {
        EList resources = resourceSet.getResources();
        for (Resource resource : resources) {
            if (!ResourceUtil.supportsOutput(resource)) continue;
            try {
                resource.save(options);
            }
            catch (IOException e) {
                ResourceUtil.logError(e);
            }
        }
    }

    private static boolean supportsOutput(Resource resource) {
        URI uri = resource.getURI();
        return uri.isPlatformResource() || uri.isRelative() || uri.isFile();
    }

    private static boolean equalArrays(int length1, int length2, char[] array1, char[] array2) {
        if (length1 == length2) {
            boolean result = true;
            if (array1 == array2) {
                result = true;
            } else if (array1 == null || array2 == null) {
                result = false;
            } else {
                int i = 0;
                while (i < length1 && result) {
                    result = array1[i] == array2[i];
                    ++i;
                }
            }
            return result;
        }
        return false;
    }

    private static boolean equalArrays(int length1, int length2, int length3, char[] array1, char[] array2, char[] array3) {
        if (length1 == length2 && length1 == length3) {
            boolean result = true;
            if (array1 == array2 && array1 == array3) {
                result = true;
            } else if (array1 == null || array2 == null || array3 == null) {
                result = false;
            } else {
                int i = 0;
                while (i < length1 && result) {
                    result = array1[i] == array2[i] && array1[1] == array3[i];
                    ++i;
                }
            }
            return result;
        }
        return false;
    }

    private static void logError(Exception e) {
        Status status = new Status(4, "org.eclipse.emf.compare.ide", e.getMessage(), (Throwable)e);
        EMFCompareIDEPlugin.getDefault().getLog().log((IStatus)status);
    }
}

