/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.internal.spec;

import java.util.Collections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.EMFCompareMessages;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.impl.ResourceAttachmentChangeImpl;
import org.eclipse.emf.compare.utils.DiffUtil;
import org.eclipse.emf.compare.utils.EMFCompareCopier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.xmi.XMIResource;

public class ResourceAttachmentChangeSpec
extends ResourceAttachmentChangeImpl {
    public void copyLeftToRight() {
        if (this.getState() != DifferenceState.UNRESOLVED) {
            return;
        }
        this.setState(DifferenceState.MERGED);
        if (this.getEquivalence() != null) {
            for (Diff equivalent : this.getEquivalence().getDifferences()) {
                equivalent.setState(DifferenceState.MERGED);
            }
        }
        if (this.getSource() == DifferenceSource.LEFT) {
            this.mergeRequires(false);
            switch (this.getKind()) {
                case ADD: {
                    this.addInTarget(false);
                    break;
                }
                case DELETE: {
                    this.removeFromTarget(false);
                    break;
                }
            }
        } else {
            this.mergeRequiredBy(false);
            switch (this.getKind()) {
                case ADD: {
                    this.removeFromTarget(false);
                    break;
                }
                case DELETE: {
                    this.addInTarget(false);
                    break;
                }
            }
        }
    }

    public void copyRightToLeft() {
        if (this.getState() != DifferenceState.UNRESOLVED) {
            return;
        }
        this.setState(DifferenceState.MERGED);
        if (this.getEquivalence() != null) {
            for (Diff equivalent : this.getEquivalence().getDifferences()) {
                equivalent.setState(DifferenceState.MERGED);
            }
        }
        if (this.getSource() == DifferenceSource.LEFT) {
            this.mergeRequiredBy(true);
            switch (this.getKind()) {
                case ADD: {
                    this.removeFromTarget(true);
                    break;
                }
                case DELETE: {
                    this.addInTarget(true);
                    break;
                }
            }
        } else {
            this.mergeRequires(true);
            switch (this.getKind()) {
                case ADD: {
                    this.addInTarget(true);
                    break;
                }
                case DELETE: {
                    this.removeFromTarget(true);
                    break;
                }
            }
        }
    }

    public void discard() {
        this.setState(DifferenceState.DISCARDED);
    }

    protected void mergeRequiredBy(boolean rightToLeft) {
        for (Diff dependency : this.getRequiredBy()) {
            if (rightToLeft) {
                dependency.copyRightToLeft();
                continue;
            }
            dependency.copyLeftToRight();
        }
    }

    protected void mergeRequires(boolean rightToLeft) {
        for (Diff dependency : this.getRequires()) {
            if (rightToLeft) {
                dependency.copyRightToLeft();
                continue;
            }
            dependency.copyLeftToRight();
        }
    }

    protected void addInTarget(boolean rightToLeft) {
        EObject expectedValue;
        Comparison comparison = this.getMatch().getComparison();
        Resource expectedContainer = this.findOrCreateTargetResource(rightToLeft);
        EObject sourceValue = rightToLeft ? this.getMatch().getRight() : this.getMatch().getLeft();
        Match valueMatch = this.getMatch();
        if (rightToLeft) {
            if (valueMatch.getLeft() != null) {
                expectedValue = valueMatch.getLeft();
            } else {
                expectedValue = this.createTarget(sourceValue);
                valueMatch.setLeft(expectedValue);
            }
        } else if (valueMatch.getRight() != null) {
            expectedValue = valueMatch.getRight();
        } else {
            expectedValue = this.createTarget(sourceValue);
            valueMatch.setRight(expectedValue);
        }
        URI sourceURI = EcoreUtil.getURI((EObject)sourceValue);
        if (expectedContainer.getEObject(sourceURI.fragment()) != null) {
            ((InternalEObject)expectedValue).eSetProxyURI(sourceURI);
            if (expectedContainer.getResourceSet() != null) {
                EcoreUtil.resolveAll((ResourceSet)expectedContainer.getResourceSet());
            } else {
                EcoreUtil.resolveAll((Resource)expectedContainer);
            }
            if (rightToLeft) {
                valueMatch.setLeft(expectedContainer.getEObject(sourceURI.fragment()));
            } else {
                valueMatch.setRight(expectedContainer.getEObject(sourceURI.fragment()));
            }
            return;
        }
        Resource initialResource = sourceValue.eResource();
        EList sourceList = initialResource.getContents();
        EList targetList = expectedContainer.getContents();
        int insertionIndex = DiffUtil.findInsertionIndex(comparison, sourceList, targetList, expectedValue);
        if (targetList instanceof InternalEList) {
            ((InternalEList)targetList).addUnique(insertionIndex, (Object)expectedValue);
        } else {
            targetList.add(insertionIndex, expectedValue);
        }
        if (initialResource instanceof XMIResource && expectedContainer instanceof XMIResource) {
            ((XMIResource)expectedContainer).setID(expectedValue, ((XMIResource)initialResource).getID(sourceValue));
        }
    }

    private Resource findOrCreateTargetResource(boolean rightToLeft) {
        Resource target;
        Comparison comparison = this.getMatch().getComparison();
        Resource sourceRes = rightToLeft ? this.getMatch().getRight().eResource() : this.getMatch().getLeft().eResource();
        EList<MatchResource> matchedResources = comparison.getMatchedResources();
        int size = matchedResources.size();
        MatchResource soughtMatch = this.getMatchResource(sourceRes);
        if (rightToLeft && soughtMatch.getLeft() != null) {
            target = soughtMatch.getLeft();
        } else if (!rightToLeft && soughtMatch.getRight() != null) {
            target = soughtMatch.getRight();
        } else {
            URI targetURI = this.computeTargetURI(rightToLeft);
            if (targetURI == null) {
                return null;
            }
            ResourceSet targetSet = null;
            int i = 0;
            while (i < size && targetSet == null) {
                MatchResource matchRes = (MatchResource)matchedResources.get(i);
                if (rightToLeft && matchRes.getLeft() != null) {
                    targetSet = matchRes.getLeft().getResourceSet();
                } else if (!rightToLeft && matchRes.getRight() != null) {
                    targetSet = matchRes.getRight().getResourceSet();
                }
                ++i;
            }
            if (targetSet == null) {
                throw new RuntimeException(EMFCompareMessages.getString("ResourceAttachmentChangeSpec.MissingRS", targetURI.lastSegment()));
            }
            target = targetSet.getURIConverter().exists(targetURI, Collections.emptyMap()) ? targetSet.getResource(targetURI, true) : targetSet.createResource(targetURI);
            if (rightToLeft) {
                soughtMatch.setLeft(target);
            } else {
                soughtMatch.setRight(target);
            }
        }
        return target;
    }

    protected URI computeTargetURI(boolean rightToLeft) {
        EObject targetObject;
        EObject sourceObject;
        if (rightToLeft) {
            sourceObject = this.getMatch().getRight();
            targetObject = this.getMatch().getLeft();
        } else {
            sourceObject = this.getMatch().getLeft();
            targetObject = this.getMatch().getRight();
        }
        Resource sourceResource = sourceObject.eResource();
        Resource currentResource = targetObject.eResource();
        MatchResource matchCurrent = this.getMatchResource(currentResource);
        Resource currentFromSourceSide = rightToLeft ? matchCurrent.getRight() : matchCurrent.getLeft();
        URI relativeTargetURI = sourceResource.getURI().deresolve(currentFromSourceSide.getURI());
        return relativeTargetURI.resolve(currentResource.getURI());
    }

    protected MatchResource getMatchResource(Resource resource) {
        EList<MatchResource> matchedResources = this.getMatch().getComparison().getMatchedResources();
        int size = matchedResources.size();
        MatchResource soughtMatch = null;
        int i = 0;
        while (i < size && soughtMatch == null) {
            MatchResource matchRes = (MatchResource)matchedResources.get(i);
            if (matchRes.getRight() == resource || matchRes.getLeft() == resource || matchRes.getOrigin() == resource) {
                soughtMatch = matchRes;
            }
            ++i;
        }
        if (soughtMatch == null) {
            throw new RuntimeException(EMFCompareMessages.getString("ResourceAttachmentChangeSpec.MissingMatch", resource.getURI().lastSegment()));
        }
        return soughtMatch;
    }

    protected EObject createTarget(EObject referenceObject) {
        EMFCompareCopier copier = new EMFCompareCopier();
        return copier.copy(referenceObject);
    }

    protected void removeFromTarget(boolean rightToLeft) {
        Match valueMatch = this.getMatch();
        EObject expectedValue = rightToLeft ? valueMatch.getLeft() : valueMatch.getRight();
        if (expectedValue != null) {
            Resource.Internal resource = ((InternalEObject)expectedValue).eDirectResource();
            resource.getContents().remove((Object)expectedValue);
        }
    }
}

