/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.accessor.IAccessorFactory;
import org.eclipse.emf.compare.ide.utils.AbstractRegistryEventListener;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class EMFCompareIDEUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.emf.compare.ide.ui";
    public static final String ACCESSOR_FACTORY_PPID = "accessor_factory";
    private static EMFCompareIDEUIPlugin plugin;
    private LocalResourceManager fResourceManager;
    private AbstractRegistryEventListener listener;
    private IAccessorFactory.Registry registry;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        this.registry = new IAccessorFactory.RegistryImpl();
        this.listener = new AccessorFactoryExtensionRegistryListener(PLUGIN_ID, ACCESSOR_FACTORY_PPID);
        extensionRegistry.addListener((IRegistryEventListener)this.listener, "org.eclipse.emf.compare.ide.ui.accessor_factory");
        this.listener.readRegistry(extensionRegistry);
    }

    public void stop(BundleContext context) throws Exception {
        Platform.getExtensionRegistry().removeListener((IRegistryEventListener)this.listener);
        this.registry = null;
        if (this.fResourceManager != null) {
            this.fResourceManager.dispose();
        }
        plugin = null;
        super.stop(context);
    }

    public static EMFCompareIDEUIPlugin getDefault() {
        return plugin;
    }

    public IAccessorFactory.Registry getAccessorFactoryRegistry() {
        return this.registry;
    }

    public ImageDescriptor getImageDescriptor(String path) {
        return EMFCompareIDEUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public Image getImage(ImageDescriptor descriptor) {
        ResourceManager rm = this.getResourceManager();
        return rm.createImage(descriptor);
    }

    public Image getImage(String path) {
        ImageDescriptor descriptor = EMFCompareIDEUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
        Image result = null;
        if (descriptor != null) {
            ResourceManager rm = this.getResourceManager();
            result = rm.createImage(descriptor);
        }
        return result;
    }

    public void log(Throwable e) {
        this.getLog().log((IStatus)new Status(4, PLUGIN_ID, e.getMessage(), e));
    }

    public void log(int severity, String message) {
        this.getLog().log((IStatus)new Status(severity, PLUGIN_ID, message));
    }

    private ResourceManager getResourceManager() {
        if (this.fResourceManager == null) {
            this.fResourceManager = new LocalResourceManager(JFaceResources.getResources());
        }
        return this.fResourceManager;
    }

    private class AccessorFactoryExtensionRegistryListener
    extends AbstractRegistryEventListener {
        static final String TAG_FACTORY = "factory";
        static final String ATT_CLASS = "class";
        static final String ATT_RANKING = "ranking";

        public AccessorFactoryExtensionRegistryListener(String pluginID, String extensionPointID) {
            super(pluginID, extensionPointID);
        }

        protected boolean readElement(IConfigurationElement element, AbstractRegistryEventListener.Action b) {
            if (element.getName().equals(TAG_FACTORY)) {
                if (element.getAttribute(ATT_CLASS) == null) {
                    this.logMissingAttribute(element, ATT_CLASS);
                } else if (element.getAttribute(ATT_RANKING) == null) {
                    String rankingStr = element.getAttribute(ATT_RANKING);
                    try {
                        Integer.parseInt(rankingStr);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.logError(element, "Attribute 'ranking' is malformed, should be an integer.");
                    }
                    this.logMissingAttribute(element, ATT_RANKING);
                } else {
                    switch (b) {
                        case ADD: {
                            try {
                                IAccessorFactory factory = (IAccessorFactory)element.createExecutableExtension(ATT_CLASS);
                                factory.setRanking(Integer.parseInt(element.getAttribute(ATT_RANKING)));
                                IAccessorFactory previous = EMFCompareIDEUIPlugin.this.registry.add(factory);
                                if (previous == null) break;
                                EMFCompareIDEUIPlugin.this.log(2, "The factory '" + factory.getClass().getName() + "' is registered twice.");
                            }
                            catch (CoreException e) {
                                this.logError(element, e.getMessage());
                            }
                            break;
                        }
                        case REMOVE: {
                            EMFCompareIDEUIPlugin.this.registry.remove(element.getAttribute(ATT_CLASS));
                        }
                    }
                    return true;
                }
            }
            return false;
        }

        protected void logError(IConfigurationElement element, String string) {
            EMFCompareIDEUIPlugin.this.log(4, string);
        }
    }
}

