/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.mergeviewer;

import org.eclipse.emf.compare.rcp.ui.mergeviewer.IMergeViewer;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.accessor.IStructuralFeatureAccessor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class MergeViewerInfoViewer
extends ContentViewer {
    private final IMergeViewer.MergeViewerSide fSide;
    private final Composite fControl;
    private final Label fEObjectIcon;
    private final Label fEObjectLabel;
    private final Label fFeatureIcon;
    private final Label fFeatureLabel;
    private ISelection fSelection;
    private Object fInput;

    public MergeViewerInfoViewer(Composite parent, IMergeViewer.MergeViewerSide side) {
        this.fControl = new Composite(parent, 2048);
        this.fSide = side;
        this.fControl.setBackground(parent.getDisplay().getSystemColor(25));
        GridLayout layout = new GridLayout(3, false);
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        layout.marginLeft = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginBottom = 0;
        this.fControl.setLayout((Layout)layout);
        Composite eObjectComposite = new Composite(this.fControl, 0);
        GridLayout eObjectCompositelayout = new GridLayout(2, false);
        eObjectCompositelayout.verticalSpacing = 0;
        eObjectCompositelayout.horizontalSpacing = 0;
        eObjectCompositelayout.marginLeft = 0;
        eObjectCompositelayout.marginHeight = 0;
        eObjectCompositelayout.marginWidth = 0;
        eObjectCompositelayout.marginBottom = 0;
        eObjectComposite.setLayout((Layout)eObjectCompositelayout);
        this.fEObjectIcon = new Label(eObjectComposite, 0);
        this.fEObjectIcon.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.fEObjectLabel = new Label(eObjectComposite, 0);
        this.fEObjectLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        eObjectComposite.setLayoutData((Object)new GridData(4, 0x1000000, false, true, 3, 1));
        Label lblIn = new Label(this.fControl, 0);
        lblIn.setText("    ");
        this.fFeatureIcon = new Label(this.fControl, 0);
        this.fFeatureIcon.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.fFeatureLabel = new Label(this.fControl, 0);
        this.fFeatureLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.hookControl((Control)this.fControl);
    }

    public Control getControl() {
        return this.fControl;
    }

    protected void inputChanged(Object input, Object oldInput) {
        this.fInput = input;
        this.fControl.setRedraw(false);
        try {
            this.refresh();
        }
        finally {
            this.fControl.setRedraw(true);
        }
    }

    public ISelection getSelection() {
        return this.fSelection;
    }

    public void refresh() {
        if (this.fInput instanceof IStructuralFeatureAccessor) {
            IStructuralFeatureAccessor featureAccessor = (IStructuralFeatureAccessor)this.fInput;
            EObject eObject = featureAccessor.getEObject(this.fSide);
            if (eObject == null) {
                if (this.fSide != IMergeViewer.MergeViewerSide.ANCESTOR) {
                    eObject = featureAccessor.getEObject(IMergeViewer.MergeViewerSide.ANCESTOR);
                    if (eObject == null) {
                        eObject = featureAccessor.getEObject(this.fSide.opposite());
                    }
                } else {
                    eObject = featureAccessor.getEObject(IMergeViewer.MergeViewerSide.LEFT);
                    if (eObject == null) {
                        eObject = featureAccessor.getEObject(IMergeViewer.MergeViewerSide.RIGHT);
                    }
                }
            }
            EStructuralFeature structuralFeature = featureAccessor.getStructuralFeature();
            if (this.getLabelProvider() instanceof ILabelProvider) {
                ILabelProvider labelProvider = (ILabelProvider)this.getLabelProvider();
                this.fFeatureIcon.setImage(labelProvider.getImage((Object)structuralFeature));
                this.fFeatureLabel.setText(labelProvider.getText((Object)structuralFeature));
                this.fEObjectIcon.setImage(labelProvider.getImage((Object)eObject));
                this.fEObjectLabel.setText(labelProvider.getText((Object)eObject));
            }
            this.fControl.layout(true);
        }
    }

    public void setSelection(ISelection selection, boolean reveal) {
        this.fSelection = selection;
    }
}

