/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer;

import java.lang.reflect.InvocationTargetException;
import java.util.EventObject;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareViewerSwitchingPane;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffTreeViewer;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.ICompareInputChangeListener;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ide.EMFCompareIDE;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.internal.actions.filter.DifferenceFilter;
import org.eclipse.emf.compare.ide.ui.internal.actions.filter.FilterActionMenu;
import org.eclipse.emf.compare.ide.ui.internal.actions.group.DifferenceGrouper;
import org.eclipse.emf.compare.ide.ui.internal.actions.group.GroupActionMenu;
import org.eclipse.emf.compare.ide.ui.internal.actions.save.SaveComparisonModelAction;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util.CompareConfigurationExtension;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.DiffNodeComparer;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.EMFCompareStructureMergeViewerContentProvider;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.EMFCompareStructureMergeViewerLabelProvider;
import org.eclipse.emf.compare.ide.ui.internal.util.EMFCompareEditingDomain;
import org.eclipse.emf.compare.ide.ui.logical.EMFSynchronizationModel;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class EMFCompareStructureMergeViewer
extends DiffTreeViewer
implements CommandStackListener {
    private final ICompareInputChangeListener fCompareInputChangeListener;
    private final ComposedAdapterFactory fAdapterFactory;
    private final CompareViewerSwitchingPane fParent;
    private Object fRoot;
    private DifferenceFilter differenceFilter;
    private DifferenceGrouper differenceGrouper;
    private IRunnableWithProgress inputChangedTask = new IRunnableWithProgress(){

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask("Computing Structure Differences", 100);
            EMFCompareStructureMergeViewer.this.compareInputChanged((ICompareInput)EMFCompareStructureMergeViewer.this.getInput(), (IProgressMonitor)new SubProgressMonitor(monitor, 100));
            monitor.done();
        }
    };

    public EMFCompareStructureMergeViewer(Composite parent, CompareConfiguration configuration) {
        super(parent, configuration);
        this.fAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.fAdapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        this.fAdapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        boolean leftIsLocal = CompareConfigurationExtension.getBoolean(configuration, "LEFT_IS_LOCAL", false);
        this.setLabelProvider((IBaseLabelProvider)new EMFCompareStructureMergeViewerLabelProvider((AdapterFactory)this.fAdapterFactory, (Viewer)this, leftIsLocal));
        this.setContentProvider((IContentProvider)new EMFCompareStructureMergeViewerContentProvider((AdapterFactory)this.fAdapterFactory, this.differenceGrouper));
        this.fParent = parent instanceof CompareViewerSwitchingPane ? (CompareViewerSwitchingPane)parent : null;
        this.fCompareInputChangeListener = new ICompareInputChangeListener(){

            public void compareInputChanged(ICompareInput input) {
                EMFCompareStructureMergeViewer.this.compareInputChanged(input);
            }
        };
        this.setComparer(new DiffNodeComparer(super.getComparer()));
    }

    void compareInputChanged(ICompareInput input) {
        if (input == null) {
            this.compareInputChanged(null, (IProgressMonitor)new NullProgressMonitor());
            return;
        }
        CompareConfiguration cc = this.getCompareConfiguration();
        if (cc != null) {
            BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                public void run() {
                    try {
                        EMFCompareStructureMergeViewer.this.inputChangedTask.run((IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (InvocationTargetException e) {
                        EMFCompareIDEUIPlugin.getDefault().log(e.getTargetException());
                    }
                    catch (InterruptedException interruptedException) {}
                }
            });
        }
    }

    protected Object getRoot() {
        return this.fRoot;
    }

    void compareInputChanged(ICompareInput input, IProgressMonitor monitor) {
        Object previousResult = this.getCompareConfiguration().getProperty("org.eclipse.emf.compare.ide.ui.COMPARE.RESULT");
        if (previousResult instanceof Comparison) {
            this.compareInputChanged((Comparison)previousResult);
        } else if (input != null) {
            ITypedElement left = input.getLeft();
            ITypedElement right = input.getRight();
            ITypedElement origin = input.getAncestor();
            EMFSynchronizationModel syncModel = EMFSynchronizationModel.createSynchronizationModel(left, right, origin);
            syncModel.minimize();
            CompareConfiguration config = this.getCompareConfiguration();
            if (!syncModel.isLeftEditable()) {
                config.setLeftEditable(false);
            }
            if (!syncModel.isRightEditable()) {
                config.setRightEditable(false);
            }
            IComparisonScope scope = syncModel.createMinimizedScope();
            Comparison compareResult = EMFCompareIDE.builder().build().compare(scope, BasicMonitor.toMonitor((IProgressMonitor)monitor));
            ResourceSet leftResourceSet = (ResourceSet)scope.getLeft();
            ResourceSet rightResourceSet = (ResourceSet)scope.getRight();
            ResourceSet originResourceSet = (ResourceSet)scope.getOrigin();
            EMFCompareEditingDomain editingDomain = new EMFCompareEditingDomain(compareResult, (Notifier)leftResourceSet, (Notifier)rightResourceSet, (Notifier)originResourceSet);
            this.getCompareConfiguration().setProperty("org.eclipse.emf.compare.ide.ui.EDITING_DOMAIN", (Object)editingDomain);
            editingDomain.getCommandStack().addCommandStackListener((CommandStackListener)this);
            this.compareInputChanged(compareResult);
        } else {
            this.fRoot = null;
        }
    }

    private static void unload(ResourceSet resourceSet) {
        if (resourceSet != null) {
            for (Resource resource : resourceSet.getResources()) {
                resource.unload();
            }
            resourceSet.getResources().clear();
        }
    }

    private static ResourceSet getResourceSet(EObject eObject) {
        Resource eResource;
        if (eObject != null && (eResource = eObject.eResource()) != null) {
            return eResource.getResourceSet();
        }
        return null;
    }

    void compareInputChanged(final Comparison comparison) {
        this.getCompareConfiguration().setProperty("org.eclipse.emf.compare.ide.ui.COMPARE.RESULT", (Object)comparison);
        this.fRoot = this.fAdapterFactory.adapt((Notifier)comparison, IDiffElement.class);
        this.getCompareConfiguration().getContainer().runAsynchronously(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                String message = null;
                if (comparison.getDifferences().isEmpty()) {
                    message = "No Differences";
                }
                if (Display.getCurrent() != null) {
                    EMFCompareStructureMergeViewer.this.refreshAfterDiff(message, EMFCompareStructureMergeViewer.this.fRoot);
                } else {
                    final String theMessage = message;
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            EMFCompareStructureMergeViewer.this.refreshAfterDiff(theMessage, EMFCompareStructureMergeViewer.this.fRoot);
                        }
                    });
                }
            }
        });
    }

    private void refreshAfterDiff(String message, Object root) {
        if (this.getControl().isDisposed()) {
            return;
        }
        if (this.fParent != null) {
            this.fParent.setTitleArgument(message);
        }
        this.refresh(root);
    }

    public void setComparer(IElementComparer comparer) {
        super.setComparer((IElementComparer)new DiffNodeComparer(comparer));
    }

    protected void createToolItems(ToolBarManager toolbarManager) {
        super.createToolItems(toolbarManager);
        toolbarManager.add((IAction)new SaveComparisonModelAction(this.getCompareConfiguration()));
        toolbarManager.add((IAction)new GroupActionMenu(this.getDifferenceGrouper()));
        toolbarManager.add((IAction)new FilterActionMenu(this.getDifferenceFilter()));
    }

    protected DifferenceFilter getDifferenceFilter() {
        if (this.differenceFilter == null) {
            this.differenceFilter = new DifferenceFilter();
            this.differenceFilter.install((TreeViewer)this);
        }
        return this.differenceFilter;
    }

    protected DifferenceGrouper getDifferenceGrouper() {
        if (this.differenceGrouper == null) {
            this.differenceGrouper = new DifferenceGrouper();
            this.differenceGrouper.install((TreeViewer)this);
        }
        return this.differenceGrouper;
    }

    protected void inputChanged(Object input, Object oldInput) {
        if (oldInput instanceof ICompareInput) {
            ICompareInput old = (ICompareInput)oldInput;
            old.removeCompareInputChangeListener(this.fCompareInputChangeListener);
        }
        if (input instanceof ICompareInput) {
            ICompareInput ci = (ICompareInput)input;
            ci.addCompareInputChangeListener(this.fCompareInputChangeListener);
            this.compareInputChanged(ci);
            if (input != oldInput) {
                this.initialSelection();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void handleDispose(DisposeEvent event) {
        block7: {
            leftResourceSet = null;
            rightResourceSet = null;
            originResourceSet = null;
            if (this.fRoot == null) break block7;
            comparison = (Comparison)((Adapter)this.fRoot).getTarget();
            matchIt = comparison.getMatches().iterator();
            if (!comparison.isThreeWay()) ** GOTO lbl23
            while (matchIt.hasNext() && (leftResourceSet == null || rightResourceSet == null || originResourceSet == null)) {
                match = (Match)matchIt.next();
                if (leftResourceSet == null) {
                    leftResourceSet = EMFCompareStructureMergeViewer.getResourceSet(match.getLeft());
                }
                if (rightResourceSet == null) {
                    rightResourceSet = EMFCompareStructureMergeViewer.getResourceSet(match.getRight());
                }
                if (originResourceSet != null) continue;
                originResourceSet = EMFCompareStructureMergeViewer.getResourceSet(match.getOrigin());
            }
            break block7;
lbl-1000:
            // 1 sources

            {
                match = (Match)matchIt.next();
                if (leftResourceSet == null) {
                    leftResourceSet = EMFCompareStructureMergeViewer.getResourceSet(match.getLeft());
                }
                if (rightResourceSet != null) continue;
                rightResourceSet = EMFCompareStructureMergeViewer.getResourceSet(match.getRight());
lbl23:
                // 3 sources

                ** while (matchIt.hasNext() && (leftResourceSet == null || rightResourceSet == null))
            }
        }
        EMFCompareStructureMergeViewer.unload(leftResourceSet);
        EMFCompareStructureMergeViewer.unload(rightResourceSet);
        EMFCompareStructureMergeViewer.unload(originResourceSet);
        input = this.getInput();
        if (input instanceof ICompareInput) {
            ci = (ICompareInput)input;
            ci.removeCompareInputChangeListener(this.fCompareInputChangeListener);
        }
        this.compareInputChanged((ICompareInput)null);
        editingDomain = (EMFCompareEditingDomain)this.getCompareConfiguration().getProperty("org.eclipse.emf.compare.ide.ui.EDITING_DOMAIN");
        if (editingDomain != null) {
            editingDomain.getCommandStack().removeCommandStackListener((CommandStackListener)this);
        }
        super.handleDispose(event);
    }

    public void commandStackChanged(EventObject event) {
        this.refresh();
    }
}

