/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match.eobject;

import com.google.common.base.Function;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.ImmutableList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URIDistance
implements Function<EObject, String> {
    private Cache<EObject, String> locationCache = CacheBuilder.newBuilder().maximumSize(10000).build(CacheLoader.from((Function)this));

    public int proximity(EObject a, EObject b) {
        String aPath = (String)this.locationCache.getUnchecked((Object)a);
        String bPath = (String)this.locationCache.getUnchecked((Object)b);
        return this.proximity(aPath, bPath);
    }

    public int proximity(String aPath, String bPath) {
        if (aPath.equals(bPath)) {
            return 0;
        }
        return 10;
    }

    protected void featureMapLocation(ImmutableList.Builder<String> builder, EObject cur, EObject container, EStructuralFeature feat) {
        FeatureMap featureMap = (FeatureMap)container.eGet(feat, false);
        int i = 0;
        int size = featureMap.size();
        while (i < size) {
            EStructuralFeature entryFeature;
            if (featureMap.getValue(i) == cur && (entryFeature = featureMap.getEStructuralFeature(i)) instanceof EReference && ((EReference)entryFeature).isContainment()) {
                builder.add((Object)feat.getName());
                builder.add((Object)Integer.valueOf(i).toString());
            }
            ++i;
        }
    }

    public String apply(EObject input) {
        EObject cur = input;
        String result = "";
        EObject container = input.eContainer();
        if (container != null) {
            EStructuralFeature feat = cur.eContainingFeature();
            if (feat instanceof EAttribute) {
                result = this.featureMapLocation(cur, container, feat);
            } else if (feat != null) {
                if (feat.isMany()) {
                    EList eList = (EList)container.eGet(feat, false);
                    int index = eList.indexOf((Object)cur);
                    result = String.valueOf(feat.getName()) + Integer.valueOf(index).toString();
                } else {
                    result = String.valueOf(feat.getName()) + "0";
                }
            }
        } else {
            result = "0";
        }
        if (input.eContainer() != null) {
            return String.valueOf(result) + (String)this.locationCache.getUnchecked((Object)input.eContainer());
        }
        return result;
    }

    protected String featureMapLocation(EObject cur, EObject container, EStructuralFeature feat) {
        FeatureMap featureMap = (FeatureMap)container.eGet(feat, false);
        int i = 0;
        int size = featureMap.size();
        while (i < size) {
            EStructuralFeature entryFeature;
            if (featureMap.getValue(i) == cur && (entryFeature = featureMap.getEStructuralFeature(i)) instanceof EReference && ((EReference)entryFeature).isContainment()) {
                return String.valueOf(feat.getName()) + Integer.valueOf(i).toString();
            }
            ++i;
        }
        throw new RuntimeException();
    }
}

