/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.tests.qvt.oml.ui.editor;

import java.util.List;
import junit.framework.AssertionFailedError;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.QvtEditor;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks.QvtHyperlinkDetector;
import org.eclipse.m2m.internal.tests.qvt.oml.ui.editor.AbstractTestQvtEditorSupport;
import org.eclipse.m2m.internal.tests.qvt.oml.ui.editor.HyperLinkHelper;
import org.eclipse.m2m.tests.qvt.oml.util.SourceAnnotationReader;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;

public class TestEditorHyperLinks
extends AbstractTestQvtEditorSupport {
    private static final int TEST_LINK_COUNT = 38;
    private static final String METAMODEL_BROWSER_VIEW_ID = "org.eclipse.m2m.internal.qvt.oml.common.views.MetamodelBrowserView";

    public TestEditorHyperLinks(String test) {
        super(test);
    }

    public void testhyperlinks() throws Exception {
        this.doTest(38);
    }

    private void doRunTestChecks(int[] testResult) {
        List<SourceAnnotationReader.AnnotationData> sourceAnnotations = this.readSourceAnnotations((ITextEditor)this.fEditor);
        HyperLinkHelper hyperLinkBindings = new HyperLinkHelper(sourceAnnotations);
        for (HyperLinkHelper.SourceHyperLink sourceHLink : hyperLinkBindings.getHyperLinks()) {
            Region pointerReg = new Region(sourceHLink.link.getAnnotatedRegion().getOffset(), 0);
            IHyperlink[] hyperlinks = new QvtHyperlinkDetector(this.fEditor.getQVTDocumentProvider()).detectHyperlinks((ITextViewer)this.fEditor.getEditorSourceViewer(), (IRegion)pointerReg, false);
            TestEditorHyperLinks.assertNotNull((String)this.message("No hyperlink detected for", sourceHLink), (Object)hyperlinks);
            TestEditorHyperLinks.assertEquals((int)1, (int)hyperlinks.length);
            IHyperlink hlink = hyperlinks[0];
            Region hlinkRegion = new Region(sourceHLink.link.getAnnotatedRegion().getOffset(), sourceHLink.link.getAnnotatedRegion().getLength());
            TestEditorHyperLinks.assertEquals((String)sourceHLink.toString(), (int)hlink.getHyperlinkRegion().getOffset(), (int)hlinkRegion.getOffset());
            TestEditorHyperLinks.assertEquals((String)sourceHLink.toString(), (int)hlink.getHyperlinkRegion().getLength(), (int)hlinkRegion.getLength());
            ITextHover hover = this.fEditor.getQvtConfiguration().getTextHover(this.fEditor.getEditorSourceViewer(), null);
            TestEditorHyperLinks.assertNotNull((String)"Text hover must be available", (Object)hover);
            String hoverText = (String)((ITextHoverExtension2)hover).getHoverInfo2((ITextViewer)this.fEditor.getEditorSourceViewer(), (IRegion)pointerReg);
            TestEditorHyperLinks.assertTrue((String)this.message("No hover for hyperlink", sourceHLink), (hoverText != null && hoverText.trim().length() > 0 ? 1 : 0) != 0);
            hlink.open();
            if (sourceHLink.targetModule != null) {
                QvtEditor mainEditor = this.fEditor;
                IFile mainSourceFile = TestEditorHyperLinks.getSourceFile(mainEditor);
                IFile targetFile = (IFile)mainSourceFile.getParent().findMember(String.valueOf(sourceHLink.targetModule) + ".qvto");
                QvtEditor expectedActiveEditor = TestEditorHyperLinks.openInEditor(targetFile);
                TestEditorHyperLinks.assertSame((Object)expectedActiveEditor, (Object)this.getActiveEditor());
                TestEditorHyperLinks.assertNotSame((Object)expectedActiveEditor, (Object)mainEditor);
                List<SourceAnnotationReader.AnnotationData> targetAnnotations = this.readSourceAnnotations((ITextEditor)expectedActiveEditor);
                SourceAnnotationReader.AnnotationData target = new HyperLinkHelper(targetAnnotations).getTargetRegion(sourceHLink.link.getAttrValue("ref"));
                Point targetPost = expectedActiveEditor.getEditorSourceViewer().getSelectedRange();
                int targetOffset = target.getAnnotatedRegion().getOffset();
                int targetRangeLen = target.getAnnotatedRegion().getLength();
                TestEditorHyperLinks.assertEquals((String)sourceHLink.toString(), (int)targetPost.x, (int)targetOffset);
                TestEditorHyperLinks.assertEquals((String)sourceHLink.toString(), (int)targetPost.y, (int)targetRangeLen);
                expectedActiveEditor.close(false);
                testResult[0] = testResult[0] + 1;
                continue;
            }
            if (sourceHLink.targeRegion != null) {
                Point targetPost = this.fEditor.getEditorSourceViewer().getSelectedRange();
                int targetOffset = sourceHLink.targeRegion.getOffset();
                int targetRangeLen = sourceHLink.targeRegion.getLength();
                TestEditorHyperLinks.assertEquals((String)this.message("Link failed:", sourceHLink), (int)targetPost.x, (int)targetOffset);
                TestEditorHyperLinks.assertEquals((String)sourceHLink.toString(), (int)targetPost.y, (int)targetRangeLen);
                testResult[0] = testResult[0] + 1;
                continue;
            }
            if (sourceHLink.targetElemenUri == null) continue;
            EModelElement targetElement = this.findResolvedTargetMetamodelElement();
            TestEditorHyperLinks.assertNotNull((String)this.message("Navigated element must be selected", sourceHLink), (Object)targetElement);
            URI resolvedUri = EcoreUtil.getURI((EObject)targetElement);
            TestEditorHyperLinks.assertNotNull((String)this.message("Element of expected URI must be found", sourceHLink), (Object)sourceHLink.targetElemenUri.equals(resolvedUri));
            testResult[0] = testResult[0] + 1;
        }
    }

    private void doTest(int expectedHyperLinkCount) throws AssertionFailedError {
        final int[] testResult = new int[1];
        final Throwable[] testError = new Throwable[1];
        Display.getCurrent().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    TestEditorHyperLinks.this.doRunTestChecks(testResult);
                }
                catch (Throwable e) {
                    testError[0] = e;
                }
            }
        });
        if (testError[0] != null) {
            Throwable t = testError[0];
            if (t instanceof AssertionFailedError) {
                throw (AssertionFailedError)t;
            }
            t.printStackTrace();
            TestEditorHyperLinks.fail((String)t.toString());
        }
        TestEditorHyperLinks.assertTrue((String)"Not all hyper links have been resolved succesfully", (testResult[0] >= expectedHyperLinkCount ? 1 : 0) != 0);
    }

    private EModelElement findResolvedTargetMetamodelElement() {
        IViewPart view = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(METAMODEL_BROWSER_VIEW_ID);
        TestEditorHyperLinks.assertNotNull((Object)view);
        TestEditorHyperLinks.assertFalse((boolean)view.getViewSite().getSelectionProvider().getSelection().isEmpty());
        ISelection sel = view.getViewSite().getSelectionProvider().getSelection();
        if (sel instanceof IStructuredSelection) {
            IStructuredSelection structSel = (IStructuredSelection)sel;
            Object elementHolder = structSel.getFirstElement();
            TestEditorHyperLinks.assertTrue((String)"Must be IAdaptable element", (boolean)(elementHolder instanceof IAdaptable));
            IAdaptable adaptable = (IAdaptable)elementHolder;
            return (EModelElement)adaptable.getAdapter(EModelElement.class);
        }
        return null;
    }

    private String message(String message, HyperLinkHelper.SourceHyperLink link) {
        return String.valueOf(message) + " - " + link.toString();
    }
}

