/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.am3.ui.view;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.am3.core.AM3CorePlugin;
import org.eclipse.am3.ui.action.ActionANTAction;
import org.eclipse.am3.ui.action.ActionANTTransformation;
import org.eclipse.am3.ui.action.ActionANTTransformationBasedOnRelation;
import org.eclipse.am3.ui.action.ActionATLExtractor;
import org.eclipse.am3.ui.action.ActionEBNFExtractor;
import org.eclipse.am3.ui.action.ActionEBNFInjector;
import org.eclipse.am3.ui.action.ActionXMLExtractor;
import org.eclipse.am3.ui.action.ActionXMLInjector;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.m2m.atl.engine.AtlModelHandler;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMCollection;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModelElement;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclAny;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMSequence;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMString;
import org.eclipse.m2m.atl.ocl.core.OclHelper;
import org.eclipse.ui.views.navigator.ResourceNavigator;

public class ResourceNavigatorAM3
extends ResourceNavigator {
    AtlModelHandler amh = AtlModelHandler.getDefault((String)"EMF");
    private Map models = new HashMap();
    private OclHelper transformationsByExtension = new OclHelper("AM3!ANTTransformation.allInstances()->select(e | e.context.antParameterType = #extension and e.context.typeValue = extension)", Arrays.asList("extension"));
    private OclHelper transformationsBasedOnRelation = new OclHelper("AM3!ANTTransformationBasedOnRelation.allInstances()", Collections.EMPTY_LIST);
    private OclHelper relationExisting = new OclHelper("relation.allInstances()->select(e | e.relationEnds->exists(i | i.artifact.uri = uri))->first()", Arrays.asList("relation", "uri"));

    protected void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
        Object objectSelected = selection.getFirstElement();
        if (objectSelected instanceof IFile) {
            IFile fileSelected = (IFile)objectSelected;
            this.load(fileSelected.getFileExtension().toLowerCase(), fileSelected, menu);
        }
    }

    private void load(String extension, IFile fileSelected, IMenuManager menu) {
        String mmUri;
        EObject currentMetamodel;
        Iterator it2;
        Set metamodels;
        EObject currentExtractor;
        Set extractors;
        Iterator it;
        String fileExtension2 = fileSelected.getFileExtension();
        String fileUri = fileSelected.getFullPath().toString();
        try {
            ASMString nameTransformation;
            ASMModelElement antTransformation;
            this.models.put("AM3", AM3CorePlugin.getDefault().getHandler().getAsmModelAM3());
            this.models.put("mgm", AM3CorePlugin.getDefault().getHandler().getAsmModelMegamodel());
            ASMOclAny cls = new OclHelper("AM3!ANTAction.allInstances()->select(e | e.extension = '" + fileExtension2 + "')", Collections.EMPTY_LIST).eval(Collections.EMPTY_LIST, this.models);
            it = ((ASMSequence)cls).iterator();
            while (it.hasNext()) {
                antTransformation = (ASMModelElement)it.next();
                nameTransformation = (ASMString)antTransformation.get(null, "name");
                menu.add((IAction)new ActionANTAction(nameTransformation.getSymbol(), antTransformation, fileUri));
            }
            cls = this.transformationsByExtension.eval(Arrays.asList(new ASMString(fileExtension2)), this.models);
            it = ((ASMSequence)cls).iterator();
            while (it.hasNext()) {
                antTransformation = (ASMModelElement)it.next();
                nameTransformation = (ASMString)antTransformation.get(null, "name");
                menu.add((IAction)new ActionANTTransformation(nameTransformation.getSymbol(), antTransformation, fileUri));
            }
            cls = this.transformationsBasedOnRelation.eval(Collections.EMPTY_LIST, this.models);
            it = ((ASMCollection)cls).iterator();
            while (it.hasNext()) {
                antTransformation = (ASMModelElement)it.next();
                nameTransformation = (ASMString)antTransformation.get(null, "name");
                ASMString relationName = (ASMString)antTransformation.get(null, "relationName");
                ASMModelElement relation = AM3CorePlugin.getDefault().getHandler().getAsmModelAM3().findModelElement(relationName.getSymbol());
                ASMOclAny relationWithCurrentFile = this.relationExisting.eval(Arrays.asList(relation, new ASMString(fileUri)), this.models);
                if (!(relationWithCurrentFile instanceof ASMModelElement)) continue;
                menu.add((IAction)new ActionANTTransformationBasedOnRelation(nameTransformation.getSymbol(), antTransformation, (ASMModelElement)relationWithCurrentFile, fileUri));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (extension.equals("ecore")) {
            extractors = AM3CorePlugin.getDefault().getHandler().getElementsBySupertype("Extractor");
            it = extractors.iterator();
            while (it.hasNext()) {
                currentExtractor = (EObject)it.next();
                metamodels = AM3CorePlugin.getDefault().getHandler().getElementsByType("Metamodel");
                it2 = metamodels.iterator();
                while (it2.hasNext()) {
                    currentMetamodel = (EObject)it2.next();
                    mmUri = (String)AM3CorePlugin.getDefault().getHandler().get(currentMetamodel, "uri");
                    String fileExtension = "";
                    StringTokenizer st = new StringTokenizer(mmUri, ".");
                    while (st.hasMoreTokens()) {
                        fileExtension = st.nextToken();
                    }
                    if (!AM3CorePlugin.getDefault().getHandler().get(currentExtractor, "name").equals(AM3CorePlugin.getDefault().getHandler().get(currentMetamodel, "name")) || fileExtension.equals("xmi")) continue;
                    menu.add((IContributionItem)new Separator("settings"));
                    String mmName = (String)AM3CorePlugin.getDefault().getHandler().get(currentExtractor, "name");
                    String actionName = "Extract " + mmName + " model to " + mmName + " file";
                    if (currentExtractor.eClass().getName().equals("ATLExtractor")) {
                        menu.add((IAction)new ActionATLExtractor(actionName, fileSelected, currentExtractor, currentMetamodel));
                        continue;
                    }
                    if (currentExtractor.eClass().getName().equals("XMLExtractor")) {
                        menu.add((IAction)new ActionXMLExtractor(actionName, fileSelected, currentMetamodel));
                        continue;
                    }
                    if (!currentExtractor.eClass().getName().equals("EBNFExtractor")) continue;
                    Set tcss = AM3CorePlugin.getDefault().getHandler().getElementsByType("TCS");
                    Iterator it3 = tcss.iterator();
                    while (it3.hasNext()) {
                        EObject currentTCS = (EObject)it3.next();
                        if (!AM3CorePlugin.getDefault().getHandler().get(currentTCS, "name").equals(mmName)) continue;
                        menu.add((IAction)new ActionEBNFExtractor(actionName, fileSelected, currentMetamodel, currentExtractor, currentTCS));
                    }
                }
            }
        } else if (extension.equals("xmi")) {
            extractors = AM3CorePlugin.getDefault().getHandler().getElementsBySupertype("Extractor");
            it = extractors.iterator();
            while (it.hasNext()) {
                currentExtractor = (EObject)it.next();
                metamodels = AM3CorePlugin.getDefault().getHandler().getElementsByType("Metamodel");
                it2 = metamodels.iterator();
                while (it2.hasNext()) {
                    currentMetamodel = (EObject)it2.next();
                    mmUri = (String)AM3CorePlugin.getDefault().getHandler().get(currentMetamodel, "uri");
                    String fileExtension = "";
                    StringTokenizer st = new StringTokenizer(mmUri, ".");
                    while (st.hasMoreTokens()) {
                        fileExtension = st.nextToken();
                    }
                    if (!AM3CorePlugin.getDefault().getHandler().get(currentExtractor, "name").equals(AM3CorePlugin.getDefault().getHandler().get(currentMetamodel, "name")) || !fileExtension.equals("xmi")) continue;
                    menu.add((IContributionItem)new Separator("settings"));
                    String mmName = (String)AM3CorePlugin.getDefault().getHandler().get(currentExtractor, "name");
                    String actionName = "Extract " + mmName + " model to " + mmName + " file";
                    if (currentExtractor.eClass().getName().equals("EBNFExtractor")) {
                        Set tcss = AM3CorePlugin.getDefault().getHandler().getElementsByType("TCS");
                        Iterator it3 = tcss.iterator();
                        while (it3.hasNext()) {
                            EObject currentTCS = (EObject)it3.next();
                            if (!AM3CorePlugin.getDefault().getHandler().get(currentTCS, "name").equals(mmName)) continue;
                            menu.add((IAction)new ActionEBNFExtractor(actionName, fileSelected, currentMetamodel, currentExtractor, currentTCS));
                        }
                        continue;
                    }
                    if (!currentExtractor.eClass().getName().equals("XMLExtractor")) continue;
                    menu.add((IAction)new ActionXMLExtractor(actionName, fileSelected, currentMetamodel));
                }
            }
        } else {
            Set injectors = AM3CorePlugin.getDefault().getHandler().getElementsBySupertype("Injector");
            it = injectors.iterator();
            while (it.hasNext()) {
                EObject currentInjector = (EObject)it.next();
                metamodels = AM3CorePlugin.getDefault().getHandler().getElementsByType("Metamodel");
                it2 = metamodels.iterator();
                while (it2.hasNext()) {
                    String actionName;
                    String mmName;
                    currentMetamodel = (EObject)it2.next();
                    if (!AM3CorePlugin.getDefault().getHandler().get(currentInjector, "name").equals(AM3CorePlugin.getDefault().getHandler().get(currentMetamodel, "name"))) continue;
                    if (currentInjector.eClass().getName().equals("XMLInjector") && extension.equals("xml")) {
                        mmUri = (String)AM3CorePlugin.getDefault().getHandler().get(currentMetamodel, "uri");
                        if (mmUri.substring(mmUri.length() - 5, mmUri.length()).equals("ecore")) {
                            menu.add((IContributionItem)new Separator("settings"));
                            mmName = (String)AM3CorePlugin.getDefault().getHandler().get(currentInjector, "name");
                            actionName = "Inject " + mmName + " file to " + mmName + " model (Ecore based)";
                            menu.add((IAction)new ActionXMLInjector(actionName, fileSelected, currentMetamodel, "EMF"));
                            continue;
                        }
                        if (!mmUri.substring(mmUri.length() - 3, mmUri.length()).equals("xmi")) continue;
                        menu.add((IContributionItem)new Separator("settings"));
                        mmName = (String)AM3CorePlugin.getDefault().getHandler().get(currentInjector, "name");
                        actionName = "Inject " + mmName + " file to " + mmName + " model (MOF1.4 based)";
                        menu.add((IAction)new ActionXMLInjector(actionName, fileSelected, currentMetamodel, "MDR"));
                        continue;
                    }
                    if (!currentInjector.eClass().getName().equals("EBNFInjector") || !extension.equals(AM3CorePlugin.getDefault().getHandler().get(currentInjector, "extension")) || (mmUri = (String)AM3CorePlugin.getDefault().getHandler().get(currentMetamodel, "uri")).substring(mmUri.length() - 3, mmUri.length()).equals("xmi")) continue;
                    menu.add((IContributionItem)new Separator("settings"));
                    mmName = (String)AM3CorePlugin.getDefault().getHandler().get(currentInjector, "name");
                    actionName = "Inject " + mmName + " file to " + mmName + " model";
                    menu.add((IAction)new ActionEBNFInjector(actionName, fileSelected, currentInjector, currentMetamodel));
                }
            }
        }
    }
}

