/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common.util;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodSpec;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class PodHelper {
    private PodHelper() {
    }

    public static boolean firstContainerHasEnvVars(Pod pod, Map<String, String> envVars) {
        List containers = Optional.ofNullable(pod).map(Pod::getSpec).map(PodSpec::getContainers).orElse(Collections.emptyList());
        return envVars.entrySet().stream().allMatch(e -> PodHelper.firstContainerHasEnvVar(containers, (String)e.getKey(), (String)e.getValue()));
    }

    public static boolean firstContainerHasEnvVars(List<Container> containers, Map<String, String> envVars) {
        return envVars.entrySet().stream().allMatch(e -> PodHelper.firstContainerHasEnvVar(containers, (String)e.getKey(), (String)e.getValue()));
    }

    public static boolean firstContainerHasEnvVar(List<Container> containers, String name, String value) {
        Container container;
        List env;
        if (containers != null && !containers.isEmpty() && (env = (container = containers.get(0)).getEnv()) != null) {
            return env.stream().anyMatch(e -> e.getName().equals(name) && e.getValue().equals(value));
        }
        return false;
    }
}

