/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.Assembly;
import org.eclipse.jkube.kit.common.AssemblyFile;
import org.eclipse.jkube.kit.common.AssemblyMode;
import org.eclipse.jkube.kit.common.JKubeConfiguration;
import org.eclipse.jkube.kit.common.util.JKubeProjectUtil;

public class AssemblyConfiguration
implements Serializable {
    private String name;
    private String targetDir;
    private Boolean exportTargetDir;
    private boolean excludeFinalOutputArtifact;
    private PermissionMode permissions;
    private AssemblyMode mode;
    private String user;
    private String tarLongFileMode;
    @Deprecated
    private Assembly inline;
    private List<Assembly> layers;
    private boolean flattened;

    public AssemblyMode getMode() {
        return this.mode != null ? this.mode : AssemblyMode.dir;
    }

    public String getModeRaw() {
        return this.mode != null ? this.mode.name() : null;
    }

    public PermissionMode getPermissions() {
        return this.permissions != null ? this.permissions : PermissionMode.keep;
    }

    public String getPermissionsRaw() {
        return this.permissions != null ? this.permissions.name() : null;
    }

    @Deprecated
    public Assembly getInline() {
        return Optional.ofNullable(this.getLayers()).filter(l -> !l.isEmpty()).map(l -> (Assembly)l.get(l.size() - 1)).orElse(null);
    }

    @Deprecated
    public void setInline(Assembly inline) {
        this.inline = inline;
    }

    @Nonnull
    public List<Assembly> getLayers() {
        ArrayList<Assembly> ret = new ArrayList<Assembly>();
        if (this.layers != null) {
            ret.addAll(this.layers);
        }
        if (this.inline != null) {
            ret.add(this.inline);
        }
        return ret;
    }

    @Nonnull
    public List<Assembly> getProcessedLayers(@Nonnull JKubeConfiguration configuration) {
        List<Assembly> originalLayers = this.getLayers();
        if (this.flattened) {
            return originalLayers;
        }
        ArrayList<Assembly> ret = new ArrayList<Assembly>();
        if (originalLayers.size() == 1 && StringUtils.isBlank((CharSequence)originalLayers.iterator().next().getId())) {
            ret.add(originalLayers.iterator().next().toBuilder().id("jkube-generated-layer-original").build());
        } else {
            ret.addAll(originalLayers);
        }
        File finalArtifactFile = JKubeProjectUtil.getFinalOutputArtifact(configuration.getProject());
        if (!this.isExcludeFinalOutputArtifact() && finalArtifactFile != null) {
            ret.add(Assembly.builder().id("jkube-generated-layer-final-artifact").file(AssemblyFile.builder().source(finalArtifactFile).destName(finalArtifactFile.getName()).outputDirectory(new File(".")).build()).build());
        }
        return ret;
    }

    @Nonnull
    private Assembly getLayersFlattened(@Nonnull JKubeConfiguration configuration) {
        Assembly.AssemblyBuilder assemblyBuilder = Assembly.builder();
        this.getProcessedLayers(configuration).forEach(layer -> {
            if (layer.getFileSets() != null) {
                layer.getFileSets().forEach(assemblyBuilder::fileSet);
            }
            if (layer.getFiles() != null) {
                layer.getFiles().forEach(assemblyBuilder::file);
            }
        });
        return assemblyBuilder.build();
    }

    @Nonnull
    public AssemblyConfiguration getFlattenedClone(@Nonnull JKubeConfiguration configuration) {
        if (this.isFlattened()) {
            throw new IllegalStateException("This image has already been flattened, you can only flatten the image once");
        }
        return this.toBuilder().flattened(true).inline(null).clearLayers().layer(this.getLayersFlattened(configuration)).build();
    }

    public static AssemblyConfigurationBuilder builder() {
        return new AssemblyConfigurationBuilder();
    }

    public AssemblyConfigurationBuilder toBuilder() {
        AssemblyConfigurationBuilder builder = new AssemblyConfigurationBuilder().name(this.name).targetDir(this.targetDir).exportTargetDir(this.exportTargetDir).excludeFinalOutputArtifact(this.excludeFinalOutputArtifact).permissions(this.permissions).mode(this.mode).user(this.user).tarLongFileMode(this.tarLongFileMode).inline(this.inline).flattened(this.flattened);
        if (this.layers != null) {
            builder.layers(this.layers);
        }
        return builder;
    }

    public AssemblyConfiguration(String name, String targetDir, Boolean exportTargetDir, boolean excludeFinalOutputArtifact, PermissionMode permissions, AssemblyMode mode, String user, String tarLongFileMode, Assembly inline, List<Assembly> layers, boolean flattened) {
        this.name = name;
        this.targetDir = targetDir;
        this.exportTargetDir = exportTargetDir;
        this.excludeFinalOutputArtifact = excludeFinalOutputArtifact;
        this.permissions = permissions;
        this.mode = mode;
        this.user = user;
        this.tarLongFileMode = tarLongFileMode;
        this.inline = inline;
        this.layers = layers;
        this.flattened = flattened;
    }

    public AssemblyConfiguration() {
    }

    public String getName() {
        return this.name;
    }

    public String getTargetDir() {
        return this.targetDir;
    }

    public Boolean getExportTargetDir() {
        return this.exportTargetDir;
    }

    public boolean isExcludeFinalOutputArtifact() {
        return this.excludeFinalOutputArtifact;
    }

    public String getUser() {
        return this.user;
    }

    public String getTarLongFileMode() {
        return this.tarLongFileMode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssemblyConfiguration)) {
            return false;
        }
        AssemblyConfiguration other = (AssemblyConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isExcludeFinalOutputArtifact() != other.isExcludeFinalOutputArtifact()) {
            return false;
        }
        if (this.isFlattened() != other.isFlattened()) {
            return false;
        }
        Boolean this$exportTargetDir = this.getExportTargetDir();
        Boolean other$exportTargetDir = other.getExportTargetDir();
        if (this$exportTargetDir == null ? other$exportTargetDir != null : !((Object)this$exportTargetDir).equals(other$exportTargetDir)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$targetDir = this.getTargetDir();
        String other$targetDir = other.getTargetDir();
        if (this$targetDir == null ? other$targetDir != null : !this$targetDir.equals(other$targetDir)) {
            return false;
        }
        PermissionMode this$permissions = this.getPermissions();
        PermissionMode other$permissions = other.getPermissions();
        if (this$permissions == null ? other$permissions != null : !((Object)((Object)this$permissions)).equals((Object)other$permissions)) {
            return false;
        }
        AssemblyMode this$mode = this.getMode();
        AssemblyMode other$mode = other.getMode();
        if (this$mode == null ? other$mode != null : !((Object)((Object)this$mode)).equals((Object)other$mode)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$tarLongFileMode = this.getTarLongFileMode();
        String other$tarLongFileMode = other.getTarLongFileMode();
        if (this$tarLongFileMode == null ? other$tarLongFileMode != null : !this$tarLongFileMode.equals(other$tarLongFileMode)) {
            return false;
        }
        Assembly this$inline = this.getInline();
        Assembly other$inline = other.getInline();
        if (this$inline == null ? other$inline != null : !((Object)this$inline).equals(other$inline)) {
            return false;
        }
        List<Assembly> this$layers = this.getLayers();
        List<Assembly> other$layers = other.getLayers();
        return !(this$layers == null ? other$layers != null : !((Object)this$layers).equals(other$layers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AssemblyConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isExcludeFinalOutputArtifact() ? 79 : 97);
        result = result * 59 + (this.isFlattened() ? 79 : 97);
        Boolean $exportTargetDir = this.getExportTargetDir();
        result = result * 59 + ($exportTargetDir == null ? 43 : ((Object)$exportTargetDir).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $targetDir = this.getTargetDir();
        result = result * 59 + ($targetDir == null ? 43 : $targetDir.hashCode());
        PermissionMode $permissions = this.getPermissions();
        result = result * 59 + ($permissions == null ? 43 : ((Object)((Object)$permissions)).hashCode());
        AssemblyMode $mode = this.getMode();
        result = result * 59 + ($mode == null ? 43 : ((Object)((Object)$mode)).hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        String $tarLongFileMode = this.getTarLongFileMode();
        result = result * 59 + ($tarLongFileMode == null ? 43 : $tarLongFileMode.hashCode());
        Assembly $inline = this.getInline();
        result = result * 59 + ($inline == null ? 43 : ((Object)$inline).hashCode());
        List<Assembly> $layers = this.getLayers();
        result = result * 59 + ($layers == null ? 43 : ((Object)$layers).hashCode());
        return result;
    }

    private boolean isFlattened() {
        return this.flattened;
    }

    private void setFlattened(boolean flattened) {
        this.flattened = flattened;
    }

    public static enum PermissionMode {
        auto,
        exec,
        keep,
        ignore;

    }

    public static class AssemblyConfigurationBuilder {
        private String name;
        private String targetDir;
        private Boolean exportTargetDir;
        private boolean excludeFinalOutputArtifact;
        private PermissionMode permissions;
        private AssemblyMode mode;
        private String user;
        private String tarLongFileMode;
        private Assembly inline;
        private ArrayList<Assembly> layers;
        private boolean flattened;

        private AssemblyConfigurationBuilder flattened(boolean flattened) {
            this.flattened = flattened;
            return this;
        }

        public AssemblyConfigurationBuilder permissionsString(String permissionsString) {
            this.permissions = Optional.ofNullable(permissionsString).map(String::toLowerCase).map(PermissionMode::valueOf).orElse(null);
            return this;
        }

        public AssemblyConfigurationBuilder modeString(String modeString) {
            this.mode = Optional.ofNullable(modeString).map(String::toLowerCase).map(AssemblyMode::valueOf).orElse(null);
            return this;
        }

        AssemblyConfigurationBuilder() {
        }

        public AssemblyConfigurationBuilder name(String name) {
            this.name = name;
            return this;
        }

        public AssemblyConfigurationBuilder targetDir(String targetDir) {
            this.targetDir = targetDir;
            return this;
        }

        public AssemblyConfigurationBuilder exportTargetDir(Boolean exportTargetDir) {
            this.exportTargetDir = exportTargetDir;
            return this;
        }

        public AssemblyConfigurationBuilder excludeFinalOutputArtifact(boolean excludeFinalOutputArtifact) {
            this.excludeFinalOutputArtifact = excludeFinalOutputArtifact;
            return this;
        }

        public AssemblyConfigurationBuilder permissions(PermissionMode permissions) {
            this.permissions = permissions;
            return this;
        }

        public AssemblyConfigurationBuilder mode(AssemblyMode mode) {
            this.mode = mode;
            return this;
        }

        public AssemblyConfigurationBuilder user(String user) {
            this.user = user;
            return this;
        }

        public AssemblyConfigurationBuilder tarLongFileMode(String tarLongFileMode) {
            this.tarLongFileMode = tarLongFileMode;
            return this;
        }

        @Deprecated
        public AssemblyConfigurationBuilder inline(Assembly inline) {
            this.inline = inline;
            return this;
        }

        public AssemblyConfigurationBuilder layer(Assembly layer) {
            if (this.layers == null) {
                this.layers = new ArrayList();
            }
            this.layers.add(layer);
            return this;
        }

        public AssemblyConfigurationBuilder layers(Collection<? extends Assembly> layers) {
            if (layers == null) {
                throw new NullPointerException("layers cannot be null");
            }
            if (this.layers == null) {
                this.layers = new ArrayList();
            }
            this.layers.addAll(layers);
            return this;
        }

        public AssemblyConfigurationBuilder clearLayers() {
            if (this.layers != null) {
                this.layers.clear();
            }
            return this;
        }

        public AssemblyConfiguration build() {
            List<Assembly> layers;
            switch (this.layers == null ? 0 : this.layers.size()) {
                case 0: {
                    layers = Collections.emptyList();
                    break;
                }
                case 1: {
                    layers = Collections.singletonList(this.layers.get(0));
                    break;
                }
                default: {
                    layers = Collections.unmodifiableList(new ArrayList<Assembly>(this.layers));
                }
            }
            return new AssemblyConfiguration(this.name, this.targetDir, this.exportTargetDir, this.excludeFinalOutputArtifact, this.permissions, this.mode, this.user, this.tarLongFileMode, this.inline, layers, this.flattened);
        }

        public String toString() {
            return "AssemblyConfiguration.AssemblyConfigurationBuilder(name=" + this.name + ", targetDir=" + this.targetDir + ", exportTargetDir=" + this.exportTargetDir + ", excludeFinalOutputArtifact=" + this.excludeFinalOutputArtifact + ", permissions=" + (Object)((Object)this.permissions) + ", mode=" + (Object)((Object)this.mode) + ", user=" + this.user + ", tarLongFileMode=" + this.tarLongFileMode + ", inline=" + this.inline + ", layers=" + this.layers + ", flattened=" + this.flattened + ")";
        }
    }
}

