/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.quarkus.enricher;

import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.ProbeBuilder;
import io.fabric8.kubernetes.api.model.ProbeFluent;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.common.util.FileUtil;
import org.eclipse.jkube.kit.enricher.api.EnricherContext;
import org.eclipse.jkube.kit.enricher.api.JKubeEnricherContext;
import org.eclipse.jkube.kit.enricher.specific.AbstractHealthCheckEnricher;

public class QuarkusHealthCheckEnricher
extends AbstractHealthCheckEnricher {
    private static final String READY_SUBPATH = "ready";
    private static final String LIVE_SUBPATH = "live";

    public QuarkusHealthCheckEnricher(JKubeEnricherContext buildContext) {
        super((EnricherContext)buildContext, "jkube-healthcheck-quarkus");
    }

    protected Probe getReadinessProbe() {
        return this.discoverQuarkusHealthCheck(Configs.asInteger((String)this.getConfig(Config.READINESS_INTIAL_DELAY, "5")), READY_SUBPATH);
    }

    protected Probe getLivenessProbe() {
        return this.discoverQuarkusHealthCheck(Configs.asInteger((String)this.getConfig(Config.LIVENESS_INITIAL_DELAY, "10")), LIVE_SUBPATH);
    }

    private Probe discoverQuarkusHealthCheck(int initialDelay, String subPath) {
        if (!this.getContext().hasDependency("io.quarkus", "quarkus-smallrye-health")) {
            return null;
        }
        return ((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)((ProbeFluent.HttpGetNested)((ProbeFluent.HttpGetNested)((ProbeFluent.HttpGetNested)new ProbeBuilder().withNewHttpGet().withNewPort(Configs.asInteger((String)this.getConfig(Config.PORT)))).withPath(String.format("/%s/%s", FileUtil.stripPrefix((String)this.getConfig(Config.HEALTH_PATH), (String)"/"), subPath))).withScheme(this.getConfig(Config.SCHEME))).endHttpGet()).withFailureThreshold(Configs.asInteger((String)this.getConfig(Config.FAILURE_THRESHOLD)))).withSuccessThreshold(Configs.asInteger((String)this.getConfig(Config.SUCCESS_THRESHOLD)))).withInitialDelaySeconds(Integer.valueOf(initialDelay))).build();
    }

    private static enum Config implements Configs.Config
    {
        SCHEME("scheme", "HTTP"),
        PORT("port", "8080"),
        FAILURE_THRESHOLD("failureThreshold", "3"),
        SUCCESS_THRESHOLD("successThreshold", "1"),
        LIVENESS_INITIAL_DELAY("livenessInitialDelay", null),
        READINESS_INTIAL_DELAY("readinessIntialDelay", null),
        HEALTH_PATH("path", "health");

        protected String key;
        protected String defaultValue;

        private Config(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        public String getKey() {
            return this.key;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

