/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.net.URL;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.eclipse.jkube.kit.common.KitLogger;

public class IoUtil {
    private static final Random RANDOM = new Random();
    private static int PROGRESS_LENGTH = 50;

    public static void download(KitLogger log, URL downloadUrl, File target) throws IOException {
        log.progressStart();
        try {
            OkHttpClient client = new OkHttpClient.Builder().readTimeout(30L, TimeUnit.MINUTES).build();
            Request request = new Request.Builder().url(downloadUrl).build();
            Response response = client.newCall(request).execute();
            try (FileOutputStream out = new FileOutputStream(target);
                 InputStream im = response.body().byteStream();){
                long length = response.body().contentLength();
                InputStream in = response.body().byteStream();
                byte[] buffer = new byte[8192];
                long readBytes = 0L;
                while (true) {
                    int len = in.read(buffer);
                    log.progressUpdate(target.getName(), "Downloading", IoUtil.getProgressBar(readBytes += (long)len, length));
                    if (len <= 0) {
                        out.flush();
                        break;
                    }
                    ((OutputStream)out).write(buffer, 0, len);
                }
            }
        }
        catch (IOException e) {
            throw new IOException("Failed to download URL " + downloadUrl + " to  " + target + ": " + e, e);
        }
        finally {
            log.progressFinished();
        }
    }

    public static int getFreeRandomPort() {
        return IoUtil.getFreeRandomPort(49152, 65535, 100);
    }

    public static int getFreeRandomPort(int min, int max, int attempts) {
        for (int i = 0; i < attempts; ++i) {
            int port = min + RANDOM.nextInt(max - min + 1);
            try {
                Socket socket = new Socket("localhost", port);
                Throwable throwable = null;
                if (socket == null) continue;
                if (throwable != null) {
                    try {
                        socket.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    continue;
                }
                socket.close();
                continue;
            }
            catch (ConnectException e) {
                return port;
            }
            catch (IOException e) {
                throw new IllegalStateException("Error while trying to check open ports", e);
            }
        }
        throw new IllegalStateException("Cannot find a free random port in the range [" + min + ", " + max + "] after " + attempts + " attempts");
    }

    public static String sanitizeFileName(String name) {
        if (name != null) {
            return name.replaceAll("[^A-Za-z0-9]+", "-");
        }
        return null;
    }

    private static String getProgressBar(long bytesRead, long length) {
        StringBuffer ret = new StringBuffer("[");
        if (length > -1L) {
            int bucketSize = (int)((double)(length / (long)PROGRESS_LENGTH) + 0.5);
            int index = (int)((double)(bytesRead / (long)bucketSize) + 0.5);
            for (int i = 0; i < PROGRESS_LENGTH; ++i) {
                ret.append(i < index ? "=" : (i == index ? ">" : " "));
            }
            ret.append(String.format("] %.2f MB/%.2f MB", Float.valueOf((float)bytesRead / 1048576.0f), Float.valueOf((float)length / 1048576.0f)));
        } else {
            int bucketSize = 204800;
            int index = (int)((double)(bytesRead / (long)bucketSize) + 0.5) % PROGRESS_LENGTH;
            for (int i = 0; i < PROGRESS_LENGTH; ++i) {
                ret.append(i == index ? "*" : " ");
            }
            ret.append("]");
        }
        return ret.toString();
    }
}

