/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.common.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jkube.kit.common.KitLogger;
import org.eclipse.jkube.kit.common.util.IoUtil;

public class FileUtil {
    private FileUtil() {
    }

    public static File createTempDirectory() {
        try {
            return Files.createTempDirectory("jkube", new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static File getRelativePath(File baseDir, File file) {
        Path baseDirPath = Paths.get(baseDir.getAbsolutePath(), new String[0]);
        Path filePath = Paths.get(file.getAbsolutePath(), new String[0]);
        return baseDirPath.relativize(filePath).toFile();
    }

    public static String stripPrefix(String text, String prefix) {
        if (text.startsWith(prefix)) {
            return text.substring(prefix.length());
        }
        return text;
    }

    public static String stripPostfix(String text, String postfix) {
        if (text.endsWith(postfix)) {
            return text.substring(0, text.length() - postfix.length());
        }
        return text;
    }

    public static String getAbsolutePath(String fileName) {
        return Paths.get(fileName, new String[0]).toAbsolutePath().toString();
    }

    public static String getAbsolutePath(URL url) {
        try {
            return url != null ? Paths.get(url.toURI()).toAbsolutePath().toString() : null;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static void downloadRemotes(File outputDirectory, List<String> remotes, KitLogger log) {
        if (!outputDirectory.exists()) {
            try {
                Files.createDirectories(outputDirectory.toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
        remotes.stream().map(remote -> {
            try {
                return new URL((String)remote);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e);
            }
        }).forEach(url -> {
            try {
                IoUtil.download(log, url, new File(outputDirectory, FileUtil.getOutputName(url)));
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        });
    }

    private static String getOutputName(URL url) {
        String path = url.getPath();
        int slashIndex = path.lastIndexOf(47);
        if (slashIndex >= 0) {
            return path.substring(slashIndex + 1);
        }
        throw new IllegalArgumentException(String.format("URL %s should contain a name file to be downloaded.", url.toString()));
    }

    public static void cleanDirectory(File directoryFile) throws IOException {
        Path directory = Paths.get(directoryFile.getAbsolutePath(), new String[0]);
        Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static ArrayList<String> fileReadArray(File file) throws IOException {
        ArrayList<String> lineList = new ArrayList<String>();
        try (Stream<String> lines = Files.lines(Paths.get(file.getAbsolutePath(), new String[0]), Charset.defaultCharset());){
            lines.forEachOrdered(line -> lineList.add((String)line));
        }
        return lineList;
    }

    public static final String getRelativeFilePath(String oldPath, String newPath) {
        if (StringUtils.isEmpty((CharSequence)oldPath) || StringUtils.isEmpty((CharSequence)newPath)) {
            return "";
        }
        String fromPath = new File(oldPath).getPath();
        String toPath = new File(newPath).getPath();
        if (toPath.matches("^\\[a-zA-Z]:")) {
            toPath = toPath.substring(1);
        }
        if (fromPath.matches("^\\[a-zA-Z]:")) {
            fromPath = fromPath.substring(1);
        }
        if (fromPath.startsWith(":", 1)) {
            fromPath = Character.toLowerCase(fromPath.charAt(0)) + fromPath.substring(1);
        }
        if (toPath.startsWith(":", 1)) {
            toPath = Character.toLowerCase(toPath.charAt(0)) + toPath.substring(1);
        }
        if (toPath.startsWith(":", 1) && fromPath.startsWith(":", 1) && !toPath.substring(0, 1).equals(fromPath.substring(0, 1))) {
            return null;
        }
        if (toPath.startsWith(":", 1) && !fromPath.startsWith(":", 1) || !toPath.startsWith(":", 1) && fromPath.startsWith(":", 1)) {
            return null;
        }
        String resultPath = FileUtil.buildRelativePath(toPath, fromPath, File.separatorChar);
        if (newPath.endsWith(File.separator) && !resultPath.endsWith(File.separator)) {
            return resultPath + File.separator;
        }
        return resultPath;
    }

    private static String buildRelativePath(String toPath, String fromPath, char separatorChar) {
        StringTokenizer toTokeniser = new StringTokenizer(toPath, String.valueOf(separatorChar));
        StringTokenizer fromTokeniser = new StringTokenizer(fromPath, String.valueOf(separatorChar));
        int count = 0;
        while (toTokeniser.hasMoreTokens() && fromTokeniser.hasMoreTokens() && !(separatorChar == '\\' ? !fromTokeniser.nextToken().equalsIgnoreCase(toTokeniser.nextToken()) : !fromTokeniser.nextToken().equals(toTokeniser.nextToken()))) {
            ++count;
        }
        toTokeniser = new StringTokenizer(toPath, String.valueOf(separatorChar));
        fromTokeniser = new StringTokenizer(fromPath, String.valueOf(separatorChar));
        while (count-- > 0) {
            fromTokeniser.nextToken();
            toTokeniser.nextToken();
        }
        String relativePath = "";
        while (fromTokeniser.hasMoreTokens()) {
            fromTokeniser.nextToken();
            relativePath = relativePath + "..";
            if (!fromTokeniser.hasMoreTokens()) continue;
            relativePath = relativePath + separatorChar;
        }
        if (relativePath.length() != 0 && toTokeniser.hasMoreTokens()) {
            relativePath = relativePath + separatorChar;
        }
        while (toTokeniser.hasMoreTokens()) {
            relativePath = relativePath + toTokeniser.nextToken();
            if (!toTokeniser.hasMoreTokens()) continue;
            relativePath = relativePath + separatorChar;
        }
        return relativePath;
    }

    public static void copy(File sourceFile, File targetFile) throws IOException {
        FileUtil.copy(Paths.get(sourceFile.getAbsolutePath(), new String[0]), Paths.get(targetFile.getAbsolutePath(), new String[0]));
    }

    public static void copy(Path sourcePath, Path targetPath) throws IOException {
        Files.copy(sourcePath, targetPath, StandardCopyOption.REPLACE_EXISTING);
    }

    public static void copyDirectoryIfNotExists(File sourceDir, File targetDir) throws IOException {
        if (targetDir.exists() && targetDir.isDirectory() && !FileUtil.isDirEmpty(targetDir.toPath())) {
            return;
        }
        Path sourcePath = sourceDir.toPath();
        try (Stream<Path> sourceTree = Files.walk(sourcePath, new FileVisitOption[0]);){
            for (Path source : sourceTree.collect(Collectors.toList())) {
                Path target = targetDir.toPath().resolve(sourcePath.relativize(source));
                Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
            }
        }
    }

    private static boolean isDirEmpty(Path directory) throws IOException {
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(directory);){
            boolean bl = !dirStream.iterator().hasNext();
            return bl;
        }
    }

    public static String trimWildcardCharactersFromPath(String filePath) {
        if (!filePath.endsWith("*")) {
            return filePath;
        }
        int charIndex = filePath.length() - 1;
        while (filePath.charAt(charIndex) == '*') {
            --charIndex;
        }
        return filePath.substring(0, charIndex);
    }

    public static List<File> listFilesRecursivelyInDirectory(File directory) {
        return new ArrayList<File>(FileUtils.listFiles((File)directory, (IOFileFilter)new RegexFileFilter("^(.*?)"), (IOFileFilter)DirectoryFileFilter.DIRECTORY));
    }

    public static void createDirectory(File directory) throws IOException {
        boolean isCreated;
        if (!directory.exists() && !(isCreated = directory.mkdirs())) {
            throw new IOException("Failed to create directory: " + directory.getAbsolutePath());
        }
    }
}

